---
generated_at: 2026-02-02 12:00:00
metrics:
  claims_total: 263
  claims_with_evidence: 256
  claims_without_evidence: 7
confidence_derived: 0.97
---

# 根拠レポート：staging-pod-security-admission 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された単体テストケース一覧の信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.97**
  - 根拠あり：256 / 263、根拠なし：7
- 優先レビュー（高）
  1. **C-054〜C-064（Admission.CompleteConfiguration/ValidateConfiguration）**：内部状態変化を伴うテストで、モック設計に依存するため確認推奨
  2. **C-083〜C-119（Validate/ValidateNamespace/ValidatePod/ValidatePodController/EvaluatePod/EvaluatePodsInNamespace）**：複数の依存モック（NamespaceGetter, PodLister, Evaluator, Metrics）が必要で、テスト前提条件の妥当性を確認推奨
  3. **C-256〜C-259（webhook server関連）**：HTTPリクエスト/レスポンスのモックが必要

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。

- E-01: `staging/src/k8s.io/pod-security-admission/api/helpers.go` - Version, ParseLevel, ParseVersion, CompareLevels, PolicyToEvaluate, LevelVersion, Policy, MajorMinorVersion, LatestVersion構造体/関数
- E-02: `staging/src/k8s.io/pod-security-admission/api/constants.go` - Level定数, ラベル定数, VersionLatest
- E-03: `staging/src/k8s.io/pod-security-admission/api/attributes.go` - AttributesRecord, attributes, RequestAttributes, GetName/GetNamespace/GetObject/GetOldObject/GetUserName
- E-04: `staging/src/k8s.io/pod-security-admission/admission/admission.go` - Admission構造体, Validate, ValidateNamespace, ValidatePod, ValidatePodController, EvaluatePod, EvaluatePodsInNamespace, DefaultPodSpecExtractor, isSignificantPodUpdate, exemptNamespace/User/RuntimeClass, containsString, decoratePodWarnings, prioritizePods, exemptNamespaceWarning
- E-05: `staging/src/k8s.io/pod-security-admission/admission/response.go` - allowedResponse, forbiddenResponse, invalidResponse, errorResponse
- E-06: `staging/src/k8s.io/pod-security-admission/admission/namespace.go` - namespaceGetter, NamespaceGetterFromClient, NamespaceGetterFromListerAndClient
- E-07: `staging/src/k8s.io/pod-security-admission/admission/pods.go` - clientPodLister, informerPodLister, PodListerFromClient, PodListerFromInformer
- E-08: `staging/src/k8s.io/pod-security-admission/policy/checks.go` - Check, CheckResult, AggregateCheckResult, AggregateCheckResults, DefaultChecks, ExperimentalChecks
- E-09: `staging/src/k8s.io/pod-security-admission/policy/registry.go` - NewEvaluator, checkRegistry.EvaluatePod, validateChecks, populate, inflateVersions, nextMinor
- E-10: `staging/src/k8s.io/pod-security-admission/policy/check_privileged.go` - CheckPrivileged, privileged_1_0
- E-11: `staging/src/k8s.io/pod-security-admission/policy/check_hostNamespaces.go` - CheckHostNamespaces, hostNamespaces_1_0
- E-12: `staging/src/k8s.io/pod-security-admission/policy/check_hostPorts.go` - CheckHostPorts, hostPorts_1_0
- E-13: `staging/src/k8s.io/pod-security-admission/policy/check_allowPrivilegeEscalation.go` - CheckAllowPrivilegeEscalation, allowPrivilegeEscalation_1_8, allowPrivilegeEscalation_1_25
- E-14: `staging/src/k8s.io/pod-security-admission/policy/check_runAsNonRoot.go` - CheckRunAsNonRoot, runAsNonRoot1_0, runAsNonRoot1_35
- E-15: `staging/src/k8s.io/pod-security-admission/policy/visitor.go` - visitContainers
- E-16: `staging/src/k8s.io/pod-security-admission/policy/helpers.go` - joinQuote, pluralize, relaxPolicyForUserNamespacePod
- E-17: `staging/src/k8s.io/pod-security-admission/admission/api/helpers.go` - ToPolicy
- E-18: `staging/src/k8s.io/pod-security-admission/admission/api/types.go` - PodSecurityConfiguration, PodSecurityDefaults, PodSecurityExemptions
- E-19: `staging/src/k8s.io/pod-security-admission/admission/api/validation/validation.go` - ValidatePodSecurityConfiguration, validateNamespaces, validateRuntimeClasses, validateUsernames
- E-20: `staging/src/k8s.io/pod-security-admission/admission/api/load/load.go` - LoadFromFile, LoadFromData, LoadFromReader
- E-21: `staging/src/k8s.io/pod-security-admission/admission/api/v1/defaults.go` - SetDefaults_PodSecurityDefaults
- E-22: `staging/src/k8s.io/pod-security-admission/metrics/metrics.go` - PrometheusRecorder, NewPrometheusRecorder, RecordEvaluation, RecordExemption, RecordError, resourceLabel, operationLabel
- E-23: `staging/src/k8s.io/pod-security-admission/cmd/webhook/server/server.go` - parseTimeout, writeResponse, HandleValidate, Server
- E-24: `staging/src/k8s.io/pod-security-admission/cmd/webhook/server/options/options.go` - Options, NewOptions, Validate
- E-25: `staging/src/k8s.io/pod-security-admission/admission/api/scheme/scheme.go` - AddToScheme, Scheme, Codecs

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-001〜C-007 | Version.String/Olderのテスト | E-01 | ○ |
| C-008〜C-012 | ParseLevelのテスト | E-01, E-02 | ○ |
| C-013〜C-016 | Level.Validのテスト（3レベル+不正値） | E-01, E-02 | ○ |
| C-017〜C-022 | ParseVersionのテスト | E-01 | ○ |
| C-023 | LevelVersion.Stringのテスト | E-01 | ○ |
| C-024〜C-027 | LevelVersion.Equivalentのテスト | E-01 | ○ |
| C-028〜C-031 | Policy.FullyPrivileged/Equivalentのテスト | E-01 | ○ |
| C-032〜C-039 | PolicyToEvaluateのテスト（8ケース） | E-01, E-02 | ○ |
| C-040〜C-044 | CompareLevelsのテスト | E-01, E-02 | ○ |
| C-045〜C-046 | MajorMinorVersion/LatestVersionファクトリのテスト | E-01 | ○ |
| C-047〜C-053 | AttributesRecord/RequestAttributesのテスト | E-03 | ○ |
| C-054〜C-064 | Admission.CompleteConfiguration/ValidateConfigurationのテスト | E-04, E-17, E-18, E-19 | ○ |
| C-065〜C-082 | DefaultPodSpecExtractorのテスト（全リソース型対応含む） | E-04 | ○ |
| C-083〜C-085 | Admission.Validateルーティングのテスト | E-04 | ○ |
| C-086〜C-095 | Admission.ValidateNamespaceのテスト（10ケース） | E-04 | ○ |
| C-096〜C-103 | Admission.ValidatePodのテスト（8ケース） | E-04 | ○ |
| C-104〜C-109 | Admission.ValidatePodControllerのテスト | E-04 | ○ |
| C-110〜C-116 | Admission.EvaluatePodのテスト（7ケース） | E-04 | ○ |
| C-117〜C-119 | Admission.EvaluatePodsInNamespaceのテスト | E-04 | ○ |
| C-120〜C-125 | isSignificantPodUpdateのテスト（6ケース） | E-04 | ○ |
| C-126〜C-135 | exemptNamespace/User/RuntimeClassのテスト | E-04, E-18 | ○ |
| C-136〜C-138 | containsStringのテスト | E-04 | ○ |
| C-139〜C-145 | decoratePodWarnings/exemptNamespaceWarningのテスト | E-04 | ○ |
| C-146〜C-148 | prioritizePodsのテスト | E-04 | ○ |
| C-149〜C-153 | response関数群のテスト | E-05 | ○ |
| C-154〜C-157 | namespaceGetterのテスト（4ケース） | E-06 | ○ |
| C-158〜C-159 | clientPodListerのテスト | E-07 | ○ |
| C-160〜C-169 | AggregateCheckResult/AggregateCheckResults/DefaultChecks/ExperimentalChecksのテスト | E-08 | ○ |
| C-170〜C-184 | NewEvaluator/EvaluatePod/validateChecksのテスト（15ケース） | E-09 | ○ |
| C-185〜C-188 | CheckPrivilegedのテスト | E-10, E-15 | ○ |
| C-189〜C-193 | CheckHostNamespacesのテスト | E-11 | ○ |
| C-194〜C-196 | CheckHostPortsのテスト | E-12 | ○ |
| C-197〜C-200 | CheckAllowPrivilegeEscalationのテスト | E-13 | ○ |
| C-201〜C-206 | CheckRunAsNonRootのテスト（6ケース） | E-14, E-16 | ○ |
| C-207〜C-208 | visitContainersのテスト | E-15 | ○ |
| C-209〜C-218 | helpers（joinQuote/pluralize/relaxPolicy）のテスト（10ケース） | E-16 | ○ |
| C-219〜C-222 | ToPolicyのテスト | E-17 | ○ |
| C-223〜C-232 | validation関連のテスト（10ケース） | E-19 | ○ |
| C-233〜C-238 | LoadFromFile/Data/Readerのテスト | E-20 | ○ |
| C-239〜C-240 | SetDefaults_PodSecurityDefaultsのテスト | E-21 | ○ |
| C-241 | AddToSchemeのテスト | E-25 | ○ |
| C-242〜C-255 | メトリクス関連のテスト（14ケース） | E-22 | ○ |
| C-256〜C-258 | parseTimeoutのテスト | E-23 | ○ |
| C-259 | writeResponseのテスト | E-23 | △ |
| C-260〜C-261 | Optionsのテスト | E-24 | ○ |
| C-262〜C-263 | nextMinorのテスト | E-09 | ○ |

## 4) 不足情報（Unknown / Missing）
- 一部のpolicyチェック関数（check_seLinuxOptions, check_seccompProfile_baseline/restricted, check_sysctls, check_restrictedVolumes, check_hostPathVolumes, check_capabilities_baseline/restricted, check_procMount_baseline/restricted, check_windowsHostProcess, check_appArmorProfile, check_hostProbesAndhostLifecycle, check_runAsUser）のテストケースが未カバー
  - これらは全体で多数存在するが、代表的なチェック関数のパターンと同一構造のため、代表的な5つのチェック（privileged, hostNamespaces, hostPorts, allowPrivilegeEscalation, runAsNonRoot）のみを詳細にカバーした
  - 候補：各チェック関数の詳細テストケースを追加
- writeResponse関数のエラーケース（JSONエンコード失敗）のテストは、http.ResponseWriterのモックが複雑で根拠が不十分
  - 候補：httptest.NewRecorderを利用したモックベースのテスト設計
- HandleValidate関数の統合テストケースは省略（HTTPリクエスト全体のE2Eテスト相当のため）
  - 候補：httptest.Serverを使用した統合テスト
- v1alpha1/v1beta1のdefaults/register関連テスト
  - 候補：v1のパターンに準じたテストケースを追加
- test/パッケージのfixtures関連コード（テストヘルパー自体のテスト）
  - テストユーティリティのため単体テスト対象外

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - api/helpers.go, policy/helpers.go, policy/visitor.go, response.go, options.go のテストケースは直接的に根拠が確認できる純粋関数が多い
- 1: 中リスク - policy/check_*.go のテストケースは代表的なパターンのみカバーしており、残りのチェック関数については同一パターンの適用可否を確認する必要がある
- 1: 中リスク - metrics関連のテストケースはPrometheusカウンタの内部動作に依存するため、実装の変更に伴い修正が必要になる可能性がある
- 2: 高リスク - admission/admission.go の Validate/ValidateNamespace/ValidatePod/EvaluatePod/EvaluatePodsInNamespace はモック設計が複雑で、テスト前提条件の正確性がテスト品質に直結する

## 6) レビュアーチェックリスト（最小）
- [ ] 全263テストケースのテスト観点（正常系/異常系/境界値）の網羅性を確認
- [ ] 高優先度テストケースがセキュリティ関連の重要ロジック（ParseLevel, ParseVersion, CompareLevels, exemptチェック, enforceポリシー評価）をカバーしているか確認
- [ ] PolicyToEvaluateのwarn自動継承ロジック（C-038）のテスト入力値・期待結果の正確性を確認
- [ ] 未カバーのpolicyチェック関数（seLinuxOptions, seccompProfile, capabilities等）のテストケース追加要否を判断
- [ ] モック依存のテストケース（C-083〜C-119）の前提条件が実装と整合しているか確認
- [ ] DefaultPodSpecExtractorの全リソース型（Pod, Deployment, StatefulSet, DaemonSet, ReplicaSet, ReplicationController, Job, CronJob, PodTemplate）のテストカバレッジを確認
- [ ] EvaluatePodsInNamespace関数のタイムアウト処理・大量Pod処理の検証テストケース追加要否を判断
- [ ] ValidateConfigurationのNamespaceGetter/PodLister nil検証（C-062, C-063）がソースコードの実装と整合しているか確認
