---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 83
  claims_with_evidence: 80
  claims_without_evidence: 3
confidence_derived: 0.96
---

# 根拠レポート：staging-sample-apiserver 単体テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：80 / 83、根拠なし：3
- 優先レビュー（高）
  1. **C-76 (UT-SAA-076)**: WardleServerOptions.Validateの正常系テストケースは、RecommendedOptionsとComponentGlobalsRegistryの内部Validate実装に依存するため、期待結果の詳細な検証が困難
  2. **C-77 (UT-SAA-077)**: Complete()内のBanFlunderフィーチャーゲート有効時の動作は、ComponentGlobalsRegistryの状態に依存するため、テスト前提条件の正確な設定が必要
  3. **C-79 (UT-SAA-079)**: Config.Complete()はGenericAPIServer依存が強く、単体テストでのモック範囲が広い

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `staging/src/k8s.io/sample-apiserver/pkg/admission/plugin/banflunder/admission.go` - DisallowFlunder構造体、Admit/ValidateInitialization/SetInternalWardleInformerFactory/New/Register関数
- E-02: `staging/src/k8s.io/sample-apiserver/pkg/admission/wardleinitializer/wardleinitializer.go` - pluginInitializer構造体、Initialize/New関数
- E-03: `staging/src/k8s.io/sample-apiserver/pkg/admission/wardleinitializer/interfaces.go` - WantsInternalWardleInformerFactoryインターフェース
- E-04: `staging/src/k8s.io/sample-apiserver/pkg/apis/wardle/validation/validation.go` - ValidateFlunder/ValidateFlunderSpec関数
- E-05: `staging/src/k8s.io/sample-apiserver/pkg/apis/wardle/types.go` - Flunder/Fischer/FlunderSpec型定義、ReferenceType定数
- E-06: `staging/src/k8s.io/sample-apiserver/pkg/apis/wardle/register.go` - Kind/Resource/addKnownTypes/AddToScheme関数
- E-07: `staging/src/k8s.io/sample-apiserver/pkg/apis/wardle/v1alpha1/conversion.go` - Convert_v1alpha1_FlunderSpec_To_wardle_FlunderSpec/Convert_wardle_FlunderSpec_To_v1alpha1_FlunderSpec関数
- E-08: `staging/src/k8s.io/sample-apiserver/pkg/apis/wardle/v1alpha1/defaults.go` - SetDefaults_FlunderSpec関数
- E-09: `staging/src/k8s.io/sample-apiserver/pkg/apis/wardle/v1alpha1/register.go` - addKnownTypes/Resource関数
- E-10: `staging/src/k8s.io/sample-apiserver/pkg/apis/wardle/v1alpha1/types.go` - v1alpha1 FlunderSpec型定義（ReferenceType *ReferenceType）
- E-11: `staging/src/k8s.io/sample-apiserver/pkg/apis/wardle/install/install.go` - Install関数
- E-12: `staging/src/k8s.io/sample-apiserver/pkg/registry/registry.go` - REST構造体、RESTInPeace関数
- E-13: `staging/src/k8s.io/sample-apiserver/pkg/registry/wardle/fischer/strategy.go` - fischerStrategy、GetAttrs/MatchFischer/SelectableFields/NewStrategy関数
- E-14: `staging/src/k8s.io/sample-apiserver/pkg/registry/wardle/flunder/strategy.go` - flunderStrategy、GetAttrs/MatchFlunder/SelectableFields/NewStrategy関数
- E-15: `staging/src/k8s.io/sample-apiserver/pkg/cmd/server/start.go` - WardleVersionToKubeVersion/NewWardleServerOptions/Validate/Complete関数
- E-16: `staging/src/k8s.io/sample-apiserver/pkg/apiserver/apiserver.go` - Config/CompletedConfig/WardleServer構造体、Complete/New関数
- E-17: `staging/src/k8s.io/sample-apiserver/pkg/apis/wardle/fuzzer/fuzzer.go` - Funcs変数（fuzzer関数群）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Admit: Flunder以外のKindはnil返却 | E-01 (L54-56) | ○ |
| C-02 | Admit: 許可名はnil返却 | E-01 (L73-84) | ○ |
| C-03 | Admit: 禁止名はForbidden返却 | E-01 (L73-83) | ○ |
| C-04 | Admit: WaitForReady=falseでForbidden | E-01 (L58-59) | ○ |
| C-05 | Admit: meta.Accessorエラー伝搬 | E-01 (L62-65) | ○ |
| C-06 | Admit: Lister.Listエラー伝搬 | E-01 (L68-71) | ○ |
| C-07 | Admit: Fischer空リストでnil | E-01 (L73-84) | ○ |
| C-08 | Admit: DisallowedFlunders空でnil | E-01 (L73-84) | ○ |
| C-09 | Admit: 複数Fischer横断チェック | E-01 (L73-83) | ○ |
| C-10 | ValidateInitialization: lister設定済みでnil | E-01 (L95-99) | ○ |
| C-11 | ValidateInitialization: lister未設定でエラー | E-01 (L95-98) | ○ |
| C-12 | SetInternalWardleInformerFactory: lister設定 | E-01 (L89-92) | ○ |
| C-13 | New: DisallowFlunder生成 | E-01 (L103-107) | ○ |
| C-14 | Register: BanFlunder登録 | E-01 (L35-39) | ○ |
| C-15 | Initialize: 対応プラグインにFactory設定 | E-02 (L39-42) | ○ |
| C-16 | Initialize: 非対応プラグインは何もしない | E-02 (L40) | ○ |
| C-17 | New: pluginInitializer生成 | E-02 (L31-35) | ○ |
| C-18 | ValidateFlunder: 有効Flunderでエラー空 | E-04 (L25-31) | ○ |
| C-19 | ValidateFlunder: FlunderRef+Flunder型で正常 | E-04 (L37-47) | ○ |
| C-20 | ValidateFlunder: FischerRef+Fischer型で正常 | E-04 (L37-47) | ○ |
| C-21 | ValidateFlunderSpec: 同時設定でエラー | E-04 (L37-38) | ○ |
| C-22 | ValidateFlunderSpec: FlunderRef+非Flunder型でエラー | E-04 (L39-40) | ○ |
| C-23 | ValidateFlunderSpec: FischerRef+非Fischer型でエラー | E-04 (L41-42) | ○ |
| C-24 | ValidateFlunderSpec: Fischer空+Fischer型でエラー | E-04 (L43-44) | ○ |
| C-25 | ValidateFlunderSpec: Flunder空+Flunder型でエラー | E-04 (L45-46) | ○ |
| C-26 | ValidateFlunderSpec: 不正ReferenceTypeでエラー | E-04 (L49-51) | ○ |
| C-27 | ValidateFlunderSpec: 全空で正常 | E-04 (L37-51) | ○ |
| C-28 | Kind: GroupKind返却 | E-06 (L31-33) | ○ |
| C-29 | Resource: GroupResource返却 | E-06 (L36-38) | ○ |
| C-30 | addKnownTypes: 型登録 | E-06 (L48-56) | ○ |
| C-31 | v1alpha1->internal変換(Flunder) | E-07 (L25-39) | ○ |
| C-32 | v1alpha1->internal変換(Fischer) | E-07 (L25-39) | ○ |
| C-33 | v1alpha1->internal: ReferenceType nil | E-07 (L26) | ○ |
| C-34 | internal->v1alpha1変換(Flunder) | E-07 (L42-55) | ○ |
| C-35 | internal->v1alpha1変換(Fischer) | E-07 (L42-55) | ○ |
| C-36 | internal->v1alpha1: 空ReferenceType | E-07 (L43) | ○ |
| C-37 | SetDefaults: nil+Reference設定でデフォルト | E-08 (L28-33) | ○ |
| C-38 | SetDefaults: 空文字+Reference設定でデフォルト | E-08 (L29) | ○ |
| C-39 | SetDefaults: 既設定で変更なし | E-08 (L29) | ○ |
| C-40 | SetDefaults: Reference空で変更なし | E-08 (L29) | ○ |
| C-41 | v1alpha1 addKnownTypes: 型登録 | E-09 (L49-58) | ○ |
| C-42 | v1alpha1 Resource: GroupResource返却 | E-09 (L61-63) | ○ |
| C-43 | Install: 全スキーム登録+優先度 | E-11 (L28-33) | ○ |
| C-44 | RESTInPeace: err=nilでstorage返却 | E-12 (L33-39) | ○ |
| C-45 | RESTInPeace: err!=nilでpanic | E-12 (L34-37) | ○ |
| C-46 | fischerStrategy.NamespaceScoped: false | E-13 (L68-70) | ○ |
| C-47 | fischerStrategy.Validate: 空ErrorList | E-13 (L78-80) | ○ |
| C-48 | fischerStrategy.AllowCreateOnUpdate: false | E-13 (L85-87) | ○ |
| C-49 | fischerStrategy.AllowUnconditionalUpdate: false | E-13 (L89-91) | ○ |
| C-50 | fischerStrategy.ValidateUpdate: 空ErrorList | E-13 (L96-98) | ○ |
| C-51 | fischerStrategy.WarningsOnCreate: nil | E-13 (L83) | ○ |
| C-52 | fischerStrategy.WarningsOnUpdate: nil | E-13 (L101-103) | ○ |
| C-53 | fischer GetAttrs: 正常取得 | E-13 (L40-46) | ○ |
| C-54 | fischer GetAttrs: 型不一致エラー | E-13 (L42-43) | ○ |
| C-55 | MatchFischer: SelectionPredicate構成 | E-13 (L50-56) | ○ |
| C-56 | fischer SelectableFields: フィールドセット返却 | E-13 (L59-61) | ○ |
| C-57 | fischer NewStrategy: 生成 | E-13 (L35-37) | ○ |
| C-58 | flunderStrategy.NamespaceScoped: true | E-14 (L69-71) | ○ |
| C-59 | flunderStrategy.Validate: 有効で空 | E-14 (L79-82) | ○ |
| C-60 | flunderStrategy.Validate: 不正でエラー | E-14 (L79-82), E-04 | ○ |
| C-61 | flunderStrategy.AllowCreateOnUpdate: false | E-14 (L87-89) | ○ |
| C-62 | flunderStrategy.AllowUnconditionalUpdate: false | E-14 (L91-93) | ○ |
| C-63 | flunderStrategy.ValidateUpdate: 空ErrorList | E-14 (L98-100) | ○ |
| C-64 | flunderStrategy.WarningsOnCreate: nil | E-14 (L85) | ○ |
| C-65 | flunderStrategy.WarningsOnUpdate: nil | E-14 (L103-105) | ○ |
| C-66 | flunder GetAttrs: 正常取得 | E-14 (L41-47) | ○ |
| C-67 | flunder GetAttrs: 型不一致エラー | E-14 (L43-44) | ○ |
| C-68 | MatchFlunder: SelectionPredicate構成 | E-14 (L51-57) | ○ |
| C-69 | flunder SelectableFields: フィールドセット返却 | E-14 (L60-62) | ○ |
| C-70 | flunder NewStrategy: 生成 | E-14 (L36-38) | ○ |
| C-71 | WardleVersionToKubeVersion: Major=1で正常マッピング | E-15 (L66-78) | ○ |
| C-72 | WardleVersionToKubeVersion: Major!=1でnil | E-15 (L67-69) | ○ |
| C-73 | WardleVersionToKubeVersion: 上限クランプ | E-15 (L74-76) | ○ |
| C-74 | WardleVersionToKubeVersion: Minor=0 | E-15 (L72-73) | ○ |
| C-75 | NewWardleServerOptions: 初期化 | E-15 (L81-94) | ○ |
| C-76 | Validate: 有効オプションでnil | E-15 (L171-176) | △ |
| C-77 | Complete: BanFlunder有効でプラグイン登録 | E-15 (L179-188) | △ |
| C-78 | Complete: BanFlunder無効でプラグイン未登録 | E-15 (L180) | ○ |
| C-79 | Config.Complete: CompletedConfig返却 | E-16 (L88-95) | △ |
| C-80 | Fuzzer: FlunderRef設定時ReferenceType=Flunder | E-17 (L35-36) | ○ |
| C-81 | Fuzzer: FischerRef設定時ReferenceType=Fischer | E-17 (L37-38) | ○ |
| C-82 | Fuzzer: 両方空でReferenceType=空 | E-17 (L39-40) | ○ |
| C-83 | Fuzzer: 両方設定時FischerRefクリア | E-17 (L32-34) | ○ |

## 4) 不足情報（Unknown / Missing）
- C-76: WardleServerOptions.Validateの内部呼び出し先（RecommendedOptions.Validate, ComponentGlobalsRegistry.Validate）の具体的な検証結果は外部パッケージに依存しており、テスト時のモック範囲が不明確
  - 候補：RecommendedOptions / ComponentGlobalsRegistryのテスト実装を確認
- C-77: Complete()で参照するFeatureGateの状態設定方法は、ComponentGlobalsRegistryの初期化フローに依存する。単体テストでのフィーチャーゲート設定方法の確認が必要
  - 候補：ComponentGlobalsRegistryのテストヘルパー / featuregate.NewVersionedFeatureGateの利用
- C-79: Config.Complete()はGenericConfig.Complete()を呼び出すため、GenericAPIServerの完全な初期化が必要。単体テストでの適切なモック範囲の確認が必要
  - 候補：genericapiserver.RecommendedConfigのテストヘルパー確認

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - admission/plugin/banflunder (UT-SAA-001〜014): ソースコードの分岐が全て明確に特定でき、テストケースと1対1の対応がある
- 0: 低リスク - validation (UT-SAA-018〜027): バリデーションロジックの全分岐がif-else chainで明確に特定可能
- 0: 低リスク - conversion/defaults (UT-SAA-031〜040): 変換・デフォルト設定ロジックが明確
- 0: 低リスク - registry strategy (UT-SAA-046〜070): 戦略パターンの各メソッドが単純な値返却
- 1: 中リスク - cmd/server/start.go (UT-SAA-076〜078): 外部パッケージ依存が強く、テスト前提条件の設定が複雑になる可能性

## 6) レビュアーチェックリスト（最小）
- [ ] ValidateFlunderSpecの全条件分岐（5つのelse-if + 1つの独立if）が正しくテストケースに対応しているか
- [ ] DisallowFlunder.Admitの全分岐パス（Kind判定、WaitForReady、meta.Accessor、Lister.List、禁止リストチェック）が網羅されているか
- [ ] v1alpha1 <-> internal間の変換テストで、FlunderReferenceType/FischerReferenceType/nilの全パターンが網羅されているか
- [ ] SetDefaults_FlunderSpecの条件「ReferenceType==nil OR len==0」と「len(Reference)!=0」の組み合わせが正しくカバーされているか
- [ ] WardleVersionToKubeVersionのバージョンマッピングロジック（Major判定、offset計算、上限クランプ）が正しくテストされているか
- [ ] fischerStrategy/flunderStrategyのNamespaceScoped返値の違い（false/true）が正しくテストケースに反映されているか
