---
generated_at: 2026-02-03 10:00:00
metrics:
  claims_total: 50
  claims_with_evidence: 47
  claims_without_evidence: 3
confidence_derived: 0.94
---

# 根拠レポート：受入テストケース一覧

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.94**
  - 根拠あり：47 / 50、根拠なし：3
- 優先レビュー（高）
  1. **UAT-022 NetworkPolicy通信制御**：E2Eテストファイルは存在するが個別テストケースの対応付けが粗い
  2. **UAT-041 PodSecurityAdmission**：staging配下のadmissionパッケージの実装に基づくが具体的なE2Eテストケースとの紐づけが弱い
  3. **UAT-047 マルチAZクラスタPod分散**：ubernetes_lite.goにテスト記述があるが具体的な期待結果の詳細根拠が限定的

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `test/e2e/apps/deployment.go` - Deployment E2Eテスト
- E-02: `pkg/controller/deployment/deployment_controller.go` - Deploymentコントローラ実装
- E-03: `pkg/controller/deployment/util/` - Deploymentユーティリティ（ローリングアップデート戦略）
- E-04: `test/e2e/kubectl/rollout.go` - kubectl rollout E2Eテスト
- E-05: `test/e2e/apps/statefulset.go` - StatefulSet E2Eテスト
- E-06: `test/e2e/apps/job.go` - Job E2Eテスト
- E-07: `test/e2e/apps/cronjob.go` - CronJob E2Eテスト
- E-08: `test/e2e/apps/daemon_set.go` - DaemonSet E2Eテスト
- E-09: `test/e2e/autoscaling/horizontal_pod_autoscaling.go` - HPA E2Eテスト
- E-10: `test/e2e/autoscaling/horizontal_pod_autoscaling_behavior.go` - HPA Behavior E2Eテスト
- E-11: `test/e2e/auth/service_accounts.go` - ServiceAccount E2Eテスト
- E-12: `test/e2e/auth/node_authz.go` - ノード認可 E2Eテスト
- E-13: `test/e2e/auth/certificates.go` - 証明書 E2Eテスト
- E-14: `test/e2e/network/dns.go` - DNS E2Eテスト
- E-15: `test/e2e/network/network_policy.go` - NetworkPolicy E2Eテスト
- E-16: `test/e2e/network/ingress.go` - Ingress E2Eテスト
- E-17: `test/e2e/network/endpointslice.go` - EndpointSlice E2Eテスト
- E-18: `test/e2e/node/pods.go` - Pod E2Eテスト
- E-19: `test/e2e/scheduling/predicates.go` - スケジューラ Predicates E2Eテスト
- E-20: `test/e2e/scheduling/preemption.go` - Preemption E2Eテスト
- E-21: `test/e2e/scheduling/ubernetes_lite.go` - Multi-AZ E2Eテスト
- E-22: `test/e2e/kubectl/kubectl.go` - kubectl E2Eテスト
- E-23: `test/e2e/kubectl/logs.go` - kubectl logs E2Eテスト
- E-24: `test/e2e/kubectl/delete.go` - kubectl delete E2Eテスト
- E-25: `test/e2e/kubectl/debug.go` - kubectl debug E2Eテスト
- E-26: `test/e2e/scheduling/limit_range.go` - LimitRange E2Eテスト
- E-27: `test/e2e/apps/disruption.go` - PDB E2Eテスト
- E-28: `test/e2e/storage/csi_volumes.go` - CSI E2Eテスト
- E-29: `test/e2e/auth/selfsubjectreviews.go` - SelfSubjectReview E2Eテスト
- E-30: `staging/src/k8s.io/pod-security-admission/` - PodSecurity Admission実装
- E-31: `test/e2e/auth/projected_clustertrustbundle.go` - ClusterTrustBundle E2Eテスト
- E-32: `test/e2e/auth/projected_podcertificate.go` - PodCertificate E2Eテスト
- E-33: `pkg/controller/job/` - Jobコントローラ実装
- E-34: `pkg/controller/cronjob/` - CronJobコントローラ実装
- E-35: `pkg/controller/daemon/` - DaemonSetコントローラ実装
- E-36: `pkg/controller/statefulset/` - StatefulSetコントローラ実装
- E-37: `pkg/controller/replicaset/` - ReplicaSetコントローラ実装
- E-38: `pkg/scheduler/` - スケジューラ実装

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | UAT-001: Deployment作成しPodが正常起動 | E-01, E-02 | ○ |
| C-02 | UAT-002: ローリングアップデート実行 | E-01, E-02, E-03 | ○ |
| C-03 | UAT-003: Deploymentロールバック | E-04 | ○ |
| C-04 | UAT-004: Deploymentスケーリング | E-01, E-02 | ○ |
| C-05 | UAT-005: Deployment削除カスケード | E-01 | ○ |
| C-06 | UAT-006: StatefulSet基本ID付与 | E-05 | ○ |
| C-07 | UAT-007: StatefulSetローリングアップデート | E-05, E-36 | ○ |
| C-08 | UAT-008: Job正常完了 | E-06, E-33 | ○ |
| C-09 | UAT-009: Jobバックオフリミット | E-06 | ○ |
| C-10 | UAT-010: Jobサスペンド | E-06 | ○ |
| C-11 | UAT-011: CronJobスケジュール実行 | E-07, E-34 | ○ |
| C-12 | UAT-012: CronJob履歴制限 | E-07 | ○ |
| C-13 | UAT-013: DaemonSet全ノード展開 | E-08, E-35 | ○ |
| C-14 | UAT-014: DaemonSetノードアフィニティ | E-08 | ○ |
| C-15 | UAT-015: HPAスケールアウト | E-09 | ○ |
| C-16 | UAT-016: HPAスケールイン | E-10 | ○ |
| C-17 | UAT-017: ServiceAccountトークンマウント | E-11 | ○ |
| C-18 | UAT-018: ノード認可制御 | E-12 | ○ |
| C-19 | UAT-019: CSR証明書発行 | E-13 | ○ |
| C-20 | UAT-020: DNS名前解決 | E-14 | ○ |
| C-21 | UAT-021: DNS部分修飾名解決 | E-14 | ○ |
| C-22 | UAT-022: NetworkPolicy通信制御 | E-15 | △ |
| C-23 | UAT-023: Ingress CRUD操作 | E-16 | ○ |
| C-24 | UAT-024: EndpointSlice自動更新 | E-17 | ○ |
| C-25 | UAT-025: Podライフサイクル正常 | E-18 | ○ |
| C-26 | UAT-026: Pod Eviction処理 | E-18 | ○ |
| C-27 | UAT-027: NodeAffinity | E-19 | ○ |
| C-28 | UAT-028: Taint/Toleration | E-19 | ○ |
| C-29 | UAT-029: Preemption | E-20 | ○ |
| C-30 | UAT-030: TopologySpreadConstraints | E-19 | ○ |
| C-31 | UAT-031: kubectl exec | E-22 | ○ |
| C-32 | UAT-032: kubectl logs | E-23 | ○ |
| C-33 | UAT-033: kubectl port-forward | E-22 | ○ |
| C-34 | UAT-034: kubectl delete確認 | E-24 | ○ |
| C-35 | UAT-035: kubectl debug | E-25 | ○ |
| C-36 | UAT-036: LimitRange適用 | E-26 | ○ |
| C-37 | UAT-037: PDB | E-27 | ○ |
| C-38 | UAT-038: CSIボリュームマウント | E-28 | ○ |
| C-39 | UAT-039: ReplicaSet孤立Pod採用 | E-01, E-37 | ○ |
| C-40 | UAT-040: SelfSubjectReview | E-29 | ○ |
| C-41 | UAT-041: PodSecurityAdmission | E-30 | △ |
| C-42 | UAT-042: ActiveDeadline超過Job | E-06 | ○ |
| C-43 | UAT-043: CronJobタイムゾーン | E-07 | ○ |
| C-44 | UAT-044: StatefulSet PVC削除ポリシー | E-05 | ○ |
| C-45 | UAT-045: initContainer失敗時挙動 | E-18 | ○ |
| C-46 | UAT-046: ClusterTrustBundleマウント | E-31 | ○ |
| C-47 | UAT-047: マルチAZクラスタPod分散 | E-21 | △ |
| C-48 | UAT-048: SchedulingGatesブロック | E-19 | ○ |
| C-49 | UAT-049: HPAスケールレート制限 | E-10 | ○ |
| C-50 | UAT-050: Pod mTLS接続 | E-32 | ○ |

## 4) 不足情報（Unknown / Missing）
- **C-22 (NetworkPolicy)**: network_policy.goにテストは存在するが、テストケース名の個別対応付けまで実施していない。CNIプラグイン依存の挙動が環境により異なる可能性がある
  - 候補：test/e2e/network/netpol/ ディレクトリ / CNI固有テスト / 実環境での検証結果
- **C-41 (PodSecurityAdmission)**: staging配下の実装コードから機能を推定したが、専用E2Eテストファイルとの直接紐づけが不十分
  - 候補：staging/src/k8s.io/pod-security-admission/test/ / test/e2e/auth/ 配下の追加テスト
- **C-47 (マルチAZ Pod分散)**: ubernetes_lite.goにSIGDescribeは存在するが、具体的な分散検証のアサーション詳細を未確認
  - 候補：test/e2e/scheduling/ubernetes_lite.go のテスト本文精査 / クラウドプロバイダ固有テスト

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - 大部分のテストケース（47/50）はE2Eテストコードまたはコントローラ実装に直接根拠がある
- 1: 中リスク - NetworkPolicy(C-22)とマルチAZ(C-47)はテストの存在は確認できるが環境依存性が高い
- 1: 中リスク - PodSecurityAdmission(C-41)はstaging実装からの推定であり専用E2Eテストとの対応確認が必要
- 0: 低リスク - Kubernetesはオープンソースプロジェクトのため「ユーザーロール」は主にRBACベースであり、GUIの画面は存在しない。全操作はkubectl CLI / APIベースである

## 6) レビュアーチェックリスト（最小）
- [ ] NetworkPolicy(UAT-022)のテスト手順と期待結果が利用するCNIプラグインに適合しているか確認
- [ ] PodSecurityAdmission(UAT-041)のテストシナリオが実環境のAdmission設定と整合しているか確認
- [ ] マルチAZ(UAT-047)のテストがターゲットクラスタのトポロジーに対応しているか確認
- [ ] HPA関連テスト(UAT-015, UAT-016, UAT-049)はメトリクスサーバの存在が前提条件であることを確認
- [ ] CSI(UAT-038)テストは対象CSIドライバがインストール済みであることを確認
- [ ] Feature Gate依存のテストケース（UAT-046, UAT-048, UAT-050）が対象バージョンで有効か確認
- [ ] 全テストケースの優先度（高/中/低）がプロジェクトの受入基準と整合しているか確認
