---
generated_at: 2026-02-02 00:00:00
metrics:
  claims_total: 76
  claims_with_evidence: 72
  claims_without_evidence: 4
confidence_derived: 0.95
---

# 根拠レポート：帳票一覧.csv

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.95**
  - 根拠あり：72 / 76、根拠なし：4
- 優先レビュー（高）
  1. **C-69 クラスタ情報出力のkubectlコマンド名**：コード内コメントからの推定
  2. **C-71 Nodeリソース使用状況の出力形式**：TopNodeOptions構造体からの推定であり出力形式の詳細確認が必要
  3. **C-72 Podリソース使用状況の出力形式**：TopPodOptions構造体からの推定であり出力形式の詳細確認が必要
  4. **C-76 コードカバレッジレポートの分類**：帳票としての分類が適切か要確認

## 2) 参照した情報（Evidence一覧）
> ここに「実在するもの」だけ列挙。抽出フェーズで付けたIDをそのまま出す。

- E-01: `pkg/printers/internalversion/printers.go` - AddHandlers関数内のTableHandler登録（63リソースタイプの帳票定義）
- E-02: `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` - HumanReadablePrinter（テーブル出力）
- E-03: `staging/src/k8s.io/cli-runtime/pkg/printers/json.go` - JSONPrinter（JSON出力）
- E-04: `staging/src/k8s.io/cli-runtime/pkg/printers/yaml.go` - YAMLPrinter（YAML出力）
- E-05: `staging/src/k8s.io/cli-runtime/pkg/printers/jsonpath.go` - JSONPathPrinter（JSONPath出力）
- E-06: `staging/src/k8s.io/cli-runtime/pkg/printers/template.go` - GoTemplatePrinter（GoTemplate出力）
- E-07: `staging/src/k8s.io/cli-runtime/pkg/printers/interface.go` - ResourcePrinterインターフェース定義
- E-08: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` - ClusterInfoOptions
- E-09: `staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo_dump.go` - ClusterInfoDumpOptions
- E-10: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` - TopNodeOptions
- E-11: `staging/src/k8s.io/kubectl/pkg/cmd/top/top_pod.go` - TopPodOptions
- E-12: `staging/src/k8s.io/apiserver/plugin/pkg/audit/log/backend.go` - 監査ログバックエンド（Legacy/JSON形式）
- E-13: `staging/src/k8s.io/apiserver/plugin/pkg/audit/webhook/webhook.go` - 監査Webhookバックエンド
- E-14: `staging/src/k8s.io/apiserver/pkg/audit/format.go` - EventString関数（Legacy形式定義）
- E-15: `pkg/util/coverage/coverage.go` - カバレッジレポート出力
- E-16: `staging/src/k8s.io/cli-runtime/pkg/genericclioptions/print_flags.go` - PrintFlags（出力フォーマット選択）

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | Pod一覧がTableHandler登録されている | E-01 (L107-108) | ○ |
| C-02 | PodTemplate一覧がTableHandler登録されている | E-01 (L116-117) | ○ |
| C-03 | PodDisruptionBudget一覧がTableHandler登録されている | E-01 (L126-127) | ○ |
| C-04 | ReplicationController一覧がTableHandler登録されている | E-01 (L139-140) | ○ |
| C-05 | ReplicaSet一覧がTableHandler登録されている | E-01 (L152-153) | ○ |
| C-06 | DaemonSet一覧がTableHandler登録されている | E-01 (L168-169) | ○ |
| C-07 | Job一覧がTableHandler登録されている | E-01 (L181-182) | ○ |
| C-08 | CronJob一覧がTableHandler登録されている | E-01 (L196-197) | ○ |
| C-09 | Service一覧がTableHandler登録されている | E-01 (L209-210) | ○ |
| C-10 | Ingress一覧がTableHandler登録されている | E-01 (L220-221) | ○ |
| C-11 | IngressClass一覧がTableHandler登録されている | E-01 (L229-230) | ○ |
| C-12 | StatefulSet一覧がTableHandler登録されている | E-01 (L239-240) | ○ |
| C-13 | Endpoints一覧がTableHandler登録されている | E-01 (L247-248) | ○ |
| C-14 | Node一覧がTableHandler登録されている | E-01 (L263-264) | ○ |
| C-15 | Event一覧がTableHandler登録されている | E-01 (L278-279) | ○ |
| C-16 | Namespace一覧がTableHandler登録されている | E-01 (L286-287) | ○ |
| C-17 | Secret一覧がTableHandler登録されている | E-01 (L295-296) | ○ |
| C-18 | ServiceAccount一覧がTableHandler登録されている | E-01 (L302-303) | ○ |
| C-19 | PersistentVolume一覧がTableHandler登録されている | E-01 (L318-319) | ○ |
| C-20 | PersistentVolumeClaim一覧がTableHandler登録されている | E-01 (L332-333) | ○ |
| C-21 | ComponentStatus一覧がTableHandler登録されている | E-01 (L341-342) | ○ |
| C-22 | Deployment一覧がTableHandler登録されている | E-01 (L354-355) | ○ |
| C-23 | HorizontalPodAutoscaler一覧がTableHandler登録されている | E-01 (L366-367) | ○ |
| C-24 | ConfigMap一覧がTableHandler登録されている | E-01 (L374-375) | ○ |
| C-25 | NetworkPolicy一覧がTableHandler登録されている | E-01 (L382-383) | ○ |
| C-26 | RoleBinding一覧がTableHandler登録されている | E-01 (L393-394) | ○ |
| C-27 | ClusterRoleBinding一覧がTableHandler登録されている | E-01 (L404-405) | ○ |
| C-28 | CertificateSigningRequest一覧がTableHandler登録されている | E-01 (L415-416) | ○ |
| C-29 | ClusterTrustBundle一覧がTableHandler登録されている | E-01 (L422-423) | ○ |
| C-30 | PodCertificateRequest一覧がTableHandler登録されている | E-01 (L434-435) | ○ |
| C-31 | Lease一覧がTableHandler登録されている | E-01 (L442-443) | ○ |
| C-32 | LeaseCandidate一覧がTableHandler登録されている | E-01 (L452-453) | ○ |
| C-33 | StorageClass一覧がTableHandler登録されている | E-01 (L464-465) | ○ |
| C-34 | VolumeAttributesClass一覧がTableHandler登録されている | E-01 (L473-474) | ○ |
| C-35 | Status出力がTableHandler登録されている | E-01 (L482) | ○ |
| C-36 | ControllerRevision一覧がTableHandler登録されている | E-01 (L490-491) | ○ |
| C-37 | ResourceQuota一覧がTableHandler登録されている | E-01 (L499-500) | ○ |
| C-38 | PriorityClass一覧がTableHandler登録されている | E-01 (L509-510) | ○ |
| C-39 | RuntimeClass一覧がTableHandler登録されている | E-01 (L517-518) | ○ |
| C-40 | VolumeAttachment一覧がTableHandler登録されている | E-01 (L528-529) | ○ |
| C-41 | EndpointSlice一覧がTableHandler登録されている | E-01 (L538-539) | ○ |
| C-42 | CSINode一覧がTableHandler登録されている | E-01 (L546-547) | ○ |
| C-43 | CSIDriver一覧がTableHandler登録されている | E-01 (L564-565) | ○ |
| C-44 | CSIStorageCapacity一覧がTableHandler登録されている | E-01 (L572-573) | ○ |
| C-45 | MutatingWebhookConfiguration一覧がTableHandler登録されている | E-01 (L580-581) | ○ |
| C-46 | ValidatingWebhookConfiguration一覧がTableHandler登録されている | E-01 (L588-589) | ○ |
| C-47 | ValidatingAdmissionPolicy一覧がTableHandler登録されている | E-01 (L597-598) | ○ |
| C-48 | ValidatingAdmissionPolicyBinding一覧がTableHandler登録されている | E-01 (L606-607) | ○ |
| C-49 | MutatingAdmissionPolicy一覧がTableHandler登録されている | E-01 (L615-616) | ○ |
| C-50 | MutatingAdmissionPolicyBinding一覧がTableHandler登録されている | E-01 (L624-625) | ○ |
| C-51 | FlowSchema一覧がTableHandler登録されている | E-01 (L635-636) | ○ |
| C-52 | PriorityLevelConfiguration一覧がTableHandler登録されている | E-01 (L647-648) | ○ |
| C-53 | StorageVersion一覧がTableHandler登録されている | E-01 (L656-657) | ○ |
| C-54 | Scale出力がTableHandler登録されている | E-01 (L665) | ○ |
| C-55 | DeviceClass一覧がTableHandler登録されている | E-01 (L671-672) | ○ |
| C-56 | ResourceClaim一覧がTableHandler登録されている | E-01 (L679-680) | ○ |
| C-57 | ResourceClaimTemplate一覧がTableHandler登録されている | E-01 (L686-687) | ○ |
| C-58 | ResourceSlice一覧がTableHandler登録されている | E-01 (L696-697) | ○ |
| C-59 | DeviceTaintRule一覧がTableHandler登録されている | E-01 (L712-713) | ○ |
| C-60 | ServiceCIDR一覧がTableHandler登録されている | E-01 (L721-722) | ○ |
| C-61 | IPAddress一覧がTableHandler登録されている | E-01 (L729-730) | ○ |
| C-62 | StorageVersionMigration一覧がTableHandler登録されている | E-01 (L737-738) | ○ |
| C-63 | Workload一覧がTableHandler登録されている | E-01 (L744-745) | ○ |
| C-64 | JSON出力フォーマットが存在する | E-03 | ○ |
| C-65 | YAML出力フォーマットが存在する | E-04 | ○ |
| C-66 | JSONPath出力フォーマットが存在する | E-05 | ○ |
| C-67 | GoTemplate出力フォーマットが存在する | E-06 | ○ |
| C-68 | テーブル出力フォーマットが存在する | E-02 | ○ |
| C-69 | クラスタ情報出力がkubectl cluster-infoで利用される | E-08 | △ |
| C-70 | クラスタ情報ダンプがディレクトリに出力される | E-09 | ○ |
| C-71 | Nodeリソース使用状況がテーブル形式で出力される | E-10 | △ |
| C-72 | Podリソース使用状況がテーブル形式で出力される | E-11 | △ |
| C-73 | 監査ログLegacy形式が1行テキスト出力である | E-12, E-14 | ○ |
| C-74 | 監査ログJSON形式が構造化JSON出力である | E-12 | ○ |
| C-75 | 監査Webhookが外部サービスにイベントを送信する | E-13 | ○ |
| C-76 | コードカバレッジレポートがファイルに出力される | E-15 | △ |

## 4) 不足情報（Unknown / Missing）
- C-69：kubectl cluster-info の出力形式の詳細（テーブルではなくカスタム形式のテキスト出力）については、Runメソッドの実装を詳細に確認する必要がある
  - 候補：`staging/src/k8s.io/kubectl/pkg/cmd/clusterinfo/clusterinfo.go` のRun()メソッド詳細
- C-71, C-72：kubectl top の出力形式がテーブルプリンタを使用しているか、カスタムプリンタを使用しているかの詳細確認が必要
  - 候補：`staging/src/k8s.io/kubectl/pkg/cmd/top/top_node.go` / `top_pod.go` のRun()メソッド詳細
- C-76：カバレッジレポートは帳票（ビジネスレポート）というより開発ツール出力であり、分類の妥当性は要確認
  - 候補：プロジェクトの帳票定義方針の確認

## 5) リスクフラグ（レビュー観点）
- 0（低リスク）：リソース一覧出力（C-01〜C-63）はすべてTableHandler登録コードから直接確認可能
- 0（低リスク）：出力フォーマット（C-64〜C-68）はプリンタ実装ファイルから直接確認可能
- 1（中リスク）：診断レポート（C-69, C-70）は出力形式の詳細について推定を含む
- 1（中リスク）：メトリクスレポート（C-71, C-72）は出力形式の詳細について推定を含む
- 0（低リスク）：監査ログ出力（C-73〜C-75）はバックエンド実装から直接確認可能
- 1（中リスク）：カバレッジレポート（C-76）は帳票としての分類適切性が要確認
- 注意：本プロジェクトはKubernetes（コンテナオーケストレーションプラットフォーム）であり、一般的な業務アプリケーションのような帳票（請求書、領収書等）は存在しない。ここでの「帳票」はシステムが生成する構造化出力を指す

## 6) レビュアーチェックリスト（最小）
- [ ] リソース一覧出力（No.1〜63）が `pkg/printers/internalversion/printers.go` のAddHandlers関数と一致しているか
- [ ] 出力フォーマット（No.64〜68）が `staging/src/k8s.io/cli-runtime/pkg/printers/` 配下の実装と一致しているか
- [ ] 診断レポート（No.69〜70）の出力形式の記述が正確か
- [ ] メトリクスレポート（No.71〜72）の出力形式の記述が正確か
- [ ] 監査ログ出力（No.73〜75）がauditバックエンド実装と一致しているか
- [ ] カバレッジレポート（No.76）を帳票として含めることが妥当か
- [ ] Kubernetesプロジェクトの特性（インフラ基盤であり業務帳票は存在しない）が理解されているか
