# 帳票設計書 11-IngressClass一覧

## 概要

本ドキュメントは、Kubernetes IngressClassリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get ingressclass` コマンド実行時にIngressClassリソースの情報を人間が読みやすいテーブル形式で標準出力に表示する。

### 本帳票の処理概要

IngressClassリソースの一覧情報を取得し、テーブル形式で出力する処理を行う。

**業務上の目的・背景**：IngressClassはKubernetesクラスタ内でIngressリソースがどのIngressコントローラによって処理されるかを定義するリソースである。クラスタ管理者が利用可能なIngressClassを把握し、デフォルトのIngressClassがどれであるかを確認するために本帳票が必要となる。複数のIngressコントローラが共存する環境では、IngressClassの管理が運用上重要である。

**帳票の利用シーン**：クラスタにどのIngressClassが定義されているか確認する場合、Ingressリソース作成前にどのコントローラが利用可能か調査する場合、デフォルトIngressClassの設定を確認する場合に利用される。

**主要な出力内容**：
1. IngressClass名（デフォルトの場合は「(default)」が付与される）
2. コントローラ名（どのIngressコントローラが担当するか）
3. パラメータ参照（追加設定を参照するリソースへの参照情報）
4. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザが `kubectl get ingressclass` または `kubectl get ingressclass <名前>` コマンドを実行した際に出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、プラットフォームエンジニア、アプリケーション開発者

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get ingressclass` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力）|
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

タブ区切りのテーブル形式で、ヘッダー行に続いて各IngressClassリソースのデータ行を出力する。

```
NAME             CONTROLLER                      PARAMETERS   AGE
nginx (default)  k8s.io/ingress-nginx            <none>       10d
haproxy          haproxy.org/ingress-controller   <none>       5d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | IngressClass名。デフォルトの場合は「(default)」が付与される | `obj.Name` + `HasDefaultAnnotation` チェック | 文字列 |
| 2 | CONTROLLER | IngressClassを処理するコントローラの識別子 | `obj.Spec.Controller` | 文字列 |
| 3 | PARAMETERS | 追加パラメータへの参照。未設定時は`<none>` | `obj.Spec.Parameters` (Kind.APIGroup/Name形式) | 文字列 |
| 4 | AGE | 作成からの経過時間 | `obj.CreationTimestamp` | 相対時間（例: 10d, 5h） |

### 明細部

ヘッダーと同一カラムで各IngressClassリソースの情報を1行ずつ出力する。

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| リソースタイプ | IngressClassリソースを対象とする | Yes |
| ラベルセレクタ | `-l` オプションで指定されたラベルによるフィルタリング | No |
| フィールドセレクタ | `--field-selector` オプションで指定されたフィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | APIサーバからの返却順（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない（ターミナル出力のため）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/ingressclasses | IngressClassリソースの保存先 | リソース名で直接参照 |

### テーブル別参照項目詳細

#### IngressClass リソース

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | NAME | 全件取得 | デフォルトアノテーション判定あり |
| `metadata.creationTimestamp` | AGE | 全件取得 | 相対時間に変換 |
| `metadata.annotations["ingressclass.kubernetes.io/is-default-class"]` | NAME（デフォルト判定） | 全件取得 | "true"の場合に「(default)」を付与 |
| `spec.controller` | CONTROLLER | 全件取得 | そのまま文字列出力 |
| `spec.parameters.kind` | PARAMETERS | 全件取得 | Kind.APIGroup/Name形式 |
| `spec.parameters.apiGroup` | PARAMETERS | 全件取得 | nilの場合はKind/Name形式 |
| `spec.parameters.name` | PARAMETERS | 全件取得 | パラメータ未設定時は`<none>` |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| AGE | 現在時刻 - CreationTimestamp | N/A | `translateTimestampSince`関数で相対時間文字列に変換 |
| PARAMETERS | Kind + "." + APIGroup + "/" + Name | N/A | APIGroupがnilの場合は "." + APIGroupを省略 |
| NAME (default付与) | HasDefaultAnnotation(obj.ObjectMeta) が true の場合、Name + " (default)" | N/A | アノテーション `ingressclass.kubernetes.io/is-default-class` を確認 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get ingressclass 実行] --> B[コマンドパラメータ解析]
    B --> C[API Server へ LIST リクエスト]
    C --> D[IngressClass リソース一覧取得]
    D --> E[printIngressClass 関数で各行生成]
    E --> F[HumanReadablePrinter でテーブル整形]
    F --> G[標準出力へ出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未存在 | 指定した名前のIngressClassが存在しない | `Error from server (NotFound): ingressclasses.networking.k8s.io "<名前>" not found` | 正しいリソース名を指定 |
| 権限不足 | IngressClassリソースへのアクセス権限がない | `Error from server (Forbidden): ...` | RBACで適切な権限を付与 |
| APIサーバ接続失敗 | APIサーバに接続できない | `The connection to the server <host> was refused` | APIサーバの稼働状態を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 通常1〜10件程度 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A（CLIコマンド） |

## セキュリティ考慮事項

IngressClassリソースの閲覧にはRBACによる `get` / `list` 権限が必要。IngressClassはクラスタスコープのリソースであり、特定のNamespaceに属さない。機密情報は含まないため、特別なマスキング処理は不要。

## 備考

- IngressClassはクラスタスコープリソースであり、Namespace指定は不要
- `kubectl get ingressclass` の短縮形は存在しない
- `-o wide` オプションを指定しても追加カラムは表示されない（Priority 1のカラムが定義されていないため）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

IngressClassリソースのAPI型定義を理解することが出発点となる。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/networking/v1/types.go` | IngressClass構造体の定義（Spec.Controller, Spec.Parameters） |

**読解のコツ**: Kubernetes APIリソースの型定義はGo構造体で定義されており、JSONタグがフィールド名のマッピングを示す。

#### Step 2: エントリーポイントを理解する

テーブル出力のためのカラム定義と印刷関数の登録を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内のingressClassColumnDefinitions（行223-230） |

**主要処理フロー**:
1. **行223-227**: ingressClassColumnDefinitionsでカラム定義（Name, Controller, Parameters, Age）
2. **行229-230**: TableHandlerにprintIngressClassとprintIngressClassListを登録

#### Step 3: 印刷関数を理解する

実際のテーブル行生成ロジックを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printIngressClass関数（行1500-1520） |

**主要処理フロー**:
- **行1506**: `HasDefaultAnnotation`でデフォルトIngressClassかチェックし、名前に「(default)」を付与
- **行1509-1516**: Parametersがnilなら`<none>`、それ以外はKind.APIGroup/Name形式で文字列生成
- **行1518**: row.Cellsに Name, Controller, Parameters, Age を追加

#### Step 4: テーブル出力エンジンを理解する

HumanReadablePrinterによるテーブル整形処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | HumanReadablePrinter構造体とPrintObj関数 |

### プログラム呼び出し階層図

```
kubectl get ingressclass
    |
    +-- NewCmdGet (pkg/cmd/get/get.go)
    |      +-- RunGet
    |             +-- API Server LIST /apis/networking.k8s.io/v1/ingressclasses
    |
    +-- AddHandlers (pkg/printers/internalversion/printers.go:93)
    |      +-- TableHandler(ingressClassColumnDefinitions, printIngressClass) (行229)
    |
    +-- printIngressClass (pkg/printers/internalversion/printers.go:1500)
    |      +-- HasDefaultAnnotation (networkingutil)
    |      +-- translateTimestampSince
    |
    +-- HumanReadablePrinter.PrintObj (cli-runtime/pkg/printers/tableprinter.go)
           +-- tabwriter による整形出力
```

### データフロー図

```
[入力]                        [処理]                           [出力]

API Server               printIngressClass()              標準出力(stdout)
(IngressClass            行1500-1520                      テーブル形式
 リソース一覧)   -------> - デフォルト判定         -------> NAME | CONTROLLER | PARAMETERS | AGE
                         - Parameters文字列生成
                         - Age計算
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | カラム定義とprintIngressClass関数 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力エンジン |
| types.go | `staging/src/k8s.io/api/networking/v1/types.go` | ソース | IngressClass API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printIngressClassのテストケース |
