# 帳票設計書 13-Endpoints一覧

## 概要

本ドキュメントは、Kubernetes Endpointsリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get endpoints` コマンド実行時にEndpointsリソースの情報を人間が読みやすいテーブル形式で標準出力に表示する。

### 本帳票の処理概要

Endpointsリソースの一覧情報を取得し、テーブル形式で出力する処理を行う。

**業務上の目的・背景**：EndpointsはServiceに紐づくPodのIPアドレスとポート番号の組み合わせを管理するリソースである。Serviceのトラフィックルーティングが正しく機能しているかを確認するために、どのPodのどのポートにトラフィックが転送されるかを把握することが運用上重要である。ネットワーク障害のトラブルシューティングにおいて最も参照頻度が高いリソースの一つである。

**帳票の利用シーン**：Serviceに紐づくバックエンドPodのアドレスを確認する場合、ネットワーク接続の問題を調査する場合、Service DiscoveryのHealthCheckの結果を確認する場合に利用される。

**主要な出力内容**：
1. Endpoints名（通常はServiceと同名）
2. エンドポイントアドレス一覧（IP:Port形式のリスト）
3. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザが `kubectl get endpoints` または `kubectl get ep` コマンドを実行した際に出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、ネットワークエンジニア、アプリケーション開発者

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get endpoints` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力）|
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

タブ区切りのテーブル形式で出力する。

```
NAME         ENDPOINTS                                      AGE
kubernetes   192.168.1.10:6443                              30d
my-service   10.0.0.1:8080,10.0.0.2:8080,10.0.0.3:8080    5d
big-svc      10.0.1.1:80,10.0.1.2:80,10.0.1.3:80 + 7 more...  2d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | Endpoints名 | `obj.Name` | 文字列 |
| 2 | ENDPOINTS | エンドポイントアドレス一覧 | `obj.Subsets` | IP:Port形式、カンマ区切り（最大3件表示 + "N more..."） |
| 3 | AGE | 作成からの経過時間 | `obj.CreationTimestamp` | 相対時間（例: 10d, 5h） |

### 明細部

ヘッダーと同一カラムで各Endpointsリソースの情報を1行ずつ出力する。

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| リソースタイプ | Endpointsリソースを対象とする | Yes |
| Namespace | 指定されたNamespace内のリソースを対象とする | No（デフォルトは現在のNamespace） |
| ラベルセレクタ | `-l` オプションで指定されたラベルによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | APIサーバからの返却順（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない（ターミナル出力のため）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/services/endpoints/{namespace}/{name} | Endpointsリソースの保存先 | Namespace + リソース名で参照 |

### テーブル別参照項目詳細

#### Endpoints リソース

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | NAME | 全件取得 | そのまま文字列出力 |
| `metadata.creationTimestamp` | AGE | 全件取得 | 相対時間に変換 |
| `subsets[*].addresses[*].ip` | ENDPOINTS | 全件取得 | formatEndpoints関数で整形 |
| `subsets[*].ports[*].port` | ENDPOINTS | 全件取得 | formatEndpoints関数でIP:Port形式に |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| AGE | 現在時刻 - CreationTimestamp | N/A | `translateTimestampSince`関数で変換 |
| ENDPOINTS | formatEndpoints(obj, nil) | N/A | 最大3件のIP:Portを表示、超過分は「+ N more...」 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get endpoints 実行] --> B[コマンドパラメータ解析]
    B --> C[API Server へ LIST リクエスト]
    C --> D[Endpoints リソース一覧取得]
    D --> E[printEndpoints 関数で各行生成]
    E --> F[formatEndpoints でアドレス文字列生成]
    F --> G[HumanReadablePrinter でテーブル整形]
    G --> H[標準出力へ出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未存在 | 指定した名前のEndpointsが存在しない | `Error from server (NotFound): endpoints "<名前>" not found` | 正しいリソース名を指定 |
| 権限不足 | Endpointsリソースへのアクセス権限がない | `Error from server (Forbidden): ...` | RBACで適切な権限を付与 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数百件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A（CLIコマンド） |

## セキュリティ考慮事項

Endpointsリソースの閲覧にはRBACによる `get` / `list` 権限が必要。EndpointsにはPodのIPアドレスが含まれるため、内部ネットワーク構成が把握される可能性がある。ただし、通常のKubernetes運用ではこれは想定内の情報公開である。

## 備考

- `kubectl get ep` は `kubectl get endpoints` の省略形
- Subsetsが空の場合は`<none>`と表示される
- エンドポイントは最大3件まで表示し、それを超える場合は「+ N more...」形式で省略される
- ヘッドレスService（ポートなし）の場合はIPアドレスのみ表示される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

EndpointsリソースのAPI型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/core/v1/types.go` | Endpoints, EndpointSubset, EndpointAddress, EndpointPort構造体の定義 |

**読解のコツ**: Endpointsはsubsetsの配列で構成され、各subsetにaddresses（Ready状態のPod）とnotReadyAddresses（未Ready状態のPod）が含まれる。

#### Step 2: エントリーポイントを理解する

テーブル出力のためのカラム定義と印刷関数の登録を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内のendpointColumnDefinitions（行242-248） |

**主要処理フロー**:
1. **行242-245**: endpointColumnDefinitionsでカラム定義（Name, Endpoints, Age）
2. **行247-248**: TableHandlerにprintEndpointsとprintEndpointsListを登録

#### Step 3: 印刷関数を理解する

実際のテーブル行生成ロジックを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printEndpoints関数（行1592-1598）とformatEndpoints関数（行749-798） |

**主要処理フロー**:
- **行1596**: `formatEndpoints(obj, nil)`でエンドポイントアドレス文字列を生成
- **行749-798**: formatEndpoints関数の詳細ロジック
  - **行750-751**: Subsetsが空なら`<none>`を返す
  - **行754**: 最大表示件数は3件（`max := 3`）
  - **行759**: ポートなしの場合はIPアドレスのみ
  - **行775-789**: ポートありの場合はIP:Port形式で出力
  - **行793-796**: 3件超過時は「+ N more...」形式

### プログラム呼び出し階層図

```
kubectl get endpoints
    |
    +-- NewCmdGet (pkg/cmd/get/get.go)
    |      +-- RunGet
    |             +-- API Server LIST /api/v1/namespaces/{ns}/endpoints
    |
    +-- AddHandlers (pkg/printers/internalversion/printers.go:93)
    |      +-- TableHandler(endpointColumnDefinitions, printEndpoints) (行247)
    |
    +-- printEndpoints (pkg/printers/internalversion/printers.go:1592)
    |      +-- formatEndpoints (pkg/printers/internalversion/printers.go:749)
    |      |      +-- net.JoinHostPort (IP:Port結合)
    |      +-- translateTimestampSince
    |
    +-- HumanReadablePrinter.PrintObj (cli-runtime/pkg/printers/tableprinter.go)
           +-- tabwriter による整形出力
```

### データフロー図

```
[入力]                        [処理]                           [出力]

API Server               printEndpoints()                 標準出力(stdout)
(Endpoints               行1592-1598                      テーブル形式
 リソース一覧)   -------> - formatEndpoints()       -------> NAME | ENDPOINTS | AGE
                           - Subsets解析
                           - IP:Port文字列生成
                           - 3件超は省略表示
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | カラム定義、printEndpoints関数、formatEndpoints関数 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力エンジン |
| types.go | `staging/src/k8s.io/api/core/v1/types.go` | ソース | Endpoints API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printEndpointsのテストケース |
