# 帳票設計書 15-Event一覧

## 概要

本ドキュメントは、Kubernetes Eventリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get events` コマンド実行時にEventリソースの情報を人間が読みやすいテーブル形式で標準出力に表示する。

### 本帳票の処理概要

Eventリソースの一覧情報を取得し、テーブル形式で出力する処理を行う。

**業務上の目的・背景**：Eventはクラスタ内で発生したイベント（Pod起動、スケジューリング、エラー等）を記録するリソースである。クラスタの動作状況を把握し、問題が発生した際の原因特定に不可欠な情報源である。Podのスケジューリング失敗やイメージプル失敗といった障害の初期調査において最も重要な帳票の一つである。

**帳票の利用シーン**：クラスタで発生したイベントの確認、Podのスケジューリングやデプロイの状況確認、エラーの原因調査、直近のクラスタ操作の監査に利用される。

**主要な出力内容**：
1. 最終検出時刻（Last Seen）
2. イベントタイプ（Normal/Warning）
3. 理由（Reason）
4. 対象オブジェクト（Object）
5. メッセージ（Message）
6. サブオブジェクト、ソース、初回検出時刻、発生回数、名前（Wide出力時）

**帳票の出力タイミング**：ユーザが `kubectl get events` コマンドを実行した際に出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、SREエンジニア、アプリケーション開発者

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get events` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力）|
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

タブ区切りのテーブル形式で、通常モードとWideモードの2パターンが存在する。

```
[通常モード]
LAST SEEN   TYPE      REASON    OBJECT           MESSAGE
5m          Normal    Pulled    pod/my-pod       Successfully pulled image "nginx:latest"
3m          Warning   Failed    pod/my-pod       Back-off restarting failed container

[Wideモード (-o wide)]
LAST SEEN  TYPE     REASON   OBJECT       SUBOBJECT          SOURCE                MESSAGE       FIRST SEEN  COUNT  NAME
5m         Normal   Pulled   pod/my-pod   spec.containers{}  kubelet, worker-01    Pulled ...    10m         3      my-pod.abc123
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | LAST SEEN | 最終検出時刻 | `obj.LastTimestamp` (ゼロの場合 `obj.FirstTimestamp`/`obj.EventTime`) | 相対時間 |
| 2 | TYPE | イベントタイプ | `obj.Type` | Normal/Warning |
| 3 | REASON | イベント理由 | `obj.Reason` | 文字列 |
| 4 | OBJECT | 対象オブジェクト | `obj.InvolvedObject` | "kind/name"形式（小文字） |
| 5 | SUBOBJECT | サブオブジェクト（Wide時のみ） | `obj.InvolvedObject.FieldPath` | 文字列 |
| 6 | SOURCE | イベントソース（Wide時のみ） | `obj.Source` / `obj.ReportingController` / `obj.ReportingInstance` | formatEventSource関数 |
| 7 | MESSAGE | イベントメッセージ | `obj.Message` | 文字列（前後の空白をトリム） |
| 8 | FIRST SEEN | 初回検出時刻（Wide時のみ） | `obj.FirstTimestamp` (ゼロの場合 `obj.EventTime`) | 相対時間 |
| 9 | COUNT | 発生回数（Wide時のみ） | `obj.Count` / `obj.Series.Count` | 整数 |
| 10 | NAME | Event名（Wide時のみ） | `obj.Name` | 文字列 |

### 明細部

ヘッダーと同一カラムで各Eventリソースの情報を1行ずつ出力する。

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| リソースタイプ | Eventリソースを対象とする | Yes |
| Namespace | 指定されたNamespace内のリソースを対象とする | No（デフォルトは現在のNamespace） |
| ラベルセレクタ | `-l` オプションで指定されたラベルによるフィルタリング | No |
| フィールドセレクタ | `--field-selector` オプションで指定されたフィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | APIサーバからの返却順（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない（ターミナル出力のため）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/events/{namespace}/{name} | Eventリソースの保存先 | Namespace + リソース名で参照 |

### テーブル別参照項目詳細

#### Event リソース

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `lastTimestamp` | LAST SEEN | 全件取得 | ゼロの場合はfirstTimestampを使用 |
| `firstTimestamp` | FIRST SEEN / LAST SEEN（フォールバック） | 全件取得 | ゼロの場合はeventTimeを使用 |
| `eventTime` | FIRST SEEN / LAST SEEN（フォールバック） | 全件取得 | MicroTime形式 |
| `type` | TYPE | 全件取得 | Normal/Warning |
| `reason` | REASON | 全件取得 | そのまま文字列出力 |
| `involvedObject.kind` | OBJECT | 全件取得 | 小文字変換してkind/name形式 |
| `involvedObject.name` | OBJECT | 全件取得 | 名前が空の場合はkindのみ |
| `involvedObject.fieldPath` | SUBOBJECT | Wide時 | そのまま出力 |
| `source` | SOURCE | Wide時 | formatEventSource関数で整形 |
| `reportingController` | SOURCE | Wide時 | sourceと合わせて整形 |
| `reportingInstance` | SOURCE | Wide時 | sourceと合わせて整形 |
| `message` | MESSAGE | 全件取得 | 前後の空白をトリム |
| `count` | COUNT | Wide時 | Seriesがある場合はSeries.Count |
| `series.lastObservedTime` | LAST SEEN | 全件取得 | Seriesがある場合に優先 |
| `series.count` | COUNT | Wide時 | Seriesがある場合に優先 |
| `metadata.name` | NAME | Wide時 | そのまま文字列出力 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| LAST SEEN | Seriesあり -> Series.LastObservedTime、なし -> LastTimestamp（ゼロならFirstTimestamp/EventTime） | N/A | 相対時間に変換 |
| FIRST SEEN | FirstTimestamp（ゼロならEventTime） | N/A | 相対時間に変換 |
| OBJECT | strings.ToLower(kind) + "/" + name | N/A | nameが空の場合は"/"以降省略 |
| COUNT | Seriesあり -> Series.Count、なし -> Count（0の場合は1に設定） | N/A | Singletonイベントはcount=1 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get events 実行] --> B[コマンドパラメータ解析]
    B --> C[API Server へ LIST リクエスト]
    C --> D[Event リソース一覧取得]
    D --> E[printEvent 関数で各行生成]
    E --> F[タイムスタンプ計算]
    F --> G{Wideモード?}
    G -->|Yes| H[全10カラムを出力]
    G -->|No| I[基本5カラムを出力]
    H --> J[HumanReadablePrinter でテーブル整形]
    I --> J
    J --> K[標準出力へ出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| 権限不足 | Eventリソースへのアクセス権限がない | `Error from server (Forbidden): ...` | RBACで適切な権限を付与 |
| APIサーバ接続失敗 | APIサーバに接続できない | `The connection to the server <host> was refused` | APIサーバの稼働状態を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十件〜数万件 |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | N/A（CLIコマンド） |

## セキュリティ考慮事項

EventリソースにはPod名、Node名、エラーメッセージ等の運用情報が含まれる。Eventの閲覧にはRBACによる `get` / `list` 権限が必要。EventはNamespaceスコープリソースである。イベントメッセージにはSecretの値などの機密情報は含まれないが、リソース名やエラーの詳細が公開される。

## 備考

- Eventはデフォルトで1時間後にガベージコレクションされるため、古いイベントは表示されない
- Singletonイベント（新しいAPI）ではCountフィールドが0となるが、表示時は1に補正される
- Seriesフィールドが存在する場合、そのLastObservedTimeとCountが優先される
- 通常モードでは5カラム、Wideモードでは10カラムと、表示項目の差が大きい

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

EventリソースのAPI型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/core/v1/types.go` | Event, EventSeries, ObjectReference構造体の定義 |

**読解のコツ**: Eventには新旧2つのAPI形式があり、Seriesフィールドの有無で区別される。

#### Step 2: エントリーポイントを理解する

テーブル出力のためのカラム定義と印刷関数の登録を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内のeventColumnDefinitions（行266-279） |

**主要処理フロー**:
1. **行266-276**: eventColumnDefinitionsでカラム定義（Last Seen, Type, Reason, Object + Wide: Subobject, Source, Message, First Seen, Count, Name）
2. **行278-279**: TableHandlerにprintEventとprintEventListを登録

#### Step 3: 印刷関数を理解する

実際のテーブル行生成ロジックを読み解く。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printEvent関数（行2158-2212） |

**主要処理フロー**:
- **行2163-2166**: FirstTimestampの計算（ゼロの場合EventTimeを使用）
- **行2168-2171**: LastTimestampの計算（ゼロの場合FirstTimestampを使用）
- **行2173-2180**: Count計算（Seriesがある場合はSeries.Count/LastObservedTime、Singletonは1）
- **行2182-2187**: ターゲット文字列の生成（kind/name形式）
- **行2188-2209**: WideモードとNormalモードで異なるカラムセット

### プログラム呼び出し階層図

```
kubectl get events
    |
    +-- NewCmdGet (pkg/cmd/get/get.go)
    |      +-- RunGet
    |             +-- API Server LIST /api/v1/namespaces/{ns}/events
    |
    +-- AddHandlers (pkg/printers/internalversion/printers.go:93)
    |      +-- TableHandler(eventColumnDefinitions, printEvent) (行278)
    |
    +-- printEvent (pkg/printers/internalversion/printers.go:2158)
    |      +-- translateTimestampSince
    |      +-- translateMicroTimestampSince
    |      +-- formatEventSource
    |
    +-- HumanReadablePrinter.PrintObj (cli-runtime/pkg/printers/tableprinter.go)
           +-- tabwriter による整形出力
```

### データフロー図

```
[入力]                        [処理]                           [出力]

API Server               printEvent()                     標準出力(stdout)
(Event                   行2158-2212                      テーブル形式
 リソース一覧)   -------> - タイムスタンプ計算       -------> LAST SEEN | TYPE | REASON | OBJECT | MESSAGE
                         - Count計算                      (Wide時: + SUBOBJECT | SOURCE | FIRST SEEN |
                         - ターゲット文字列生成                      COUNT | NAME)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | カラム定義とprintEvent関数 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力エンジン |
| types.go | `staging/src/k8s.io/api/core/v1/types.go` | ソース | Event API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printEventのテストケース |
