# 帳票設計書 16-Namespace一覧

## 概要

本ドキュメントは、Kubernetes Namespaceリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get namespaces` コマンド実行時にNamespaceリソースの情報を人間が読みやすいテーブル形式で標準出力に表示する。

### 本帳票の処理概要

Namespaceリソースの一覧情報を取得し、テーブル形式で出力する処理を行う。

**業務上の目的・背景**：NamespaceはKubernetesクラスタ内のリソースを論理的に分離するための仕組みである。マルチテナント環境やマイクロサービスアーキテクチャにおいて、各チーム・アプリケーションのリソースを分離管理するために利用される。Namespaceの状態（Active/Terminating）を確認することは、リソース管理やNamespace削除操作の進行状況を把握する上で重要である。

**帳票の利用シーン**：クラスタ内に存在するNamespaceの一覧を確認する場合、Namespaceの状態（Active/Terminating）を確認する場合、新規Namespace作成前の重複確認に利用される。

**主要な出力内容**：
1. Namespace名
2. ステータス（Active/Terminating）
3. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザが `kubectl get namespaces` または `kubectl get ns` コマンドを実行した際に出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、プラットフォームエンジニア、開発チームリーダー

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get namespaces` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力）|
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

タブ区切りのテーブル形式で出力する。

```
NAME              STATUS   AGE
default           Active   30d
kube-system       Active   30d
kube-public       Active   30d
my-app            Active   5d
old-namespace     Terminating  1h
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | Namespace名 | `obj.Name` | 文字列 |
| 2 | STATUS | Namespaceのフェーズ | `obj.Status.Phase` | Active/Terminating |
| 3 | AGE | 作成からの経過時間 | `obj.CreationTimestamp` | 相対時間（例: 30d, 5h） |

### 明細部

ヘッダーと同一カラムで各Namespaceリソースの情報を1行ずつ出力する。

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| リソースタイプ | Namespaceリソースを対象とする | Yes |
| ラベルセレクタ | `-l` オプションで指定されたラベルによるフィルタリング | No |
| フィールドセレクタ | `--field-selector` オプションで指定されたフィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | APIサーバからの返却順（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない（ターミナル出力のため）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/namespaces/{name} | Namespaceリソースの保存先 | リソース名で直接参照 |

### テーブル別参照項目詳細

#### Namespace リソース

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | NAME | 全件取得 | そのまま文字列出力 |
| `metadata.creationTimestamp` | AGE | 全件取得 | 相対時間に変換 |
| `status.phase` | STATUS | 全件取得 | string型にキャスト |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| AGE | 現在時刻 - CreationTimestamp | N/A | `translateTimestampSince`関数で変換 |
| STATUS | string(obj.Status.Phase) | N/A | NamespacePhase型を文字列に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get namespaces 実行] --> B[コマンドパラメータ解析]
    B --> C[API Server へ LIST リクエスト]
    C --> D[Namespace リソース一覧取得]
    D --> E[printNamespace 関数で各行生成]
    E --> F[HumanReadablePrinter でテーブル整形]
    F --> G[標準出力へ出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未存在 | 指定した名前のNamespaceが存在しない | `Error from server (NotFound): namespaces "<名前>" not found` | 正しいリソース名を指定 |
| 権限不足 | Namespaceリソースへのアクセス権限がない | `Error from server (Forbidden): ...` | RBACで適切な権限を付与 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数百件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A（CLIコマンド） |

## セキュリティ考慮事項

Namespaceリソースの閲覧にはRBACによる `get` / `list` 権限が必要。Namespaceはクラスタスコープリソースであり、Namespace名自体には通常機密情報は含まれない。ただしNamespace名がチーム名やプロジェクト名を含む場合、組織構造が推測される可能性がある。

## 備考

- Namespaceはクラスタスコープリソースであり、Namespace指定は不要
- `kubectl get ns` は `kubectl get namespaces` の省略形
- `-o wide` オプションを指定しても追加カラムは表示されない
- printNamespace関数は3カラムのみで非常にシンプルな実装

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

NamespaceリソースのAPI型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/core/v1/types.go` | Namespace, NamespaceStatus, NamespacePhase の定義 |

**読解のコツ**: NamespacePhaseは"Active"と"Terminating"の2値。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内のnamespaceColumnDefinitions（行281-287） |

**主要処理フロー**:
1. **行281-285**: namespaceColumnDefinitionsでカラム定義（Name, Status, Age）
2. **行286-287**: TableHandlerにprintNamespaceとprintNamespaceListを登録

#### Step 3: 印刷関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printNamespace関数（行1892-1898） |

**主要処理フロー**:
- **行1896**: `obj.Name`, `string(obj.Status.Phase)`, `translateTimestampSince(obj.CreationTimestamp)` の3値をCellsに追加

### プログラム呼び出し階層図

```
kubectl get namespaces
    |
    +-- NewCmdGet (pkg/cmd/get/get.go)
    |      +-- RunGet
    |             +-- API Server LIST /api/v1/namespaces
    |
    +-- AddHandlers (pkg/printers/internalversion/printers.go:93)
    |      +-- TableHandler(namespaceColumnDefinitions, printNamespace) (行286)
    |
    +-- printNamespace (pkg/printers/internalversion/printers.go:1892)
    |      +-- translateTimestampSince
    |
    +-- HumanReadablePrinter.PrintObj (cli-runtime/pkg/printers/tableprinter.go)
           +-- tabwriter による整形出力
```

### データフロー図

```
[入力]                        [処理]                           [出力]

API Server               printNamespace()                 標準出力(stdout)
(Namespace               行1892-1898                      テーブル形式
 リソース一覧)   -------> - Phase文字列変換          -------> NAME | STATUS | AGE
                         - Age計算
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | カラム定義とprintNamespace関数 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力エンジン |
| types.go | `staging/src/k8s.io/api/core/v1/types.go` | ソース | Namespace API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printNamespaceのテストケース |
