# 帳票設計書 18-ServiceAccount一覧

## 概要

本ドキュメントは、Kubernetes ServiceAccountリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get sa` コマンド実行時にServiceAccountリソースの情報を人間が読みやすいテーブル形式で標準出力に表示する。

### 本帳票の処理概要

ServiceAccountリソースの一覧情報を取得し、テーブル形式で出力する処理を行う。

**業務上の目的・背景**：ServiceAccountはPodがKubernetes APIサーバに対して認証する際に使用するアイデンティティである。各NamespaceにはデフォルトのServiceAccountが自動作成され、Podはこれを使用してAPIサーバと通信する。RBAC（Role Based Access Control）と組み合わせて利用されるため、クラスタのセキュリティ管理においてServiceAccountの存在と作成時期を把握することが重要である。

**帳票の利用シーン**：Namespace内のServiceAccount一覧を確認する場合、セキュリティ監査でServiceAccount管理状況を確認する場合、RBACの設定確認においてServiceAccountを特定する場合に利用される。

**主要な出力内容**：
1. ServiceAccount名
2. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザが `kubectl get serviceaccounts` または `kubectl get sa` コマンドを実行した際に出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、セキュリティエンジニア、アプリケーション開発者

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get sa` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力）|
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

タブ区切りのテーブル形式で出力する。

```
NAME      AGE
default   30d
my-sa     5d
admin     10d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | ServiceAccount名 | `obj.Name` | 文字列 |
| 2 | AGE | 作成からの経過時間 | `obj.CreationTimestamp` | 相対時間（例: 30d, 5h） |

### 明細部

ヘッダーと同一カラムで各ServiceAccountリソースの情報を1行ずつ出力する。

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| リソースタイプ | ServiceAccountリソースを対象とする | Yes |
| Namespace | 指定されたNamespace内のリソースを対象とする | No（デフォルトは現在のNamespace） |
| ラベルセレクタ | `-l` オプションで指定されたラベルによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | APIサーバからの返却順（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない（ターミナル出力のため）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/serviceaccounts/{namespace}/{name} | ServiceAccountリソースの保存先 | Namespace + リソース名で参照 |

### テーブル別参照項目詳細

#### ServiceAccount リソース

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | NAME | 全件取得 | そのまま文字列出力 |
| `metadata.creationTimestamp` | AGE | 全件取得 | 相対時間に変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| AGE | 現在時刻 - CreationTimestamp | N/A | `translateTimestampSince`関数で変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get sa 実行] --> B[コマンドパラメータ解析]
    B --> C[API Server へ LIST リクエスト]
    C --> D[ServiceAccount リソース一覧取得]
    D --> E[printServiceAccount 関数で各行生成]
    E --> F[HumanReadablePrinter でテーブル整形]
    F --> G[標準出力へ出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未存在 | 指定した名前のServiceAccountが存在しない | `Error from server (NotFound): serviceaccounts "<名前>" not found` | 正しいリソース名を指定 |
| 権限不足 | ServiceAccountリソースへのアクセス権限がない | `Error from server (Forbidden): ...` | RBACで適切な権限を付与 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件（Namespaceあたり） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A（CLIコマンド） |

## セキュリティ考慮事項

ServiceAccountリソースの閲覧にはRBACによる `get` / `list` 権限が必要。ServiceAccount名自体はAPIサーバへの認証に直接使用されるわけではないが、RBAC権限の割り当て対象となるため、セキュリティ上の管理が必要。ServiceAccountはNamespaceスコープリソースである。

## 備考

- `kubectl get sa` は `kubectl get serviceaccounts` の省略形
- 各NamespaceにはデフォルトでdefaultというServiceAccountが自動作成される
- `-o wide` オプションを指定しても追加カラムは表示されない
- 本帳票はName, Ageの2カラムのみで最もシンプルな帳票の一つである

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ServiceAccountリソースのAPI型定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/api/core/v1/types.go` | ServiceAccount構造体の定義 |

**読解のコツ**: ServiceAccountにはSecrets, ImagePullSecrets, AutomountServiceAccountTokenフィールドがあるが、テーブル出力ではこれらは表示されない。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内のserviceAccountColumnDefinitions（行298-303） |

**主要処理フロー**:
1. **行298-301**: serviceAccountColumnDefinitionsでカラム定義（Name, Age）
2. **行302-303**: TableHandlerにprintServiceAccountとprintServiceAccountListを登録

#### Step 3: 印刷関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printServiceAccount関数（行1932-1938） |

**主要処理フロー**:
- **行1936**: `obj.Name`, `translateTimestampSince(obj.CreationTimestamp)` の2値をCellsに追加

### プログラム呼び出し階層図

```
kubectl get sa
    |
    +-- NewCmdGet (pkg/cmd/get/get.go)
    |      +-- RunGet
    |             +-- API Server LIST /api/v1/namespaces/{ns}/serviceaccounts
    |
    +-- AddHandlers (pkg/printers/internalversion/printers.go:93)
    |      +-- TableHandler(serviceAccountColumnDefinitions, printServiceAccount) (行302)
    |
    +-- printServiceAccount (pkg/printers/internalversion/printers.go:1932)
    |      +-- translateTimestampSince
    |
    +-- HumanReadablePrinter.PrintObj (cli-runtime/pkg/printers/tableprinter.go)
           +-- tabwriter による整形出力
```

### データフロー図

```
[入力]                        [処理]                           [出力]

API Server               printServiceAccount()            標準出力(stdout)
(ServiceAccount          行1932-1938                      テーブル形式
 リソース一覧)   -------> - Age計算                 -------> NAME | AGE
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | カラム定義とprintServiceAccount関数 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力エンジン |
| types.go | `staging/src/k8s.io/api/core/v1/types.go` | ソース | ServiceAccount API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printServiceAccountのテストケース |
