# 帳票設計書 2-PodTemplate一覧

## 概要

本ドキュメントは、Kubernetes の PodTemplate リソース一覧をテーブル形式で標準出力に出力する帳票の設計を定義する。`kubectl get podtemplates` コマンド実行時に使用される。

### 本帳票の処理概要

本帳票は、Kubernetes クラスタ上の PodTemplate リソースの一覧情報を、テーブル形式で標準出力に表示する処理を行う。

**業務上の目的・背景**：PodTemplate は Pod の雛形を定義するリソースであり、ReplicationController 等が Pod を生成する際のテンプレートとして使用される。運用者がクラスタ内に定義されている PodTemplate の一覧を確認し、どのようなコンテナ構成やラベル設定が定義されているかを把握するために必要な帳票である。

**帳票の利用シーン**：PodTemplate の一覧確認、テンプレートに定義されたコンテナ名やイメージの確認、Pod ラベルの確認など、テンプレート管理の場面で利用される。

**主要な出力内容**：
1. PodTemplate 名（Name）
2. コンテナ名一覧（Containers）
3. コンテナイメージ一覧（Images）
4. Pod ラベル（Pod Labels）

**帳票の出力タイミング**：ユーザが `kubectl get podtemplates` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetes クラスタ管理者、アプリケーション開発者。

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | ターミナル（CLI） | N/A | `kubectl get podtemplates [flags]` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 標準出力（テキスト / テーブル形式） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテーブル表示 |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字（tabwriter による整列） |
| ヘッダー表示 | デフォルト有効（`--no-headers` で無効化可能） |
| Wide 出力 | 追加カラムなし（全カラムが Priority=0） |

## 帳票レイアウト

### レイアウト概要

```
┌──────────────────────────────────────────────────────────────────────┐
│  NAME        CONTAINERS   IMAGES         POD LABELS                │
│  ヘッダー行                                                          │
├──────────────────────────────────────────────────────────────────────┤
│  template-1  nginx        nginx:latest   app=web                   │
│  ...（PodTemplate 数分の明細行）                                      │
└──────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | PodTemplate の名前 | `obj.ObjectMeta.Name` | 文字列（name フォーマット） |
| 2 | Containers | テンプレート内のコンテナ名一覧 | `obj.Template.Spec.Containers` | カンマ区切り文字列（`layoutContainerCells`） |
| 3 | Images | テンプレート内のコンテナイメージ一覧 | `obj.Template.Spec.Containers` | カンマ区切り文字列（`layoutContainerCells`） |
| 4 | Pod Labels | テンプレートの Pod ラベル | `obj.Template.Labels` | `key=value` 形式のカンマ区切り |

### 明細部

明細部は各 PodTemplate につき 1 行で、ヘッダー部と同じカラム構成。

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象 Namespace（`-n` / `--namespace`） | No（デフォルト: 現在のコンテキストの Namespace） |
| All Namespaces | 全 Namespace 対象（`-A`） | No |
| Label Selector | ラベルによるフィルタリング（`-l`） | No |
| Field Selector | フィールドによるフィルタリング（`--field-selector`） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | PodTemplate 名（デフォルト） | 昇順（API サーバのレスポンス順） |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: `/registry/podtemplates/{namespace}/{name}` | PodTemplate オブジェクトの永続化ストア | N/A |

### テーブル別参照項目詳細

#### PodTemplate リソース（API: `v1/podtemplates`）

| 参照項目（フィールド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | N/A | PodTemplate の名前 |
| `template.spec.containers[].name` | Containers | N/A | `layoutContainerCells` でカンマ区切りに変換 |
| `template.spec.containers[].image` | Images | N/A | `layoutContainerCells` でカンマ区切りに変換 |
| `template.labels` | Pod Labels | N/A | `labels.FormatLabels` で整形 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Containers | `layoutContainerCells(obj.Template.Spec.Containers)` の names 部分 | N/A | コンテナ名をカンマ区切りで連結 |
| Images | `layoutContainerCells(obj.Template.Spec.Containers)` の images 部分 | N/A | イメージ名をカンマ区切りで連結 |
| Pod Labels | `labels.FormatLabels(obj.Template.Labels)` | N/A | key=value 形式でカンマ区切り |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get podtemplates 実行] --> B[API サーバへリクエスト]
    B --> C[PodTemplate リスト取得]
    C --> D[printPodTemplateList で各行生成]
    D --> E[printPodTemplate で 1 行生成]
    E --> F[HumanReadablePrinter でテーブル出力]
    F --> G[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 指定条件に合致する PodTemplate が存在しない | `No resources found in {namespace} namespace.` | 条件を見直す |
| API エラー | API サーバへの接続失敗 | API サーバのエラーメッセージ | kubeconfig 設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 通常は少数（数件〜数十件） |
| 目標出力時間 | 即時 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

- PodTemplate 一覧の取得には RBAC による `podtemplates` リソースの `list` / `get` 権限が必要
- 出力内容にはコンテナイメージ名が含まれるが、機密情報は通常含まれない

## 備考

- PodTemplate は Kubernetes のコアリソースだが、実際の利用頻度は低い
- Wide 出力に追加カラムはない（全カラムが Priority=0）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printers.go | `pkg/printers/internalversion/printers.go` | podTemplateColumnDefinitions（行 110-115）: Name, Containers, Images, Pod Labels の 4 カラム定義 |

**読解のコツ**: PodTemplate のカラムには Priority 指定がないため、全カラムがデフォルト（Priority=0）で表示される。Wide 出力でも変化なし。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | kubectl get コマンドの共通エントリーポイント |

#### Step 3: print 関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printPodTemplate`（行 1105-1112）: layoutContainerCells でコンテナ名・イメージを取得、labels.FormatLabels でラベル整形 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | `printPodTemplateList`（行 1114-1124）: Items を順に printPodTemplate に委譲 |
| 3-3 | printers.go | `pkg/printers/internalversion/printers.go` | `layoutContainerCells`（行 2767）: コンテナ名とイメージ名をカンマ区切りで返すヘルパー関数 |

**主要処理フロー**:
- **行 1109**: `layoutContainerCells(obj.Template.Spec.Containers)` でコンテナ名とイメージ名を取得
- **行 1110**: Name, names, images, labels を TableRow のセルに追加

### プログラム呼び出し階層図

```
kubectl get podtemplates
    |
    +-- GetOptions.Run() [get.go]
           |
           +-- API Server Request
           |       |
           |       +-- printPodTemplateList() [printers.go 行1114]
           |               |
           |               +-- printPodTemplate() [printers.go 行1105]
           |                       |
           |                       +-- layoutContainerCells() [printers.go 行2767]
           |                       +-- labels.FormatLabels()
           |
           +-- HumanReadablePrinter.PrintObj()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

API Server (etcd)          printPodTemplate()                 標準出力 (stdout)
  PodTemplate Object  -->  - layoutContainerCells         --> テーブル形式テキスト
  (api.PodTemplate)        - labels.FormatLabels              NAME  CONTAINERS  IMAGES  POD LABELS
                           - TableRow 生成                    tmpl  nginx       nginx:1  app=web
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | PodTemplate 用カラム定義と printPodTemplate / printPodTemplateList 関数（行 110-117, 1105-1124） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルレンダリング |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl get コマンドエントリーポイント |
