# 帳票設計書 21-ComponentStatus一覧

## 概要

本ドキュメントは、Kubernetes ComponentStatusリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get componentstatuses`（短縮形: `kubectl get cs`）コマンドで使用される。

### 本帳票の処理概要

ComponentStatusリソースの一覧情報を、人間が読みやすいテーブル形式で標準出力に出力する帳票である。

**業務上の目的・背景**：Kubernetesクラスタを構成するコアコンポーネント（etcd、kube-scheduler、kube-controller-managerなど）の稼働状態を一覧形式で確認するために使用される。クラスタ運用において、コンポーネントの正常性を迅速に把握することは障害対応・予防保守の観点で重要である。ただし、本リソースは非推奨（deprecated）であり、将来的に削除される可能性がある。

**帳票の利用シーン**：クラスタの正常性確認時、障害発生時のトリアージ時、定期的なヘルスチェック時に利用される。`kubectl get cs`コマンドを実行し、各コンポーネントのHealthy/Unhealthyステータスを確認する。

**主要な出力内容**：
1. コンポーネント名（Name）
2. 稼働ステータス（Healthy/Unhealthy/Unknown）
3. コンポーネントからのメッセージ
4. エラー情報

**帳票の出力タイミング**：ユーザーが`kubectl get componentstatuses`または`kubectl get cs`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、SRE、インフラエンジニア

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get componentstatuses` または `kubectl get cs` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、ヘッダー行に続いてリソースごとに1行ずつ出力される。

```
NAME                 STATUS      MESSAGE             ERROR
scheduler            Healthy     ok
controller-manager   Healthy     ok
etcd-0               Healthy     {"health":"true"}
```

### ヘッダー部

該当なし（テーブルヘッダーが直接表示される）

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | コンポーネント名 | `obj.Name` | 文字列 | 可変 |
| 2 | Status | 稼働ステータス | `obj.Conditions[].Status`（ComponentHealthy条件を検索） | "Healthy" / "Unhealthy" / "Unknown" | 可変 |
| 3 | Message | コンポーネントメッセージ | `obj.Conditions[].Message`（ComponentHealthy条件） | 文字列 | 可変 |
| 4 | Error | エラー情報 | `obj.Conditions[].Error`（ComponentHealthy条件） | 文字列 | 可変 |

### フッター部

該当なし

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | ComponentStatusはクラスタスコープのため、Namespace指定は不要 | No |
| LabelSelector | ラベルセレクタによるフィルタリング | No |
| FieldSelector | フィールドセレクタによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

該当なし（ターミナル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ComponentStatus（API Resource） | コンポーネント状態情報の取得 | APIサーバーの `/api/v1/componentstatuses` エンドポイント |

### テーブル別参照項目詳細

#### ComponentStatus

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | - | - |
| `conditions[*].type` | （Status判定に使用） | `type == "Healthy"` | ComponentHealthy条件を検索 |
| `conditions[*].status` | Status | `type == "Healthy"` | True→"Healthy", その他→"Unhealthy" |
| `conditions[*].message` | Message | `type == "Healthy"` | 最初に見つかったComponentHealthy条件のみ |
| `conditions[*].error` | Error | `type == "Healthy"` | 最初に見つかったComponentHealthy条件のみ |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Status | Conditions配列のComponentHealthy条件のStatusがTrueなら"Healthy"、それ以外は"Unhealthy"、条件が見つからなければ"Unknown" | - | `printComponentStatus`関数（L2402-2423） |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get cs 実行] --> B[APIサーバーへリクエスト]
    B --> C[ComponentStatusList取得]
    C --> D[printComponentStatusList呼出]
    D --> E[各ComponentStatusに対してprintComponentStatus呼出]
    E --> F[Conditions配列からComponentHealthy条件を検索]
    F --> G[Status/Message/Errorを抽出]
    G --> H[TableRow生成]
    H --> I[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | ComponentStatusリソースが存在しない | `No resources found` | クラスタ構成を確認 |
| API接続エラー | APIサーバーに接続できない | 接続エラーメッセージ | APIサーバーの稼働状態を確認 |
| 権限不足 | RBAC権限がない | `Forbidden` | 適切なRBAC権限を付与 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 通常3-5件（etcd, scheduler, controller-manager等） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- ComponentStatusの閲覧にはクラスタレベルのRBAC権限（`get`、`list`）が必要
- コンポーネントの稼働状態はクラスタのセキュリティ状態を示す情報であるため、アクセス制御に注意

## 備考

- ComponentStatus APIは非推奨（deprecated）であり、将来のKubernetesバージョンで削除される可能性がある
- 代替手段として、各コンポーネントのヘルスチェックエンドポイントへの直接アクセスが推奨される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ComponentStatusリソースの内部表現とAPI定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/core/types.go` | ComponentStatus構造体とComponentCondition構造体の定義。ComponentHealthy条件タイプの理解 |

**読解のコツ**: `ComponentStatus`は`Conditions`フィールドを持ち、各Conditionの`Type`が`ComponentHealthy`であるものを検索してステータスを判定する。

#### Step 2: エントリーポイントを理解する

テーブル出力のハンドラ登録と呼び出しの流れを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | `AddHandlers`関数でのComponentStatus用テーブルハンドラ登録（L335-342） |

**主要処理フロー**:
1. **L335-339**: `componentStatusColumnDefinitions`でName, Status, Message, Errorの4カラムを定義
2. **L341-342**: `printComponentStatus`と`printComponentStatusList`をテーブルハンドラとして登録

#### Step 3: 出力処理を理解する

実際のテーブル行生成ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printComponentStatus`関数（L2402-2423）でのステータス判定ロジック |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | `printComponentStatusList`関数（L2425-2435）でのリスト処理 |

**主要処理フロー**:
- **L2406-2408**: status="Unknown", message="", error=""で初期化
- **L2409-2419**: Conditions配列をループし、ComponentHealthy条件を検索。Trueなら"Healthy"、それ以外は"Unhealthy"
- **L2421**: Name, Status, Message, ErrorをTableRowのCellsに追加

#### Step 4: テーブル出力基盤を理解する

共通のテーブル出力処理を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | HumanReadablePrinterによるテーブル形式出力の共通処理 |
| 4-2 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | `kubectl get`コマンドのエントリーポイント |

### プログラム呼び出し階層図

```
kubectl get cs
    │
    ├─ get.go: RunGet()
    │      └─ APIサーバーへREST GET /api/v1/componentstatuses
    │
    ├─ printers.go: AddHandlers() [初期化時]
    │      └─ TableHandler登録 (componentStatusColumnDefinitions)
    │
    └─ printers.go: printComponentStatusList()
           └─ printComponentStatus() [各アイテム]
                  └─ Conditions解析 → TableRow生成
```

### データフロー図

```
[入力]                      [処理]                           [出力]

APIサーバー ───▶ ComponentStatusList取得 ───▶ 標準出力(テーブル)
  /api/v1/         printComponentStatusList()      NAME  STATUS  MESSAGE  ERROR
  componentstatuses    └─ printComponentStatus()
                           └─ Conditions解析
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | ComponentStatusのテーブル出力ハンドラ定義・行生成ロジック |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | ComponentStatus出力のテストケース（TestPrintComponentStatus） |
| types.go | `pkg/apis/core/types.go` | ソース | ComponentStatus内部API型定義 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブル形式出力の共通基盤 |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
