# 帳票設計書 22-Deployment一覧

## 概要

本ドキュメントは、Kubernetes Deploymentリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get deployments`コマンドで使用される。

### 本帳票の処理概要

Deploymentリソースの一覧情報を、人間が読みやすいテーブル形式で標準出力に出力する帳票である。

**業務上の目的・背景**：Deploymentはステートレスアプリケーションの宣言的な更新とスケーリングを管理するKubernetesの中核リソースである。本帳票により、クラスタ上のすべてのDeploymentの状態（レプリカ数、可用性、更新状況）を一目で把握でき、アプリケーションのデプロイメント管理とトラブルシューティングに不可欠な情報を提供する。

**帳票の利用シーン**：アプリケーションのデプロイ状態確認、ローリングアップデートの進捗確認、レプリカ数の確認、障害時のPod可用性確認に利用される。

**主要な出力内容**：
1. Deployment名（Name）
2. Ready状態のレプリカ数/期待レプリカ数（Ready）
3. 更新済みレプリカ数（Up-to-date）
4. 利用可能レプリカ数（Available）
5. 経過時間（Age）
6. コンテナ名一覧（Containers、Wideモード）
7. イメージ名一覧（Images、Wideモード）
8. セレクタ（Selector、Wideモード）

**帳票の出力タイミング**：ユーザーが`kubectl get deployments`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：アプリケーション開発者、DevOpsエンジニア、SRE、クラスタ管理者

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get deployments` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式でヘッダー行に続いてリソースごとに1行ずつ出力される。`-o wide`オプションで追加カラムが表示される。

```
NAME      READY   UP-TO-DATE   AVAILABLE   AGE
nginx     3/3     3            3           10d
```

Wideモード時：
```
NAME      READY   UP-TO-DATE   AVAILABLE   AGE   CONTAINERS   IMAGES         SELECTOR
nginx     3/3     3            3           10d   nginx        nginx:1.19     app=nginx
```

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | Deployment名 | `obj.Name` | 文字列 | 可変 |
| 2 | Ready | Ready/期待レプリカ数 | `obj.Status.ReadyReplicas` / `obj.Spec.Replicas` | "{ready}/{desired}" | 可変 |
| 3 | Up-to-date | 更新済みレプリカ数 | `obj.Status.UpdatedReplicas` | 整数 | 可変 |
| 4 | Available | 利用可能レプリカ数 | `obj.Status.AvailableReplicas` | 整数 | 可変 |
| 5 | Age | 作成からの経過時間 | `obj.CreationTimestamp` | 人間可読形式 | 可変 |
| 6 | Containers | コンテナ名一覧（Wide） | `obj.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 7 | Images | コンテナイメージ一覧（Wide） | `obj.Spec.Template.Spec.Containers[*].Image` | カンマ区切り | 可変 |
| 8 | Selector | ラベルセレクタ（Wide） | `obj.Spec.Selector` | 文字列 | 可変 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象Namespace（デフォルト: default） | No |
| LabelSelector | ラベルセレクタによるフィルタリング | No |
| FieldSelector | フィールドセレクタによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

該当なし（ターミナル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| Deployment（API Resource） | Deployment情報の取得 | APIサーバーの `/apis/apps/v1/deployments` エンドポイント |

### テーブル別参照項目詳細

#### Deployment

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | - | - |
| `spec.replicas` | Ready（分母） | - | 期待レプリカ数 |
| `status.readyReplicas` | Ready（分子） | - | Ready状態のレプリカ数 |
| `status.updatedReplicas` | Up-to-date | - | 最新スペックに更新済みのレプリカ数 |
| `status.availableReplicas` | Available | - | 利用可能なレプリカ数 |
| `metadata.creationTimestamp` | Age | - | `translateTimestampSince`で人間可読形式に変換 |
| `spec.template.spec.containers` | Containers, Images | Wide時のみ | `layoutContainerCells`で整形 |
| `spec.selector` | Selector | Wide時のみ | `LabelSelectorAsSelector`で文字列化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Ready | `fmt.Sprintf("%d/%d", readyReplicas, desiredReplicas)` | - | L2454 |
| Age | `translateTimestampSince(obj.CreationTimestamp)` | - | 人間可読の経過時間文字列 |
| Selector | `metav1.LabelSelectorAsSelector(obj.Spec.Selector).String()` | - | 無効なセレクタの場合は`<invalid>` |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get deployments 実行] --> B[APIサーバーへリクエスト]
    B --> C[DeploymentList取得]
    C --> D[printDeploymentList呼出]
    D --> E[各Deploymentに対してprintDeployment呼出]
    E --> F[Spec/Statusからレプリカ数取得]
    F --> G{Wideモード?}
    G -->|Yes| H[Containers/Images/Selector追加]
    G -->|No| I[TableRow生成]
    H --> I
    I --> J[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | Deploymentリソースが存在しない | `No resources found in {namespace} namespace` | Namespaceを確認 |
| 無効なセレクタ | Spec.Selectorの解析に失敗 | セレクタ欄に`<invalid>`を表示 | Deploymentの定義を確認 |
| API接続エラー | APIサーバーに接続できない | 接続エラーメッセージ | APIサーバーの稼働状態を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百件〜数千件 |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- Deploymentの閲覧にはNamespaceレベルまたはクラスタレベルのRBAC権限（`get`、`list`）が必要
- Wideモード時にコンテナイメージ名が表示されるため、プライベートレジストリのURL情報が含まれる場合がある

## 備考

- Deploymentはapps/v1 APIグループに属する
- `-o wide`オプションでContainers、Images、Selectorカラムが追加表示される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Deploymentリソースの内部表現を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/apps/types.go` | Deployment, DeploymentSpec, DeploymentStatus構造体の定義 |

**読解のコツ**: `Spec.Replicas`（期待値）と`Status.ReadyReplicas`/`UpdatedReplicas`/`AvailableReplicas`（実際の状態）の関係を理解することが重要。

#### Step 2: エントリーポイントを理解する

テーブル出力のハンドラ登録と呼び出しの流れを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | `AddHandlers`関数でのDeployment用テーブルハンドラ登録（L344-355） |

**主要処理フロー**:
1. **L344-352**: `deploymentColumnDefinitions`で8カラムを定義（うち3つはPriority:1でWide時のみ表示）
2. **L354-355**: `printDeployment`と`printDeploymentList`をハンドラ登録

#### Step 3: 出力処理を理解する

実際のテーブル行生成ロジックを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printDeployment`関数（L2437-2460） |

**主要処理フロー**:
- **L2441-2444**: Spec.Replicas, Status.UpdatedReplicas, ReadyReplicas, AvailableReplicasを取得
- **L2447-2453**: Selectorを文字列化（エラー時は`<invalid>`）
- **L2454**: Ready列を`{ready}/{desired}`形式でフォーマット
- **L2455-2458**: Wideモード時にContainers, Images, Selectorを追加

### プログラム呼び出し階層図

```
kubectl get deployments
    │
    ├─ get.go: RunGet()
    │      └─ APIサーバーへREST GET /apis/apps/v1/namespaces/{ns}/deployments
    │
    ├─ printers.go: AddHandlers() [初期化時]
    │      └─ TableHandler登録 (deploymentColumnDefinitions)
    │
    └─ printers.go: printDeploymentList()
           └─ printDeployment() [各アイテム]
                  ├─ LabelSelectorAsSelector() [セレクタ文字列化]
                  └─ layoutContainerCells() [Wide時コンテナ情報整形]
```

### データフロー図

```
[入力]                      [処理]                           [出力]

APIサーバー ───▶ DeploymentList取得 ───▶ 標準出力(テーブル)
  /apis/apps/v1/       printDeploymentList()       NAME  READY  UP-TO-DATE  AVAILABLE  AGE
  deployments              └─ printDeployment()
                               ├─ Replicas計算
                               └─ Selector文字列化
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | Deploymentのテーブル出力ハンドラ定義・行生成ロジック |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | Deployment出力のテストケース（TestPrintDeployment L2633） |
| types.go | `pkg/apis/apps/types.go` | ソース | Deployment内部API型定義 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブル形式出力の共通基盤 |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
