# 帳票設計書 23-HorizontalPodAutoscaler一覧

## 概要

本ドキュメントは、Kubernetes HorizontalPodAutoscaler（HPA）リソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get hpa`コマンドで使用される。

### 本帳票の処理概要

HorizontalPodAutoscalerリソースの一覧情報を、人間が読みやすいテーブル形式で標準出力に出力する帳票である。

**業務上の目的・背景**：HPAはPodの水平オートスケーリングを管理するリソースであり、CPU使用率やカスタムメトリクスに基づいてPod数を自動調整する。本帳票により、クラスタ上のすべてのHPAの設定状態（スケーリング対象、メトリクス目標値と現在値、レプリカ数の上下限）を一覧で把握でき、オートスケーリングの動作状況を監視・管理するために使用される。

**帳票の利用シーン**：オートスケーリング設定の確認時、スケーリング動作の監視時、メトリクス目標値と現在値の乖離確認時、キャパシティプランニング時に利用される。

**主要な出力内容**：
1. HPA名（Name）
2. スケーリング対象リソース参照（Reference）
3. メトリクス目標値と現在値（Targets）
4. 最小Pod数（MinPods）
5. 最大Pod数（MaxPods）
6. 現在のレプリカ数（Replicas）
7. 経過時間（Age）

**帳票の出力タイミング**：ユーザーが`kubectl get hpa`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：アプリケーション開発者、DevOpsエンジニア、SRE、クラスタ管理者

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get hpa` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式でヘッダー行に続いてリソースごとに1行ずつ出力される。

```
NAME                                  REFERENCE        TARGETS         MINPODS   MAXPODS   REPLICAS   AGE
php-apache                            Deployment/php   cpu: 50%/80%    1         10        3          5d
```

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | HPA名 | `obj.Name` | 文字列 | 可変 |
| 2 | Reference | スケーリング対象 | `obj.Spec.ScaleTargetRef` | "{Kind}/{Name}" | 可変 |
| 3 | Targets | メトリクス目標/現在値 | `obj.Spec.Metrics` + `obj.Status.CurrentMetrics` | "current/target" 形式 | 可変 |
| 4 | MinPods | 最小Pod数 | `obj.Spec.MinReplicas` | 整数または"<unset>" | 可変 |
| 5 | MaxPods | 最大Pod数 | `obj.Spec.MaxReplicas` | 整数 | 可変 |
| 6 | Replicas | 現在のレプリカ数 | `obj.Status.CurrentReplicas` | 整数 | 可変 |
| 7 | Age | 作成からの経過時間 | `obj.CreationTimestamp` | 人間可読形式 | 可変 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象Namespace（デフォルト: default） | No |
| LabelSelector | ラベルセレクタによるフィルタリング | No |
| FieldSelector | フィールドセレクタによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

該当なし（ターミナル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| HorizontalPodAutoscaler（API Resource） | HPA情報の取得 | APIサーバーの `/apis/autoscaling/v2/horizontalpodautoscalers` エンドポイント |

### テーブル別参照項目詳細

#### HorizontalPodAutoscaler

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | - | - |
| `spec.scaleTargetRef.kind` | Reference（Kind部分） | - | - |
| `spec.scaleTargetRef.name` | Reference（Name部分） | - | - |
| `spec.metrics` | Targets（目標値） | - | `formatHPAMetrics`で整形 |
| `status.currentMetrics` | Targets（現在値） | - | `formatHPAMetrics`で整形 |
| `spec.minReplicas` | MinPods | - | nilの場合は"<unset>" |
| `spec.maxReplicas` | MaxPods | - | - |
| `status.currentReplicas` | Replicas | - | - |
| `metadata.creationTimestamp` | Age | - | `translateTimestampSince`で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Reference | `fmt.Sprintf("%s/%s", ScaleTargetRef.Kind, ScaleTargetRef.Name)` | - | L2580-2582 |
| MinPods | MinReplicasがnilの場合"<unset>"、それ以外はその値 | - | L2583-2587 |
| Targets | `formatHPAMetrics(specs, statuses)` | - | L2474-2573。最大2つのメトリクスを表示し、超過分は"+ N more..."と表示 |

### Targetsカラムの詳細フォーマット

`formatHPAMetrics`関数（L2474-2573）は以下のメトリクスタイプに対応：

| メトリクスタイプ | フォーマット | 例 |
|---------------|------------|-----|
| External（AverageValue） | `{current}/{target} (avg)` | `100m/200m (avg)` |
| External（Value） | `{current}/{target}` | `100/200` |
| Pods | `{current}/{target}` | `100m/200m` |
| Object（AverageValue） | `{current}/{target} (avg)` | `50/100 (avg)` |
| Object（Value） | `{current}/{target}` | `50/100` |
| Resource（AverageValue） | `{name}: {current}/{target}` | `cpu: 100m/200m` |
| Resource（AverageUtilization） | `{name}: {current}/{target}` | `cpu: 50%/80%` |
| ContainerResource（AverageValue） | `{name}: {current}/{target}` | `cpu: 100m/200m` |
| ContainerResource（AverageUtilization） | `{name}: {current}/{target}` | `cpu: 50%/80%` |

- メトリクスが0件の場合は`<none>`を表示
- 現在値が不明の場合は`<unknown>`を表示
- 3つ以上のメトリクスがある場合は最初の2つ表示後に`+ N more...`を追加

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get hpa 実行] --> B[APIサーバーへリクエスト]
    B --> C[HorizontalPodAutoscalerList取得]
    C --> D[printHorizontalPodAutoscalerList呼出]
    D --> E[各HPAに対してprintHorizontalPodAutoscaler呼出]
    E --> F[ScaleTargetRefからReference文字列生成]
    F --> G[formatHPAMetricsでTargets文字列生成]
    G --> H[MinPods判定]
    H --> I[TableRow生成]
    I --> J[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | HPAリソースが存在しない | `No resources found in {namespace} namespace` | Namespaceを確認 |
| メトリクス不明 | ステータスにメトリクス値がない | Targets欄に`<unknown>`を表示 | メトリクスサーバーの稼働を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十件〜数百件 |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- HPAの閲覧にはNamespaceレベルまたはクラスタレベルのRBAC権限（`get`、`list`）が必要
- HPAの設定値はスケーリング戦略を示すため、本番環境のキャパシティ情報が推測される可能性がある

## 備考

- HPAはautoscaling APIグループに属する（v2が推奨）
- メトリクス表示は最大2つまでで、それ以上は"+ N more..."と省略される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

HPAリソースの内部表現を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/autoscaling/types.go` | HorizontalPodAutoscaler, MetricSpec, MetricStatus構造体の定義 |

**読解のコツ**: `MetricSpec`のType（External, Pods, Object, Resource, ContainerResource）ごとに異なるフィールドが使用される点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | HPA用テーブルハンドラ登録（L357-367） |

**主要処理フロー**:
1. **L357-364**: `horizontalPodAutoscalerColumnDefinitions`で7カラムを定義
2. **L366-367**: ハンドラ登録

#### Step 3: メトリクスフォーマット処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `formatHPAMetrics`関数（L2474-2573）。メトリクスタイプごとの分岐処理と表示制限（最大2つ） |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | `printHorizontalPodAutoscaler`関数（L2575-2592） |

**主要処理フロー**:
- **L2475-2477**: メトリクスが0件の場合`<none>`を返却
- **L2479-2480**: 最大2つのメトリクスを表示する制御変数
- **L2483-2558**: メトリクスタイプごとのswitch文で個別フォーマット
- **L2563-2566**: 3つ以上の場合は先頭2つに切り詰め
- **L2569-2571**: 3つ以上の場合"+ N more..."を付加

### プログラム呼び出し階層図

```
kubectl get hpa
    │
    ├─ get.go: RunGet()
    │      └─ APIサーバーへREST GET /apis/autoscaling/v2/namespaces/{ns}/horizontalpodautoscalers
    │
    ├─ printers.go: AddHandlers() [初期化時]
    │      └─ TableHandler登録 (horizontalPodAutoscalerColumnDefinitions)
    │
    └─ printers.go: printHorizontalPodAutoscalerList()
           └─ printHorizontalPodAutoscaler() [各アイテム]
                  └─ formatHPAMetrics() [メトリクス文字列生成]
```

### データフロー図

```
[入力]                          [処理]                              [出力]

APIサーバー ───▶ HPAList取得 ───▶ 標準出力(テーブル)
  /apis/autoscaling/    printHorizontalPodAutoscalerList()   NAME  REFERENCE  TARGETS  ...
  v2/hpa                    └─ printHorizontalPodAutoscaler()
                                 └─ formatHPAMetrics()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | HPAのテーブル出力ハンドラ定義・行生成ロジック |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | HPA出力のテストケース（TestPrintHPA L3200） |
| types.go | `pkg/apis/autoscaling/types.go` | ソース | HPA内部API型定義 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブル形式出力の共通基盤 |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
