# 帳票設計書 24-ConfigMap一覧

## 概要

本ドキュメントは、Kubernetes ConfigMapリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get configmaps`コマンドで使用される。

### 本帳票の処理概要

ConfigMapリソースの一覧情報を、人間が読みやすいテーブル形式で標準出力に出力する帳票である。

**業務上の目的・背景**：ConfigMapはアプリケーションの設定情報をKey-Value形式で保持するリソースであり、コンテナイメージとアプリケーション設定を分離するために使用される。本帳票により、クラスタ上のConfigMapの存在とデータ件数を一覧で確認でき、設定管理やトラブルシューティングに活用される。

**帳票の利用シーン**：アプリケーション設定の確認時、ConfigMapの存在確認時、設定データの件数確認時に利用される。

**主要な出力内容**：
1. ConfigMap名（Name）
2. データ件数（Data）
3. 経過時間（Age）

**帳票の出力タイミング**：ユーザーが`kubectl get configmaps`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：アプリケーション開発者、DevOpsエンジニア、SRE、クラスタ管理者

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get configmaps` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式でヘッダー行に続いてリソースごとに1行ずつ出力される。

```
NAME               DATA   AGE
game-config        2      10d
kube-root-ca.crt   1      30d
```

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | ConfigMap名 | `obj.Name` | 文字列 | 可変 |
| 2 | Data | データ件数 | `len(obj.Data) + len(obj.BinaryData)` | 整数 | 可変 |
| 3 | Age | 作成からの経過時間 | `obj.CreationTimestamp` | 人間可読形式 | 可変 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象Namespace（デフォルト: default） | No |
| LabelSelector | ラベルセレクタによるフィルタリング | No |
| FieldSelector | フィールドセレクタによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

該当なし（ターミナル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ConfigMap（API Resource） | ConfigMap情報の取得 | APIサーバーの `/api/v1/configmaps` エンドポイント |

### テーブル別参照項目詳細

#### ConfigMap

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | - | - |
| `data` | Data（テキストデータ件数） | - | len(data)で件数を算出 |
| `binaryData` | Data（バイナリデータ件数） | - | len(binaryData)で件数を算出。dataと合算 |
| `metadata.creationTimestamp` | Age | - | `translateTimestampSince`で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Data | `len(obj.Data) + len(obj.BinaryData)` | - | テキストデータとバイナリデータの合計件数（L2610） |
| Age | `translateTimestampSince(obj.CreationTimestamp)` | - | 人間可読の経過時間文字列 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get configmaps 実行] --> B[APIサーバーへリクエスト]
    B --> C[ConfigMapList取得]
    C --> D[printConfigMapList呼出]
    D --> E[各ConfigMapに対してprintConfigMap呼出]
    E --> F[Data + BinaryDataの件数算出]
    F --> G[TableRow生成]
    G --> H[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | ConfigMapリソースが存在しない | `No resources found in {namespace} namespace` | Namespaceを確認 |
| API接続エラー | APIサーバーに接続できない | 接続エラーメッセージ | APIサーバーの稼働状態を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十件〜数百件 |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- ConfigMapの閲覧にはNamespaceレベルまたはクラスタレベルのRBAC権限（`get`、`list`）が必要
- 一覧表示ではデータの中身は表示されないが、ConfigMap名から設定内容が推測される場合がある
- 機密情報はConfigMapではなくSecretリソースに格納すべき

## 備考

- ConfigMapはcore/v1 APIグループに属する
- Dataカラムはテキストデータ（`data`フィールド）とバイナリデータ（`binaryData`フィールド）の合計件数を表示する
- Wideモード固有のカラムはない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/core/types.go` | ConfigMap構造体のDataフィールドとBinaryDataフィールドの定義 |

**読解のコツ**: `Data`は`map[string]string`、`BinaryData`は`map[string][]byte`であり、両方のキー数の合計がData列の値となる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | ConfigMap用テーブルハンドラ登録（L369-375） |

**主要処理フロー**:
1. **L369-372**: `configMapColumnDefinitions`でName, Data, Ageの3カラムを定義
2. **L374-375**: ハンドラ登録

#### Step 3: 出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printConfigMap`関数（L2606-2612） |

**主要処理フロー**:
- **L2610**: `len(obj.Data)+len(obj.BinaryData)`でデータ件数を算出し、Name, Data, AgeをCellsに追加

### プログラム呼び出し階層図

```
kubectl get configmaps
    │
    ├─ get.go: RunGet()
    │      └─ APIサーバーへREST GET /api/v1/namespaces/{ns}/configmaps
    │
    ├─ printers.go: AddHandlers() [初期化時]
    │      └─ TableHandler登録 (configMapColumnDefinitions)
    │
    └─ printers.go: printConfigMapList()
           └─ printConfigMap() [各アイテム]
                  └─ len(Data) + len(BinaryData) → Data列
```

### データフロー図

```
[入力]                      [処理]                        [出力]

APIサーバー ───▶ ConfigMapList取得 ───▶ 標準出力(テーブル)
  /api/v1/           printConfigMapList()       NAME  DATA  AGE
  configmaps             └─ printConfigMap()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | ConfigMapのテーブル出力ハンドラ定義・行生成ロジック |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | ConfigMap出力のテストケース（TestPrintConfigMap L4412） |
| types.go | `pkg/apis/core/types.go` | ソース | ConfigMap内部API型定義 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブル形式出力の共通基盤 |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
