# 帳票設計書 25-NetworkPolicy一覧

## 概要

本ドキュメントは、Kubernetes NetworkPolicyリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get networkpolicies`コマンドで使用される。

### 本帳票の処理概要

NetworkPolicyリソースの一覧情報を、人間が読みやすいテーブル形式で標準出力に出力する帳票である。

**業務上の目的・背景**：NetworkPolicyはPod間のネットワーク通信を制御するリソースであり、マイクロサービス間の通信ルールやセキュリティポリシーを定義する。本帳票により、クラスタ上で適用されているNetworkPolicyの一覧と、それぞれが対象とするPodのセレクタを確認でき、ネットワークセキュリティの管理とトラブルシューティングに活用される。

**帳票の利用シーン**：ネットワークポリシーの確認時、通信障害のトラブルシューティング時、セキュリティ監査時に利用される。

**主要な出力内容**：
1. NetworkPolicy名（Name）
2. 対象Pod選択条件（Pod-Selector）
3. 経過時間（Age）

**帳票の出力タイミング**：ユーザーが`kubectl get networkpolicies`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：ネットワーク管理者、セキュリティエンジニア、SRE、クラスタ管理者

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get networkpolicies` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式でヘッダー行に続いてリソースごとに1行ずつ出力される。

```
NAME              POD-SELECTOR   AGE
allow-frontend    app=frontend   5d
deny-all          <none>         10d
```

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | NetworkPolicy名 | `obj.Name` | 文字列 | 可変 |
| 2 | Pod-Selector | 対象Pod選択条件 | `obj.Spec.PodSelector` | ラベルセレクタ文字列 | 可変 |
| 3 | Age | 作成からの経過時間 | `obj.CreationTimestamp` | 人間可読形式 | 可変 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象Namespace（デフォルト: default） | No |
| LabelSelector | ラベルセレクタによるフィルタリング | No |
| FieldSelector | フィールドセレクタによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

該当なし（ターミナル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| NetworkPolicy（API Resource） | NetworkPolicy情報の取得 | APIサーバーの `/apis/networking.k8s.io/v1/networkpolicies` エンドポイント |

### テーブル別参照項目詳細

#### NetworkPolicy

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | - | - |
| `spec.podSelector` | Pod-Selector | - | `metav1.FormatLabelSelector`で文字列化 |
| `metadata.creationTimestamp` | Age | - | `translateTimestampSince`で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Pod-Selector | `metav1.FormatLabelSelector(&obj.Spec.PodSelector)` | - | 空セレクタの場合は`<none>`等のデフォルト表示（L2630） |
| Age | `translateTimestampSince(obj.CreationTimestamp)` | - | 人間可読の経過時間文字列 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get networkpolicies 実行] --> B[APIサーバーへリクエスト]
    B --> C[NetworkPolicyList取得]
    C --> D[printNetworkPolicyList呼出]
    D --> E[各NetworkPolicyに対してprintNetworkPolicy呼出]
    E --> F[PodSelectorをラベルセレクタ文字列に変換]
    F --> G[TableRow生成]
    G --> H[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | NetworkPolicyリソースが存在しない | `No resources found in {namespace} namespace` | Namespaceを確認 |
| API接続エラー | APIサーバーに接続できない | 接続エラーメッセージ | APIサーバーの稼働状態を確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十件〜数百件 |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- NetworkPolicyの閲覧にはNamespaceレベルまたはクラスタレベルのRBAC権限（`get`、`list`）が必要
- NetworkPolicyの一覧はクラスタのネットワークセキュリティ設計を示す情報であり、アクセス制御に注意が必要

## 備考

- NetworkPolicyはnetworking.k8s.io/v1 APIグループに属する
- Pod-Selector列にはIngress/Egressルールの詳細は含まれず、対象Pod選択条件のみ表示される
- Wideモード固有のカラムはない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/networking/types.go` | NetworkPolicy, NetworkPolicySpec構造体の定義。PodSelectorフィールドの理解 |

**読解のコツ**: `PodSelector`は`metav1.LabelSelector`型であり、`FormatLabelSelector`で文字列化される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | NetworkPolicy用テーブルハンドラ登録（L377-383） |

**主要処理フロー**:
1. **L377-380**: `networkPolicyColumnDefinitioins`でName, Pod-Selector, Ageの3カラムを定義
2. **L382-383**: ハンドラ登録

#### Step 3: 出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printNetworkPolicy`関数（L2626-2632） |

**主要処理フロー**:
- **L2630**: `metav1.FormatLabelSelector(&obj.Spec.PodSelector)`でPod-Selectorを文字列化し、Name, Pod-Selector, AgeをCellsに追加

### プログラム呼び出し階層図

```
kubectl get networkpolicies
    │
    ├─ get.go: RunGet()
    │      └─ APIサーバーへREST GET /apis/networking.k8s.io/v1/namespaces/{ns}/networkpolicies
    │
    ├─ printers.go: AddHandlers() [初期化時]
    │      └─ TableHandler登録 (networkPolicyColumnDefinitioins)
    │
    └─ printers.go: printNetworkPolicyList()
           └─ printNetworkPolicy() [各アイテム]
                  └─ FormatLabelSelector() [PodSelector文字列化]
```

### データフロー図

```
[入力]                          [処理]                           [出力]

APIサーバー ───▶ NetworkPolicyList取得 ───▶ 標準出力(テーブル)
  /apis/networking.k8s.io/    printNetworkPolicyList()    NAME  POD-SELECTOR  AGE
  v1/networkpolicies              └─ printNetworkPolicy()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | NetworkPolicyのテーブル出力ハンドラ定義・行生成ロジック |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | NetworkPolicy出力のテストケース（TestPrintNetworkPolicy L4475） |
| types.go | `pkg/apis/networking/types.go` | ソース | NetworkPolicy内部API型定義 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブル形式出力の共通基盤 |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
