# 帳票設計書 28-CertificateSigningRequest一覧

## 概要

本ドキュメントは、Kubernetes CertificateSigningRequest（CSR）リソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get csr`コマンドで使用される。

### 本帳票の処理概要

CertificateSigningRequestリソースの一覧情報を、人間が読みやすいテーブル形式で標準出力に出力する帳票である。

**業務上の目的・背景**：CSRはクラスタ内の証明書署名要求を管理するリソースであり、TLS証明書の発行プロセスの一環として使用される。本帳票により、クラスタ上のすべてのCSRの状態（承認待ち、承認済み、拒否済み、失敗、発行済み）を一覧で確認でき、証明書管理の運用とセキュリティ監査に活用される。kubelet証明書のローテーションなどの自動化プロセスの監視にも利用される。

**帳票の利用シーン**：証明書署名要求の承認・却下作業時、kubelet証明書ローテーションの監視時、TLS設定のトラブルシューティング時、セキュリティ監査時に利用される。

**主要な出力内容**：
1. CSR名（Name）
2. 経過時間（Age）
3. 署名者名（SignerName）
4. 要求者（Requestor）
5. 要求された有効期間（RequestedDuration）
6. 承認状態（Condition）

**帳票の出力タイミング**：ユーザーが`kubectl get csr`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：セキュリティエンジニア、クラスタ管理者、SRE、PKI管理者

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get csr` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式でヘッダー行に続いてリソースごとに1行ずつ出力される。

```
NAME        AGE   SIGNERNAME                                REQUESTOR             REQUESTEDDURATION   CONDITION
csr-abc12   5m    kubernetes.io/kube-apiserver-client-...   system:node:worker1   365d                Approved,Issued
csr-def34   10m   kubernetes.io/kubelet-serving             system:node:worker2   <none>              Pending
```

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | CSR名 | `obj.Name` | 文字列 | 可変 |
| 2 | Age | 作成からの経過時間 | `obj.CreationTimestamp` | 人間可読形式 | 可変 |
| 3 | SignerName | 署名者名 | `obj.Spec.SignerName` | 文字列または"<none>" | 可変 |
| 4 | Requestor | 要求者ユーザー名 | `obj.Spec.Username` | 文字列 | 可変 |
| 5 | RequestedDuration | 要求された有効期間 | `obj.Spec.ExpirationSeconds` | 人間可読期間または"<none>" | 可変 |
| 6 | Condition | 承認状態 | `obj.Status.Conditions` | "Pending"/"Approved"/"Denied" + ",Failed" + ",Issued" | 可変 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | CSRはクラスタスコープのため不要 | No |
| LabelSelector | ラベルセレクタによるフィルタリング | No |
| FieldSelector | フィールドセレクタによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

該当なし（ターミナル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| CertificateSigningRequest（API Resource） | CSR情報の取得 | APIサーバーの `/apis/certificates.k8s.io/v1/certificatesigningrequests` エンドポイント |

### テーブル別参照項目詳細

#### CertificateSigningRequest

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | - | - |
| `metadata.creationTimestamp` | Age | - | `translateTimestampSince`で変換 |
| `spec.signerName` | SignerName | - | 空文字列の場合は"<none>" |
| `spec.username` | Requestor | - | CSRを作成したユーザー名 |
| `spec.expirationSeconds` | RequestedDuration | - | nilの場合は"<none>"、それ以外は人間可読期間に変換 |
| `status.conditions` | Condition | - | `extractCSRStatus`関数で判定 |
| `status.certificate` | Condition（Issued判定） | - | 証明書データが存在すれば",Issued"を付加 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| SignerName | SignerNameが空文字列なら"<none>"、それ以外はそのまま | - | L2286-2289 |
| RequestedDuration | ExpirationSecondsがnilなら"<none>"、それ以外は`duration.HumanDuration(csr.ExpirationSecondsToDuration(*ExpirationSeconds))` | - | L2290-2293 |
| Condition | `extractCSRStatus(obj)` | - | L2285, L2298-2326 |

### Condition列の詳細判定ロジック

`extractCSRStatus`関数（L2298-2326）による判定：

1. Status.Conditionsを走査し、以下のフラグを設定：
   - `approved`: CertificateApproved条件が存在する場合
   - `denied`: CertificateDenied条件が存在する場合
   - `failed`: CertificateFailed条件が存在する場合

2. 優先順位に基づくステータス文字列生成（相互排他）：
   - `denied`が真 → "Denied"
   - `approved`が真 → "Approved"
   - いずれも偽 → "Pending"

3. 追加ステータスの付加：
   - `failed`が真 → ",Failed"を付加
   - `status.certificate`が存在 → ",Issued"を付加

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get csr 実行] --> B[APIサーバーへリクエスト]
    B --> C[CertificateSigningRequestList取得]
    C --> D[printCertificateSigningRequestList呼出]
    D --> E[各CSRに対してprintCertificateSigningRequest呼出]
    E --> F[extractCSRStatusでCondition判定]
    F --> G[SignerName/RequestedDuration判定]
    G --> H[TableRow生成]
    H --> I[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | CSRリソースが存在しない | `No resources found` | クラスタ設定を確認 |
| 権限不足 | RBAC権限がない | `Forbidden` | 適切なRBAC権限を付与 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数百件（自動ローテーション時は増加の可能性） |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- CSRの閲覧にはクラスタレベルのRBAC権限（`get`、`list`）が必要
- CSRの一覧はクラスタのPKI状態を示す重要なセキュリティ情報
- Requestor列にはCSR作成者のユーザー名が表示される

## 備考

- CSRはcertificates.k8s.io APIグループに属する
- クラスタスコープリソースのため、Namespace指定は不要
- Conditionは複合状態を取り得る（例："Approved,Issued"、"Denied,Failed"）
- Wideモード固有のカラムはない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/certificates/types.go` | CertificateSigningRequest, CertificateSigningRequestSpec, CertificateSigningRequestStatus構造体の定義 |

**読解のコツ**: `Status.Conditions`配列の各ConditionのTypeが"Approved"/"Denied"/"Failed"のいずれかを示す。`Status.Certificate`は署名済み証明書のバイト配列。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | CSR用テーブルハンドラ登録（L407-416） |

**主要処理フロー**:
1. **L407-413**: `certificateSigningRequestColumnDefinitions`で6カラムを定義
2. **L415-416**: ハンドラ登録

#### Step 3: 出力処理とステータス判定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printCertificateSigningRequest`関数（L2281-2296） |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | `extractCSRStatus`関数（L2298-2326）。ステータス判定の優先順位ロジック |

**主要処理フロー**:
- **L2285**: `extractCSRStatus`でCondition文字列を生成
- **L2286-2289**: SignerNameが空なら"<none>"
- **L2290-2293**: ExpirationSecondsがnilなら"<none>"、それ以外はHumanDurationで変換
- **L2298-2326**: Conditionsを走査してApproved/Denied/Failed状態を判定し、優先順位に基づいてステータス文字列を組み立て

### プログラム呼び出し階層図

```
kubectl get csr
    │
    ├─ get.go: RunGet()
    │      └─ APIサーバーへREST GET /apis/certificates.k8s.io/v1/certificatesigningrequests
    │
    ├─ printers.go: AddHandlers() [初期化時]
    │      └─ TableHandler登録 (certificateSigningRequestColumnDefinitions)
    │
    └─ printers.go: printCertificateSigningRequestList()
           └─ printCertificateSigningRequest() [各アイテム]
                  └─ extractCSRStatus() [ステータス判定]
                         └─ Conditions走査 → Approved/Denied/Pending + Failed + Issued
```

### データフロー図

```
[入力]                          [処理]                                 [出力]

APIサーバー ───▶ CSRList取得 ───▶ 標準出力(テーブル)
  /apis/certificates../v1/   printCertificateSigningRequestList()  NAME  AGE  SIGNERNAME  ...
  csr                            └─ printCertificateSigningRequest()
                                      └─ extractCSRStatus()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | CSRのテーブル出力ハンドラ定義・行生成ロジック・ステータス判定 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | CSR出力のテストケース |
| types.go | `pkg/apis/certificates/types.go` | ソース | CertificateSigningRequest内部API型定義 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブル形式出力の共通基盤 |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
