# 帳票設計書 29-ClusterTrustBundle一覧

## 概要

本ドキュメントは、Kubernetes ClusterTrustBundleリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get clustertrustbundles`コマンドで使用される。

### 本帳票の処理概要

ClusterTrustBundleリソースの一覧情報を、人間が読みやすいテーブル形式で標準出力に出力する帳票である。

**業務上の目的・背景**：ClusterTrustBundleはクラスタ内の信頼されたCA証明書バンドルを管理するリソースであり、TLS通信における信頼チェーンの管理に使用される。本帳票により、クラスタ上で管理されているTrustBundleの一覧とそれぞれの署名者名を確認でき、PKI（公開鍵基盤）の管理とセキュリティ監査に活用される。

**帳票の利用シーン**：Trust Bundle設定の確認時、PKI管理作業時、CA証明書の棚卸し時、TLS通信のトラブルシューティング時に利用される。

**主要な出力内容**：
1. ClusterTrustBundle名（Name）
2. 署名者名（SignerName）

**帳票の出力タイミング**：ユーザーが`kubectl get clustertrustbundles`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：セキュリティエンジニア、クラスタ管理者、PKI管理者

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get clustertrustbundles` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式でヘッダー行に続いてリソースごとに1行ずつ出力される。

```
NAME                                    SIGNERNAME
example.com:my-signer:abc123            example.com/my-signer
cluster-wide-trust                      <none>
```

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | ClusterTrustBundle名 | `obj.Name` | 文字列 | 可変 |
| 2 | SignerName | 署名者名 | `obj.Spec.SignerName` | 文字列または"<none>" | 可変 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | ClusterTrustBundleはクラスタスコープのため不要 | No |
| LabelSelector | ラベルセレクタによるフィルタリング | No |
| FieldSelector | フィールドセレクタによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

該当なし（ターミナル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ClusterTrustBundle（API Resource） | ClusterTrustBundle情報の取得 | APIサーバーの `/apis/certificates.k8s.io/v1beta1/clustertrustbundles` エンドポイント |

### テーブル別参照項目詳細

#### ClusterTrustBundle

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | - | - |
| `spec.signerName` | SignerName | - | 空文字列の場合は"<none>" |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| SignerName | SignerNameが空文字列なら"<none>"、それ以外はそのまま | - | L2344-2347 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get clustertrustbundles 実行] --> B[APIサーバーへリクエスト]
    B --> C[ClusterTrustBundleList取得]
    C --> D[printClusterTrustBundleList呼出]
    D --> E[各ClusterTrustBundleに対してprintClusterTrustBundle呼出]
    E --> F[SignerName判定]
    F --> G[TableRow生成]
    G --> H[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | ClusterTrustBundleリソースが存在しない | `No resources found` | クラスタ設定を確認 |
| API未対応 | APIバージョンが対応していない | APIエラーメッセージ | Kubernetesバージョンを確認 |
| 権限不足 | RBAC権限がない | `Forbidden` | 適切なRBAC権限を付与 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- ClusterTrustBundleの閲覧にはクラスタレベルのRBAC権限（`get`、`list`）が必要
- TrustBundleの一覧はクラスタのPKI構成を示す情報であり、セキュリティ上重要
- 一覧表示では証明書の中身（TrustBundle）は表示されない

## 備考

- ClusterTrustBundleはcertificates.k8s.io APIグループに属する
- クラスタスコープリソースのため、Namespace指定は不要
- Wideモード固有のカラムはない
- Ageカラムが存在しない点がほかのリソース一覧と異なる

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/certificates/types.go` | ClusterTrustBundle, ClusterTrustBundleSpec構造体の定義。SignerNameフィールドとTrustBundleフィールド |

**読解のコツ**: `Spec.SignerName`は任意フィールドであり、クラスタ全体で共有されるTrustBundleの場合は空になることがある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | ClusterTrustBundle用テーブルハンドラ登録（L418-423） |

**主要処理フロー**:
1. **L418-420**: `clusterTrustBundleColumnDefinitions`でName, SignerNameの2カラムを定義
2. **L422-423**: ハンドラ登録

#### Step 3: 出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printClusterTrustBundle`関数（L2340-2350） |

**主要処理フロー**:
- **L2344-2347**: SignerNameが空文字列なら"<none>"に置換
- **L2348**: Name, SignerNameをCellsに追加

### プログラム呼び出し階層図

```
kubectl get clustertrustbundles
    │
    ├─ get.go: RunGet()
    │      └─ APIサーバーへREST GET /apis/certificates.k8s.io/v1beta1/clustertrustbundles
    │
    ├─ printers.go: AddHandlers() [初期化時]
    │      └─ TableHandler登録 (clusterTrustBundleColumnDefinitions)
    │
    └─ printers.go: printClusterTrustBundleList()
           └─ printClusterTrustBundle() [各アイテム]
                  └─ SignerName判定 → TableRow生成
```

### データフロー図

```
[入力]                              [処理]                             [出力]

APIサーバー ───▶ ClusterTrustBundleList取得 ───▶ 標準出力(テーブル)
  /apis/certificates../        printClusterTrustBundleList()   NAME  SIGNERNAME
  clustertrustbundles              └─ printClusterTrustBundle()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | ClusterTrustBundleのテーブル出力ハンドラ定義・行生成ロジック |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | ClusterTrustBundle出力のテストケース（TestPrintClusterTrustBundle L7053） |
| types.go | `pkg/apis/certificates/types.go` | ソース | ClusterTrustBundle内部API型定義 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブル形式出力の共通基盤 |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
