# 帳票設計書 3-PodDisruptionBudget一覧

## 概要

本ドキュメントは、Kubernetes の PodDisruptionBudget（PDB）リソース一覧をテーブル形式で標準出力に出力する帳票の設計を定義する。`kubectl get pdb` コマンド実行時に使用される。

### 本帳票の処理概要

本帳票は、Kubernetes クラスタ上の PodDisruptionBudget リソースの一覧情報を、テーブル形式で標準出力に表示する処理を行う。

**業務上の目的・背景**：PodDisruptionBudget は、自発的な中断（ノードドレイン、ローリングアップデート等）時に最低限維持すべき Pod 数を定義するリソースである。クラスタのメンテナンスやアップグレード前に PDB の設定状況を確認し、サービスの可用性が適切に保護されているかを検証するために本帳票が必要となる。

**帳票の利用シーン**：ノードドレイン前の PDB 確認、クラスタアップグレード前の影響評価、PDB 設定の監査、許可される中断数の確認など。

**主要な出力内容**：
1. PDB 名（Name）
2. 最小利用可能数（Min Available）
3. 最大利用不可数（Max Unavailable）
4. 許可される中断数（Allowed Disruptions）
5. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザが `kubectl get pdb` または `kubectl get poddisruptionbudgets` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetes クラスタ管理者、SRE、プラットフォームエンジニア。

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | ターミナル（CLI） | N/A | `kubectl get pdb [flags]` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 標準出力（テキスト / テーブル形式） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテーブル表示 |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字（tabwriter による整列） |
| ヘッダー表示 | デフォルト有効 |
| Wide 出力 | 追加カラムなし |

## 帳票レイアウト

### レイアウト概要

```
┌──────────────────────────────────────────────────────────────────────────────┐
│  NAME    MIN AVAILABLE   MAX UNAVAILABLE   ALLOWED DISRUPTIONS   AGE       │
├──────────────────────────────────────────────────────────────────────────────┤
│  pdb-1   2               N/A               1                     5d        │
│  pdb-2   N/A             1                 0                     3d        │
└──────────────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | PDB の名前 | `obj.ObjectMeta.Name` | 文字列（name フォーマット） |
| 2 | Min Available | 最小利用可能 Pod 数 | `obj.Spec.MinAvailable` | IntOrString の文字列表現、未設定時は "N/A" |
| 3 | Max Unavailable | 最大利用不可 Pod 数 | `obj.Spec.MaxUnavailable` | IntOrString の文字列表現、未設定時は "N/A" |
| 4 | Allowed Disruptions | 現在許可される中断数 | `obj.Status.DisruptionsAllowed` | 整数（int64） |
| 5 | Age | 作成からの経過時間 | `obj.ObjectMeta.CreationTimestamp` | `translateTimestampSince` による人間可読形式 |

### 明細部

明細部は各 PDB につき 1 行。

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象 Namespace | No |
| All Namespaces | 全 Namespace 対象 | No |
| Label Selector | ラベルフィルタ | No |
| Field Selector | フィールドフィルタ | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | PDB 名（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: `/registry/poddisruptionbudgets/{namespace}/{name}` | PDB オブジェクトの永続化ストア | N/A |

### テーブル別参照項目詳細

#### PodDisruptionBudget リソース（API: `policy/v1/poddisruptionbudgets`）

| 参照項目（フィールド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | N/A | PDB の名前 |
| `metadata.creationTimestamp` | Age | N/A | 経過時間に変換 |
| `spec.minAvailable` | Min Available | N/A | IntOrString 型、nil なら "N/A" |
| `spec.maxUnavailable` | Max Unavailable | N/A | IntOrString 型、nil なら "N/A" |
| `status.disruptionsAllowed` | Allowed Disruptions | N/A | int32 を int64 にキャスト |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Min Available | `obj.Spec.MinAvailable != nil ? obj.Spec.MinAvailable.String() : "N/A"` | N/A | IntOrString の String() メソッド |
| Max Unavailable | `obj.Spec.MaxUnavailable != nil ? obj.Spec.MaxUnavailable.String() : "N/A"` | N/A | IntOrString の String() メソッド |
| Allowed Disruptions | `int64(obj.Status.DisruptionsAllowed)` | N/A | 整数キャスト |
| Age | `translateTimestampSince(obj.CreationTimestamp)` | HumanDuration | 経過時間 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get pdb 実行] --> B[API サーバへリクエスト]
    B --> C[PDB リスト取得]
    C --> D[printPodDisruptionBudgetList]
    D --> E[printPodDisruptionBudget で各行生成]
    E --> F[HumanReadablePrinter でテーブル出力]
    F --> G[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | PDB が存在しない | `No resources found in {namespace} namespace.` | 条件見直し |
| API エラー | 接続失敗 | API エラーメッセージ | kubeconfig 確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 通常は少数（数件〜数十件） |
| 目標出力時間 | 即時 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

- PDB 一覧取得には `poddisruptionbudgets` リソースの `list` / `get` 権限が必要
- 機密情報は含まれない

## 備考

- MinAvailable と MaxUnavailable は排他的設定（一方のみ設定可能）
- Allowed Disruptions はコントローラにより自動計算される値

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printers.go | `pkg/printers/internalversion/printers.go` | podDisruptionBudgetColumnDefinitions（行 119-125）: Name, Min Available, Max Unavailable, Allowed Disruptions, Age の 5 カラム |

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | kubectl get コマンドの共通エントリーポイント |

#### Step 3: print 関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printPodDisruptionBudget`（行 1126-1147）: MinAvailable/MaxUnavailable の nil チェックと "N/A" フォールバック、DisruptionsAllowed の int64 キャスト |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | `printPodDisruptionBudgetList`（行 1149-1159）: Items を順に printPodDisruptionBudget に委譲 |

**主要処理フロー**:
- **行 1131-1137**: MinAvailable が nil なら "N/A"、そうでなければ String() で文字列化
- **行 1139-1143**: MaxUnavailable が nil なら "N/A"、そうでなければ String() で文字列化
- **行 1145**: Name, minAvailable, maxUnavailable, DisruptionsAllowed(int64), Age をセルに追加

### プログラム呼び出し階層図

```
kubectl get pdb
    |
    +-- GetOptions.Run() [get.go]
           |
           +-- API Server Request
           |       |
           |       +-- printPodDisruptionBudgetList() [printers.go 行1149]
           |               |
           |               +-- printPodDisruptionBudget() [printers.go 行1126]
           |
           +-- HumanReadablePrinter.PrintObj()
```

### データフロー図

```
[入力]                              [処理]                              [出力]

API Server (etcd)              printPodDisruptionBudget()         標準出力 (stdout)
  PDB Object              --> - MinAvailable nil チェック      --> テーブル形式テキスト
  (policy.PodDisruption       - MaxUnavailable nil チェック        NAME  MIN AVAILABLE ...
   Budget)                    - DisruptionsAllowed int64 変換      pdb1  2  N/A  1  5d
                              - TableRow 生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | PDB 用カラム定義と print 関数（行 119-127, 1126-1159） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルレンダリング |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl get コマンドエントリーポイント |
