# 帳票設計書 30-PodCertificateRequest一覧

## 概要

本ドキュメントは、Kubernetes PodCertificateRequestリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get podcertificaterequests`コマンドで使用される。

### 本帳票の処理概要

PodCertificateRequestリソースの一覧情報を、人間が読みやすいテーブル形式で標準出力に出力する帳票である。

**業務上の目的・背景**：PodCertificateRequestはPodに対する証明書署名要求を管理するリソースであり、Pod単位のTLS証明書発行プロセスを管理する。本帳票により、クラスタ上のPod証明書要求の状態（発行待ち、発行済み、拒否、失敗）を一覧で確認でき、Pod単位の証明書管理の運用とセキュリティ監査に活用される。従来のCertificateSigningRequest（CSR）がクラスタ全体の汎用的な証明書要求であるのに対し、PodCertificateRequestはPodに紐付いた証明書要求に特化している。

**帳票の利用シーン**：Pod証明書の発行状態確認時、mTLS設定のトラブルシューティング時、Pod間通信のセキュリティ監査時に利用される。

**主要な出力内容**：
1. PodCertificateRequest名（Name）
2. 対象Pod名（PodName）
3. ServiceAccount名（ServiceAccountName）
4. ノード名（NodeName）
5. 署名者名（SignerName）
6. 状態（State）
7. 未検証ユーザーアノテーション（UnverifiedUserAnnotations、Wideモード）

**帳票の出力タイミング**：ユーザーが`kubectl get podcertificaterequests`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：セキュリティエンジニア、クラスタ管理者、SRE、PKI管理者

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLIターミナル | - | `kubectl get podcertificaterequests` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式でヘッダー行に続いてリソースごとに1行ずつ出力される。`-o wide`オプションで追加カラムが表示される。

```
NAME          PODNAME      SERVICEACCOUNTNAME   NODENAME    SIGNERNAME                STATE
pcr-abc123    my-pod       default              worker-01   example.com/my-signer     Issued
pcr-def456    other-pod    app-sa               worker-02   example.com/my-signer     Pending
```

Wideモード時：
```
NAME          PODNAME   SERVICEACCOUNTNAME   NODENAME    SIGNERNAME               STATE     UNVERIFIEDUSERANNOTATIONS
pcr-abc123    my-pod    default              worker-01   example.com/my-signer    Issued    key1=val1,key2=val2
```

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | PodCertificateRequest名 | `obj.Name` | 文字列 | 可変 |
| 2 | PodName | 対象Pod名 | `obj.Spec.PodName` | 文字列 | 可変 |
| 3 | ServiceAccountName | ServiceAccount名 | `obj.Spec.ServiceAccountName` | 文字列 | 可変 |
| 4 | NodeName | ノード名 | `obj.Spec.NodeName` | 文字列 | 可変 |
| 5 | SignerName | 署名者名 | `obj.Spec.SignerName` | 文字列 | 可変 |
| 6 | State | 状態 | `obj.Status.Conditions` | "Pending"/"Issued"/"Denied"/"Failed" | 可変 |
| 7 | UnverifiedUserAnnotations | 未検証アノテーション（Wide） | `obj.Spec.UnverifiedUserAnnotations` | ラベル形式 | 可変 |

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象Namespace（デフォルト: default） | No |
| LabelSelector | ラベルセレクタによるフィルタリング | No |
| FieldSelector | フィールドセレクタによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

該当なし（ターミナル出力のため改ページなし）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| PodCertificateRequest（API Resource） | PodCertificateRequest情報の取得 | APIサーバーの `/apis/certificates.k8s.io/v1beta1/podcertificaterequests` エンドポイント |

### テーブル別参照項目詳細

#### PodCertificateRequest

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | - | - |
| `spec.podName` | PodName | - | 証明書要求の対象Pod名 |
| `spec.serviceAccountName` | ServiceAccountName | - | Podに紐付くServiceAccount |
| `spec.nodeName` | NodeName | - | Podが動作するノード名 |
| `spec.signerName` | SignerName | - | 証明書の署名者名 |
| `status.conditions` | State | - | Conditionタイプから状態を判定 |
| `spec.unverifiedUserAnnotations` | UnverifiedUserAnnotations | Wide時のみ | `labels.FormatLabels`で文字列化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| State | Status.Conditionsを走査し、Issued/Denied/Failedの条件タイプを検出。いずれも存在しなければ"Pending" | - | L2371-2381 |
| UnverifiedUserAnnotations | `labels.FormatLabels(obj.Spec.UnverifiedUserAnnotations)` | - | Wide時のみ（L2385） |

### State列の詳細判定ロジック

`printPodCertificateRequest`関数（L2364-2388）による判定：

1. 初期値は"Pending"（L2371）
2. Status.Conditionsを走査（L2372-2381）：
   - `PodCertificateRequestConditionTypeIssued` → "Issued"
   - `PodCertificateRequestConditionTypeDenied` → "Denied"
   - `PodCertificateRequestConditionTypeFailed` → "Failed"
3. Issued, Denied, Failedは相互排他（最後に検出された状態が優先）

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get podcertificaterequests 実行] --> B[APIサーバーへリクエスト]
    B --> C[PodCertificateRequestList取得]
    C --> D[printPodCertificateRequestList呼出]
    D --> E[各PodCertificateRequestに対してprintPodCertificateRequest呼出]
    E --> F[ConditionsからState判定]
    F --> G{Wideモード?}
    G -->|Yes| H[UnverifiedUserAnnotations追加]
    G -->|No| I[TableRow生成]
    H --> I
    I --> J[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | PodCertificateRequestリソースが存在しない | `No resources found in {namespace} namespace` | Namespaceを確認 |
| API未対応 | APIバージョンが対応していない | APIエラーメッセージ | Kubernetesバージョンを確認 |
| 権限不足 | RBAC権限がない | `Forbidden` | 適切なRBAC権限を付与 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十件〜数百件 |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | 制限なし |

## セキュリティ考慮事項

- PodCertificateRequestの閲覧にはNamespaceレベルまたはクラスタレベルのRBAC権限（`get`、`list`）が必要
- PodCertificateRequestの一覧にはPod名、ServiceAccount名、ノード名が含まれ、クラスタのトポロジー情報が推測される可能性がある
- UnverifiedUserAnnotationsはユーザー提供の未検証情報であり、信頼性に注意

## 備考

- PodCertificateRequestはcertificates.k8s.io APIグループに属する
- Ageカラムが存在しない点がほかのリソース一覧と異なる
- `-o wide`オプションでUnverifiedUserAnnotationsカラムが追加表示される
- StateはCSRのConditionとは異なり、Issued/Denied/Failedが相互排他であり、複合状態を取らない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/certificates/types.go` | PodCertificateRequest, PodCertificateRequestSpec, PodCertificateRequestStatus構造体の定義 |

**読解のコツ**: `Spec`にはPodName, ServiceAccountName, NodeName, SignerName, UnverifiedUserAnnotationsフィールドが含まれる。`Status.Conditions`で証明書要求の状態を管理。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | PodCertificateRequest用テーブルハンドラ登録（L425-435） |

**主要処理フロー**:
1. **L425-432**: `podCertificateRequestColumnDefinitions`で7カラムを定義（Name, PodName, ServiceAccountName, NodeName, SignerName, State, UnverifiedUserAnnotations）
2. **L434-435**: ハンドラ登録

#### Step 3: 出力処理とState判定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printPodCertificateRequest`関数（L2364-2388） |

**主要処理フロー**:
- **L2371**: State初期値を"Pending"に設定
- **L2372-2381**: Status.Conditionsを走査し、ConditionTypeに応じてstateを更新
  - `PodCertificateRequestConditionTypeIssued` → "Issued"
  - `PodCertificateRequestConditionTypeDenied` → "Denied"
  - `PodCertificateRequestConditionTypeFailed` → "Failed"
- **L2383**: Name, PodName, ServiceAccountName, NodeName, SignerName, StateをCellsに追加
- **L2384-2386**: Wideモード時に`labels.FormatLabels(obj.Spec.UnverifiedUserAnnotations)`を追加

### プログラム呼び出し階層図

```
kubectl get podcertificaterequests
    │
    ├─ get.go: RunGet()
    │      └─ APIサーバーへREST GET /apis/certificates.k8s.io/v1beta1/namespaces/{ns}/podcertificaterequests
    │
    ├─ printers.go: AddHandlers() [初期化時]
    │      └─ TableHandler登録 (podCertificateRequestColumnDefinitions)
    │
    └─ printers.go: printPodCertificateRequestList()
           └─ printPodCertificateRequest() [各アイテム]
                  ├─ Conditions走査 → State判定
                  └─ labels.FormatLabels() [Wide時 UnverifiedUserAnnotations]
```

### データフロー図

```
[入力]                               [処理]                                    [出力]

APIサーバー ───▶ PodCertificateRequestList取得 ───▶ 標準出力(テーブル)
  /apis/certificates../        printPodCertificateRequestList()     NAME  PODNAME  ...  STATE
  podcertificaterequests           └─ printPodCertificateRequest()
                                        └─ Conditions → State
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | PodCertificateRequestのテーブル出力ハンドラ定義・行生成ロジック |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | PodCertificateRequest出力のテストケース（TestPrintPodCertificateRequest L7090） |
| types.go | `pkg/apis/certificates/types.go` | ソース | PodCertificateRequest内部API型定義 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブル形式出力の共通基盤 |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
