# 帳票設計書 31-Lease一覧

## 概要

本ドキュメントは、Kubernetes CLIツール（kubectl）における Lease リソースの一覧表示機能に関する帳票設計書である。`kubectl get leases` コマンド実行時にLeaseリソースをテーブル形式で出力する仕組みを定義する。

### 本帳票の処理概要

Leaseリソースの一覧情報をテーブル形式で標準出力に表示する機能である。Kubernetes の分散リーダー選出やノードハートビートの仕組みに用いられるLeaseオブジェクトの状態を、運用者が一覧で確認できるようにする。

**業務上の目的・背景**：Leaseリソースは Kubernetes クラスタにおけるリーダー選出（Leader Election）やノードのハートビート管理に利用される重要なリソースである。クラスタ管理者がリーダー選出の状況やノードの死活状態を確認するために、Lease一覧表示が必要となる。

**帳票の利用シーン**：クラスタの運用監視時に、どのコンポーネントがリーダーとして選出されているか、ノードのハートビートが正常に更新されているかを確認する場面で利用される。障害調査時にリーダーの切り替わりやハートビートの途絶を確認する場合にも使用する。

**主要な出力内容**：
1. Leaseリソースの名前（Name）
2. リースホルダーのID（Holder）
3. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get leases` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタの管理者、SRE、DevOpsエンジニア。

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get leases` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテキスト出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、ヘッダー行に続いて各Leaseリソースが1行ずつ表示される。

```
┌──────────────────────────────────────────────┐
│  NAME          HOLDER              AGE       │
├──────────────────────────────────────────────┤
│  lease-name    holder-identity     3d        │
│  ...                                         │
└──────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | Leaseリソースの名前 | ObjectMeta.Name | 文字列（Format: "name"） |
| 2 | Holder | リースを保持しているコンポーネントのID | Spec.HolderIdentity | 文字列（nilの場合は空文字） |
| 3 | Age | リソース作成からの経過時間 | ObjectMeta.CreationTimestamp | 人間可読な時間表記（例: 3d, 5h） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | Leaseリソース名 | obj.Name | 文字列 | 可変 |
| 2 | Holder | ホルダーID | obj.Spec.HolderIdentity | 文字列（*string、nilなら空文字） | 可変 |
| 3 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | duration.HumanDuration形式 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 指定されたNamespace内のLeaseリソースを取得 | No（デフォルト: 現在のNamespace） |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

テキスト出力のため改ページは発生しない。大量データの場合は `--chunk-size` オプションによるページネーションが可能。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/leases/{namespace}/{name} | Leaseリソースの実体データ | Namespace + Name |

### テーブル別参照項目詳細

#### Lease (coordination.k8s.io/v1)

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| spec.holderIdentity | Holder | - | ポインタ型。nilの場合は空文字を表示 |
| metadata.creationTimestamp | Age | - | translateTimestampSince関数で経過時間に変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | time.Since(creationTimestamp) | HumanDuration関数で近似表示 | 秒/分/時/日/年に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get leases 実行] --> B[APIサーバーへLease一覧リクエスト]
    B --> C[Leaseリソース一覧取得]
    C --> D[HumanReadableGenerator.GenerateTable呼び出し]
    D --> E[printLease/printLeaseList関数でTableRow生成]
    E --> F[HumanReadablePrinter.PrintObjでテーブル描画]
    F --> G[標準出力へ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 指定Namespaceにリソースが存在しない | No resources found in {namespace} namespace. | 正常系。Namespace指定やラベル条件を確認 |
| 権限エラー | RBAC権限不足 | Error from server (Forbidden) | 適切なRoleBindingの設定 |
| 接続エラー | APIサーバーに接続不可 | The connection to the server was refused | APIサーバーの状態確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百件（Namespace単位） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | CLIツールのため制限なし |

## セキュリティ考慮事項

Leaseリソースへのアクセスは RBAC によって制御される。HolderIdentity にはノード名やコンポーネント名が含まれるため、クラスタ内部構造の情報漏洩に注意が必要。

## 備考

- Leaseリソースは `coordination.k8s.io/v1` APIグループに属する
- HolderIdentityはポインタ型（*string）であり、nil の場合は空文字として表示される
- `kubectl get leases -o wide` を指定しても追加カラムは表示されない（Wide列定義なし）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Leaseリソースの内部表現およびAPI型定義を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/coordination/types.go` | Lease / LeaseSpec の内部型定義。HolderIdentity が *string 型であることを確認 |
| 1-2 | types.go | `staging/src/k8s.io/api/coordination/v1/types.go` | 外部API型定義。SwaggerDocでカラム説明文を取得 |

**読解のコツ**: Kubernetes では内部型（`pkg/apis/`配下）と外部API型（`staging/src/k8s.io/api/`配下）が分離されている。printer は内部型を受け取る。

#### Step 2: エントリーポイントを理解する

テーブル出力のハンドラ登録部分を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数（93行目）内で、leaseColumnDefinitions（437行目）としてカラム定義を登録 |

**主要処理フロー**:
1. **437行目**: leaseColumnDefinitions で Name, Holder, Age の3カラムを定義
2. **442行目**: printLease をテーブルハンドラとして登録
3. **443行目**: printLeaseList をテーブルハンドラとして登録

#### Step 3: プリンター関数を理解する

実際のデータからテーブル行を生成する関数を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printLease関数（2711行目）: 単一Leaseオブジェクトからテーブル行を生成 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printLeaseList関数（2724行目）: LeaseListから各要素をループしてテーブル行を生成 |
| 3-3 | printers.go | `pkg/printers/internalversion/printers.go` | translateTimestampSince関数（863行目）: CreationTimestampを経過時間文字列に変換 |

**主要処理フロー**:
- **2716-2718行目**: HolderIdentityがnilでなければ値を取得、nilなら空文字
- **2720行目**: Name, HolderIdentity, Age をセルに追加

#### Step 4: テーブル出力基盤を理解する

テーブル生成の共通基盤を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | tablegenerator.go | `pkg/printers/tablegenerator.go` | HumanReadableGenerator がハンドラマップを管理し、GenerateTable で適切なプリンタを呼び出す |
| 4-2 | tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | HumanReadablePrinter.PrintObj（95行目）でテーブルをテキスト出力 |

### プログラム呼び出し階層図

```
kubectl get leases
    |
    +-- APIサーバーからLease一覧取得
    |
    +-- HumanReadableGenerator.GenerateTable()  [pkg/printers/tablegenerator.go:78]
           |
           +-- printLeaseList()  [pkg/printers/internalversion/printers.go:2724]
           |       |
           |       +-- printLease()  [pkg/printers/internalversion/printers.go:2711]
           |              |
           |              +-- translateTimestampSince()  [pkg/printers/internalversion/printers.go:863]
           |
           +-- HumanReadablePrinter.PrintObj()  [staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go:95]
```

### データフロー図

```
[入力]                    [処理]                              [出力]

etcd Lease データ ──> APIサーバー List ──> printLeaseList() ──> metav1.TableRow[] ──> テーブルテキスト ──> stdout
                                             |
                                             +-- HolderIdentity nil判定
                                             +-- translateTimestampSince()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | Leaseプリンタ関数の実装（printLease: 2711行目, printLeaseList: 2724行目, カラム定義: 437行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成の共通基盤（HumanReadableGenerator） |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルのテキスト描画（HumanReadablePrinter） |
| types.go | `pkg/apis/coordination/types.go` | ソース | Lease内部型定義 |
| types.go | `staging/src/k8s.io/api/coordination/v1/types.go` | ソース | Lease外部API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printLease関数のテスト |
