# 帳票設計書 32-LeaseCandidate一覧

## 概要

本ドキュメントは、Kubernetes CLIツール（kubectl）における LeaseCandidate リソースの一覧表示機能に関する帳票設計書である。`kubectl get leasecandidates` コマンド実行時に LeaseCandidateリソースをテーブル形式で出力する仕組みを定義する。

### 本帳票の処理概要

LeaseCandidateリソースの一覧情報をテーブル形式で標準出力に表示する機能である。Kubernetesの協調リーダー選出（Coordinated Leader Election）機能において、リーダー候補となるコンポーネントの情報を一覧で確認できるようにする。

**業務上の目的・背景**：LeaseCandidateは coordination.k8s.io/v1alpha2 APIグループに属するアルファ機能のリソースである。協調リーダー選出メカニズムにおいて、リーダー候補のバイナリバージョンやエミュレーションバージョンを管理するために使用される。クラスタの段階的アップグレード時に、どのバージョンのコンポーネントがリーダー候補として登録されているかを確認する必要がある。

**帳票の利用シーン**：クラスタのローリングアップグレード時に、リーダー選出の候補コンポーネントがどのバージョンで動作しているかを確認する場面で利用される。バージョンの不整合が疑われる場合の調査にも使用する。

**主要な出力内容**：
1. LeaseCandidateリソースの名前（Name）
2. 対象となるリース名（LeaseName）
3. バイナリバージョン（BinaryVersion）
4. エミュレーションバージョン（EmulationVersion）
5. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get leasecandidates` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタの管理者、SRE、プラットフォームエンジニア。

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get leasecandidates` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテキスト出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、ヘッダー行に続いて各LeaseCandidateリソースが1行ずつ表示される。

```
┌────────────────────────────────────────────────────────────────────────────┐
│  NAME       LEASENAME    BINARYVERSION    EMULATIONVERSION    AGE        │
├────────────────────────────────────────────────────────────────────────────┤
│  candidate  lease-1      v1.30.0          v1.29.0             5m         │
│  ...                                                                      │
└────────────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | LeaseCandidateリソースの名前 | ObjectMeta.Name | 文字列（Format: "name"） |
| 2 | LeaseName | 対象のリース名 | Spec.LeaseName | 文字列 |
| 3 | BinaryVersion | バイナリバージョン | Spec.BinaryVersion | 文字列 |
| 4 | EmulationVersion | エミュレーションバージョン | Spec.EmulationVersion | 文字列 |
| 5 | Age | リソース作成からの経過時間 | ObjectMeta.CreationTimestamp | 人間可読な時間表記 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | 文字列 | 可変 |
| 2 | LeaseName | リース名 | obj.Spec.LeaseName | 文字列 | 可変 |
| 3 | BinaryVersion | バイナリバージョン | obj.Spec.BinaryVersion | 文字列 | 可変 |
| 4 | EmulationVersion | エミュレーションバージョン | obj.Spec.EmulationVersion | 文字列 | 可変 |
| 5 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | duration.HumanDuration形式 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 指定されたNamespace内のLeaseCandidateリソースを取得 | No（デフォルト: 現在のNamespace） |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

テキスト出力のため改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/leasecandidates/{namespace}/{name} | LeaseCandidateリソースの実体データ | Namespace + Name |

### テーブル別参照項目詳細

#### LeaseCandidate (coordination.k8s.io/v1alpha2)

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| spec.leaseName | LeaseName | - | 対象リース名 |
| spec.binaryVersion | BinaryVersion | - | バイナリバージョン文字列 |
| spec.emulationVersion | EmulationVersion | - | エミュレーションバージョン文字列 |
| metadata.creationTimestamp | Age | - | translateTimestampSince関数で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | time.Since(creationTimestamp) | HumanDuration関数で近似表示 | 秒/分/時/日/年に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get leasecandidates 実行] --> B[APIサーバーへLeaseCandidate一覧リクエスト]
    B --> C[LeaseCandidateリソース一覧取得]
    C --> D[HumanReadableGenerator.GenerateTable呼び出し]
    D --> E[printLeaseCandidate/printLeaseCandidateList関数でTableRow生成]
    E --> F[HumanReadablePrinter.PrintObjでテーブル描画]
    F --> G[標準出力へ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 指定Namespaceにリソースが存在しない | No resources found in {namespace} namespace. | 正常系。フィーチャーゲート有効化を確認 |
| 権限エラー | RBAC権限不足 | Error from server (Forbidden) | 適切なRoleBindingの設定 |
| APIバージョンエラー | v1alpha2未サポート環境 | the server doesn't have a resource type | フィーチャーゲートの確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | CLIツールのため制限なし |

## セキュリティ考慮事項

LeaseCandidateリソースへのアクセスはRBACによって制御される。バージョン情報が含まれるため、クラスタ内部のバージョン構成情報の漏洩に注意が必要。

## 備考

- LeaseCandidateはアルファ機能（coordination.k8s.io/v1alpha2）であり、対応するフィーチャーゲートが有効な場合のみ利用可能
- 全フィールドが直接値（ポインタ型でない）のため、nil判定は不要
- `kubectl get leasecandidates -o wide` で追加カラムは表示されない

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

LeaseCandidateリソースの型定義を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/coordination/types.go` | LeaseCandidate / LeaseCandidateSpec の内部型定義。LeaseName, BinaryVersion, EmulationVersion フィールドを確認 |
| 1-2 | types.go | `staging/src/k8s.io/api/coordination/v1alpha2/types.go` | 外部API型定義。SwaggerDocからカラム説明文を取得 |

**読解のコツ**: v1alpha2のAPIバージョンであるため、将来のバージョン変更に注意。

#### Step 2: エントリーポイントを理解する

テーブル出力のハンドラ登録部分を確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内で、leaseCandidateColumnDefinitions（445行目）としてカラム定義を登録 |

**主要処理フロー**:
1. **445行目**: leaseCandidateColumnDefinitions で Name, LeaseName, BinaryVersion, EmulationVersion, Age の5カラムを定義
2. **452行目**: printLeaseCandidate をテーブルハンドラとして登録
3. **453行目**: printLeaseCandidateList をテーブルハンドラとして登録

#### Step 3: プリンター関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printLeaseCandidate関数（2736行目）: 単一オブジェクトからテーブル行を生成 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printLeaseCandidateList関数（2745行目）: リストからループ処理 |

**主要処理フロー**:
- **2741行目**: Name, LeaseName, BinaryVersion, EmulationVersion, Age をセルに直接追加（nil判定不要）

### プログラム呼び出し階層図

```
kubectl get leasecandidates
    |
    +-- APIサーバーからLeaseCandidate一覧取得
    |
    +-- HumanReadableGenerator.GenerateTable()  [pkg/printers/tablegenerator.go:78]
           |
           +-- printLeaseCandidateList()  [pkg/printers/internalversion/printers.go:2745]
           |       |
           |       +-- printLeaseCandidate()  [pkg/printers/internalversion/printers.go:2736]
           |              |
           |              +-- translateTimestampSince()  [pkg/printers/internalversion/printers.go:863]
           |
           +-- HumanReadablePrinter.PrintObj()  [staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go:95]
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

etcd LeaseCandidate データ ──> APIサーバー List ──> printLeaseCandidateList() ──> metav1.TableRow[] ──> テーブルテキスト ──> stdout
                                                        |
                                                        +-- translateTimestampSince()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | LeaseCandidateプリンタ関数の実装（printLeaseCandidate: 2736行目, カラム定義: 445行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルテキスト描画 |
| types.go | `pkg/apis/coordination/types.go` | ソース | LeaseCandidate内部型定義 |
| types.go | `staging/src/k8s.io/api/coordination/v1alpha2/types.go` | ソース | LeaseCandidate外部API型定義 |
