# 帳票設計書 33-StorageClass一覧

## 概要

本ドキュメントは、Kubernetes CLIツール（kubectl）における StorageClass リソースの一覧表示機能に関する帳票設計書である。`kubectl get sc` コマンド実行時に StorageClassリソースをテーブル形式で出力する仕組みを定義する。

### 本帳票の処理概要

StorageClassリソースの一覧情報をテーブル形式で標準出力に表示する機能である。クラスタで利用可能なストレージプロビジョナーの種類、回収ポリシー、ボリュームバインディングモードなどを一覧で確認できるようにする。

**業務上の目的・背景**：StorageClassはKubernetesにおける動的ボリュームプロビジョニングの基盤であり、PersistentVolumeClaimが要求するストレージの種類や品質を定義する。クラスタ管理者は利用可能なStorageClassとその設定を把握する必要があり、デフォルトStorageClassの確認もこの一覧で行う。

**帳票の利用シーン**：ストレージ関連の問題調査時、新規アプリケーションデプロイ前のStorageClass確認時、クラスタのストレージ構成の監査時に利用される。デフォルトStorageClassの設定確認にも使用する。

**主要な出力内容**：
1. StorageClassの名前（Name）（デフォルトの場合は "(default)" が付与される）
2. プロビジョナー名（Provisioner）
3. 回収ポリシー（ReclaimPolicy）
4. ボリュームバインディングモード（VolumeBindingMode）
5. ボリューム拡張の可否（AllowVolumeExpansion）
6. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get sc` または `kubectl get storageclasses` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタの管理者、ストレージ管理者、アプリケーション開発者。

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get sc` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテキスト出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、ヘッダー行に続いて各StorageClassリソースが1行ずつ表示される。

```
┌──────────────────────────────────────────────────────────────────────────────────────────┐
│  NAME                PROVISIONER         RECLAIMPOLICY   VOLUMEBINDINGMODE   ALLOWVOLUMEEXPANSION   AGE │
├──────────────────────────────────────────────────────────────────────────────────────────┤
│  standard (default)  k8s.io/minikube     Delete          Immediate           false                  30d │
│  ...                                                                                                     │
└──────────────────────────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | StorageClassの名前 | ObjectMeta.Name + デフォルトアノテーション判定 | 文字列（Format: "name"）。デフォルトの場合 " (default)" 付与 |
| 2 | Provisioner | プロビジョナー名 | Provisioner | 文字列 |
| 3 | ReclaimPolicy | PV回収ポリシー | ReclaimPolicy | 文字列（デフォルト: "Delete"） |
| 4 | VolumeBindingMode | ボリュームバインディングモード | VolumeBindingMode | 文字列（デフォルト: "Immediate"） |
| 5 | AllowVolumeExpansion | ボリューム拡張可否 | AllowVolumeExpansion | boolean（デフォルト: false） |
| 6 | Age | リソース作成からの経過時間 | ObjectMeta.CreationTimestamp | 人間可読な時間表記 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名（+デフォルト表記） | obj.Name + IsDefaultAnnotation判定 | 文字列 | 可変 |
| 2 | Provisioner | プロビジョナー | obj.Provisioner | 文字列 | 可変 |
| 3 | ReclaimPolicy | 回収ポリシー | *obj.ReclaimPolicy（nilなら"Delete"） | 文字列 | 可変 |
| 4 | VolumeBindingMode | バインディングモード | *obj.VolumeBindingMode（nilなら"Immediate"） | 文字列 | 可変 |
| 5 | AllowVolumeExpansion | 拡張可否 | *obj.AllowVolumeExpansion（nilならfalse） | boolean | 可変 |
| 6 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | HumanDuration形式 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

テキスト出力のため改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/storageclasses/{name} | StorageClassリソースの実体データ | Name |

### テーブル別参照項目詳細

#### StorageClass (storage.k8s.io/v1)

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | IsDefaultAnnotation判定で"(default)"付与 |
| metadata.annotations["storageclass.kubernetes.io/is-default-class"] | Name(デフォルト判定) | - | "true"の場合にデフォルト表記 |
| provisioner | Provisioner | - | - |
| reclaimPolicy | ReclaimPolicy | - | ポインタ型。nilの場合は"Delete"をデフォルト表示 |
| volumeBindingMode | VolumeBindingMode | - | ポインタ型。nilの場合は"Immediate"をデフォルト表示 |
| allowVolumeExpansion | AllowVolumeExpansion | - | ポインタ型。nilの場合はfalseをデフォルト表示 |
| metadata.creationTimestamp | Age | - | translateTimestampSince関数で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Name（デフォルト表記） | IsDefaultAnnotation(obj.ObjectMeta) ? name + " (default)" : name | - | storageutil.IsDefaultAnnotation で判定 |
| ReclaimPolicy（デフォルト） | obj.ReclaimPolicy != nil ? *obj.ReclaimPolicy : "Delete" | - | ポインタnil時のフォールバック |
| VolumeBindingMode（デフォルト） | obj.VolumeBindingMode != nil ? *obj.VolumeBindingMode : "Immediate" | - | ポインタnil時のフォールバック |
| AllowVolumeExpansion（デフォルト） | obj.AllowVolumeExpansion != nil ? *obj.AllowVolumeExpansion : false | - | ポインタnil時のフォールバック |
| Age | time.Since(creationTimestamp) | HumanDuration関数で近似表示 | 秒/分/時/日/年に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get sc 実行] --> B[APIサーバーへStorageClass一覧リクエスト]
    B --> C[StorageClassリソース一覧取得]
    C --> D[HumanReadableGenerator.GenerateTable呼び出し]
    D --> E[printStorageClass/printStorageClassList関数でTableRow生成]
    E --> F[デフォルトSC判定 - IsDefaultAnnotation]
    F --> G[ポインタ型フィールドのnil判定とデフォルト値適用]
    G --> H[HumanReadablePrinter.PrintObjでテーブル描画]
    H --> I[標準出力へ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | StorageClassが1つも定義されていない | No resources found | StorageClassの作成 |
| 権限エラー | RBAC権限不足 | Error from server (Forbidden) | ClusterRoleBindingの設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | CLIツールのため制限なし |

## セキュリティ考慮事項

StorageClassはクラスタスコープのリソースであり、アクセスにはクラスタレベルのRBAC権限が必要。ストレージプロビジョナーの構成情報が含まれるため、クラスタインフラ構成の漏洩に注意。

## 備考

- StorageClassはクラスタスコープリソース（Namespaceなし）
- ReclaimPolicy, VolumeBindingMode, AllowVolumeExpansion はすべてポインタ型であり、nilの場合にデフォルト値を表示する独自ロジックがある
- デフォルトStorageClassの判定は `storageutil.IsDefaultAnnotation` 関数で行われる（アノテーション `storageclass.kubernetes.io/is-default-class` が "true" の場合）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

StorageClassリソースの型定義を把握する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/storage/types.go` | StorageClass内部型定義。ReclaimPolicy, VolumeBindingMode, AllowVolumeExpansionがポインタ型であることを確認 |
| 1-2 | types.go | `staging/src/k8s.io/api/storage/v1/types.go` | 外部API型定義 |

**読解のコツ**: ポインタ型フィールド（*PersistentVolumeReclaimPolicy, *VolumeBindingMode, *bool）のnil判定パターンに注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内で、storageClassColumnDefinitions（455行目）として6カラムを定義 |

**主要処理フロー**:
1. **455行目**: storageClassColumnDefinitions で Name, Provisioner, ReclaimPolicy, VolumeBindingMode, AllowVolumeExpansion, Age の6カラム定義
2. **464行目**: printStorageClass をハンドラ登録
3. **465行目**: printStorageClassList をハンドラ登録

#### Step 3: プリンター関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printStorageClass関数（2646行目）: デフォルト判定、ポインタnil処理、デフォルト値適用 |
| 3-2 | helpers.go | `pkg/apis/storage/util/helpers.go` | IsDefaultAnnotation関数（32行目）: デフォルトSCアノテーション判定 |

**主要処理フロー**:
- **2651-2653行目**: Name取得とIsDefaultAnnotation判定で"(default)"付与
- **2655行目**: Provisioner取得
- **2656-2658行目**: ReclaimPolicy取得（nilなら"Delete"）
- **2661-2663行目**: VolumeBindingMode取得（nilなら"Immediate"）
- **2666-2668行目**: AllowVolumeExpansion取得（nilならfalse）
- **2671-2672行目**: セルに6項目を追加

### プログラム呼び出し階層図

```
kubectl get sc
    |
    +-- APIサーバーからStorageClass一覧取得
    |
    +-- HumanReadableGenerator.GenerateTable()  [pkg/printers/tablegenerator.go:78]
           |
           +-- printStorageClassList()  [pkg/printers/internalversion/printers.go:2677]
           |       |
           |       +-- printStorageClass()  [pkg/printers/internalversion/printers.go:2646]
           |              |
           |              +-- storageutil.IsDefaultAnnotation()  [pkg/apis/storage/util/helpers.go:32]
           |              +-- translateTimestampSince()  [pkg/printers/internalversion/printers.go:863]
           |
           +-- HumanReadablePrinter.PrintObj()  [staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go:95]
```

### データフロー図

```
[入力]                       [処理]                                        [出力]

etcd StorageClass データ ──> APIサーバー List ──> printStorageClassList() ──> metav1.TableRow[] ──> テーブルテキスト ──> stdout
                                                       |
                                                       +-- IsDefaultAnnotation() → "(default)" 付与
                                                       +-- ReclaimPolicy nil → "Delete"
                                                       +-- VolumeBindingMode nil → "Immediate"
                                                       +-- AllowVolumeExpansion nil → false
                                                       +-- translateTimestampSince()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | StorageClassプリンタ関数（printStorageClass: 2646行目, カラム定義: 455行目） |
| helpers.go | `pkg/apis/storage/util/helpers.go` | ソース | IsDefaultAnnotation関数（32行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルテキスト描画 |
| types.go | `pkg/apis/storage/types.go` | ソース | StorageClass内部型定義 |
| types.go | `staging/src/k8s.io/api/storage/v1/types.go` | ソース | StorageClass外部API型定義 |
