# 帳票設計書 34-VolumeAttributesClass一覧

## 概要

本ドキュメントは、Kubernetes CLIツール（kubectl）における VolumeAttributesClass リソースの一覧表示機能に関する帳票設計書である。`kubectl get volumeattributesclasses` コマンド実行時に VolumeAttributesClassリソースをテーブル形式で出力する仕組みを定義する。

### 本帳票の処理概要

VolumeAttributesClassリソースの一覧情報をテーブル形式で標準出力に表示する機能である。CSIドライバーが提供するボリューム属性のクラスを一覧で確認できるようにする。

**業務上の目的・背景**：VolumeAttributesClassはKubernetesにおけるボリューム属性（IOPS、スループット等）のクラス定義を管理するリソースである。ストレージの品質レベル（QoS）を定義するために使用され、PersistentVolumeClaimと連携してストレージの属性変更（VolumeAttributesClass修正）を可能にする。クラスタ管理者は利用可能なボリューム属性クラスとそのドライバー情報を把握する必要がある。

**帳票の利用シーン**：ストレージのQoSクラス管理時、ボリューム属性変更の計画時、CSIドライバーの設定確認時に利用される。

**主要な出力内容**：
1. VolumeAttributesClassの名前（Name）
2. CSIドライバー名（DriverName）
3. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get volumeattributesclasses` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタの管理者、ストレージ管理者。

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get volumeattributesclasses` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテキスト出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、ヘッダー行に続いて各VolumeAttributesClassリソースが1行ずつ表示される。

```
┌──────────────────────────────────────────────────────┐
│  NAME              DRIVERNAME                 AGE    │
├──────────────────────────────────────────────────────┤
│  silver-iops       csi.example.com            5d     │
│  ...                                                  │
└──────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | VolumeAttributesClassの名前 | ObjectMeta.Name | 文字列（Format: "name"） |
| 2 | DriverName | CSIドライバー名 | DriverName | 文字列 |
| 3 | Age | リソース作成からの経過時間 | ObjectMeta.CreationTimestamp | 人間可読な時間表記 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | 文字列 | 可変 |
| 2 | DriverName | CSIドライバー名 | obj.DriverName | 文字列 | 可変 |
| 3 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | HumanDuration形式 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

テキスト出力のため改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/volumeattributesclasses/{name} | VolumeAttributesClassリソースの実体データ | Name |

### テーブル別参照項目詳細

#### VolumeAttributesClass (storage.k8s.io/v1beta1)

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| driverName | DriverName | - | CSIドライバー名 |
| metadata.creationTimestamp | Age | - | translateTimestampSince関数で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | time.Since(creationTimestamp) | HumanDuration関数で近似表示 | 秒/分/時/日/年に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get volumeattributesclasses 実行] --> B[APIサーバーへVolumeAttributesClass一覧リクエスト]
    B --> C[VolumeAttributesClassリソース一覧取得]
    C --> D[HumanReadableGenerator.GenerateTable呼び出し]
    D --> E[printVolumeAttributesClass/printVolumeAttributesClassList関数でTableRow生成]
    E --> F[HumanReadablePrinter.PrintObjでテーブル描画]
    F --> G[標準出力へ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | VolumeAttributesClassが未定義 | No resources found | VolumeAttributesClassの作成 |
| 権限エラー | RBAC権限不足 | Error from server (Forbidden) | ClusterRoleBindingの設定 |
| APIバージョンエラー | VolumeAttributesClass未サポート環境 | the server doesn't have a resource type | フィーチャーゲートの確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | CLIツールのため制限なし |

## セキュリティ考慮事項

VolumeAttributesClassはクラスタスコープリソースであり、クラスタレベルのRBAC権限が必要。ストレージ構成情報が含まれる。

## 備考

- VolumeAttributesClassはクラスタスコープリソース
- 全フィールドが直接値（ポインタ型でない）のため、nil判定処理は不要
- プリンタ関数はシンプルで、Name, DriverName, Ageの3項目を直接セルに追加するのみ

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/storage/types.go` | VolumeAttributesClass内部型定義。DriverNameフィールドを確認 |
| 1-2 | types.go | `staging/src/k8s.io/api/storage/v1/types.go` | 外部API型定義 |

**読解のコツ**: StorageClassとは異なり、VolumeAttributesClassはボリュームの「属性」を定義するもので、プロビジョニングとは別の概念。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内で、volumeAttributesClassColumnDefinitions（467行目）として3カラムを定義 |

**主要処理フロー**:
1. **467行目**: volumeAttributesClassColumnDefinitions で Name, DriverName, Age の3カラム定義
2. **473行目**: printVolumeAttributesClass をハンドラ登録
3. **474行目**: printVolumeAttributesClassList をハンドラ登録

#### Step 3: プリンター関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printVolumeAttributesClass関数（2689行目）: シンプルに3フィールドをセルに追加 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printVolumeAttributesClassList関数（2699行目）: リストからループ処理 |

**主要処理フロー**:
- **2694行目**: obj.Name, obj.DriverName, translateTimestampSince(obj.CreationTimestamp) を直接セルに追加

### プログラム呼び出し階層図

```
kubectl get volumeattributesclasses
    |
    +-- APIサーバーからVolumeAttributesClass一覧取得
    |
    +-- HumanReadableGenerator.GenerateTable()  [pkg/printers/tablegenerator.go:78]
           |
           +-- printVolumeAttributesClassList()  [pkg/printers/internalversion/printers.go:2699]
           |       |
           |       +-- printVolumeAttributesClass()  [pkg/printers/internalversion/printers.go:2689]
           |              |
           |              +-- translateTimestampSince()  [pkg/printers/internalversion/printers.go:863]
           |
           +-- HumanReadablePrinter.PrintObj()  [staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go:95]
```

### データフロー図

```
[入力]                                [処理]                                              [出力]

etcd VolumeAttributesClass データ ──> APIサーバー List ──> printVolumeAttributesClassList() ──> metav1.TableRow[] ──> テーブルテキスト ──> stdout
                                                               |
                                                               +-- translateTimestampSince()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | VolumeAttributesClassプリンタ関数（printVolumeAttributesClass: 2689行目, カラム定義: 467行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルテキスト描画 |
| types.go | `pkg/apis/storage/types.go` | ソース | VolumeAttributesClass内部型定義 |
| types.go | `staging/src/k8s.io/api/storage/v1/types.go` | ソース | VolumeAttributesClass外部API型定義 |
