# 帳票設計書 35-Status出力

## 概要

本ドキュメントは、Kubernetes CLIツール（kubectl）における Status オブジェクトの出力機能に関する帳票設計書である。APIリクエストの結果としてStatusオブジェクトが返された際に、テーブル形式で出力する仕組みを定義する。

### 本帳票の処理概要

Kubernetes APIサーバーからのレスポンスとして返されるStatusオブジェクト（metav1.Status）をテーブル形式で標準出力に表示する機能である。APIリクエストの成功・失敗の状態、理由、メッセージを構造的に表示する。

**業務上の目的・背景**：KubernetesのAPIサーバーは、リソース操作（削除、更新など）の結果やエラー情報をStatusオブジェクトとして返す。このStatusオブジェクトをテーブル形式で表示することで、操作結果を人間が読みやすい形式で確認できるようにする。特にリソース削除時やエラー発生時の結果表示に使用される。

**帳票の利用シーン**：リソースの削除操作後の結果確認、APIリクエストのエラー詳細確認、バッチ操作の結果一括確認などの場面で利用される。

**主要な出力内容**：
1. ステータス（Status）：Success / Failure
2. 理由（Reason）：エラーの種類を示すコード
3. メッセージ（Message）：人間可読な詳細メッセージ

**帳票の出力タイミング**：APIサーバーがStatusオブジェクトをレスポンスとして返した際に自動的に出力される。

**帳票の利用者**：Kubernetesクラスタの管理者、アプリケーション開発者、CI/CDパイプライン。

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | 各種kubectlコマンド（delete, apply等）のレスポンスとして出力 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテキスト出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、Status, Reason, Message の3カラムを表示する。

```
┌──────────────────────────────────────────────────────────────────┐
│  STATUS     REASON      MESSAGE                                 │
├──────────────────────────────────────────────────────────────────┤
│  Failure    NotFound    pods "my-pod" not found                 │
│  ...                                                             │
└──────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Status | ステータス（Success/Failure） | Status | 文字列 |
| 2 | Reason | ステータスの理由コード | Reason | 文字列 |
| 3 | Message | 人間可読なメッセージ | Message | 文字列 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Status | ステータス | obj.Status | 文字列 | 可変 |
| 2 | Reason | 理由コード | string(obj.Reason) | 文字列（StatusReasonをstringにキャスト） | 可変 |
| 3 | Message | メッセージ | obj.Message | 文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| - | APIレスポンスとして自動的に返される | - |

### ソート順

Statusオブジェクトは通常単一で返されるためソート不要。

### 改ページ条件

テキスト出力のため改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| N/A | StatusオブジェクトはAPIサーバーが生成するレスポンス | - |

### テーブル別参照項目詳細

#### metav1.Status

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| status | Status | - | "Success" または "Failure" |
| reason | Reason | - | StatusReason型（NotFound, Forbidden等）をstringにキャスト |
| message | Message | - | 人間可読なエラーメッセージ |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Reason | string(obj.Reason) | - | StatusReason型からstring型へのキャスト |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectlコマンド実行] --> B[APIサーバーへリクエスト]
    B --> C{レスポンス型判定}
    C -->|Statusオブジェクト| D[HumanReadableGenerator.GenerateTable呼び出し]
    D --> E[printStatus関数でTableRow生成]
    E --> F[HumanReadablePrinter.PrintObjでテーブル描画]
    F --> G[標準出力へ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| - | Status出力自体がエラー情報の表示であるため、出力処理自体のエラーは通常発生しない | - | - |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（通常は単一Statusオブジェクト） |
| 目標出力時間 | 即座 |
| 同時出力数上限 | CLIツールのため制限なし |

## セキュリティ考慮事項

StatusメッセージにはリソースパスやNamespace名が含まれることがあるため、ログ出力時の情報漏洩に注意。

## 備考

- Statusオブジェクトはmetav1.Status型であり、特定のリソースではなくAPIレスポンスの共通型
- printStatus関数はリスト版（printStatusList）を持たない。Statusオブジェクトは常に単一で返される
- Name項目にFormat属性は設定されていない（Statusはリソースではないため）
- Reasonフィールドは metav1.StatusReason 型であり、string()でキャストして表示する

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

StatusオブジェクトはKubernetes APIの共通レスポンス型である。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `staging/src/k8s.io/apimachinery/pkg/apis/meta/v1/types.go` | metav1.Status型の定義。Status, Reason, Message フィールドを確認 |

**読解のコツ**: StatusはAPIリソースではなくメタデータ型（metav1パッケージ）であるため、内部型との変換は発生しない。printStatusの引数は直接 *metav1.Status 型を受け取る。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内で、statusColumnDefinitions（476行目）として3カラムを定義 |

**主要処理フロー**:
1. **476行目**: statusColumnDefinitions で Status, Reason, Message の3カラム定義
2. **482行目**: printStatus をハンドラ登録（リスト版は登録されない）

#### Step 3: プリンター関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printStatus関数（2757行目）: StatusオブジェクトからTableRowを生成 |

**主要処理フロー**:
- **2761行目**: obj.Status, string(obj.Reason), obj.Message の3フィールドをセルに追加

### プログラム呼び出し階層図

```
kubectl {command}
    |
    +-- APIサーバーからStatusレスポンス取得
    |
    +-- HumanReadableGenerator.GenerateTable()  [pkg/printers/tablegenerator.go:78]
           |
           +-- printStatus()  [pkg/printers/internalversion/printers.go:2757]
           |
           +-- HumanReadablePrinter.PrintObj()  [staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go:95]
```

### データフロー図

```
[入力]                    [処理]                        [出力]

APIサーバー Status ──> printStatus() ──> metav1.TableRow ──> テーブルテキスト ──> stdout
                          |
                          +-- Reason を string() でキャスト
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | Statusプリンタ関数（printStatus: 2757行目, カラム定義: 476行目） |
| types.go | `staging/src/k8s.io/apimachinery/pkg/apis/meta/v1/types.go` | ソース | metav1.Status型定義 |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルテキスト描画 |
