# 帳票設計書 36-ControllerRevision一覧

## 概要

本ドキュメントは、Kubernetes CLIツール（kubectl）における ControllerRevision リソースの一覧表示機能に関する帳票設計書である。`kubectl get controllerrevisions` コマンド実行時に ControllerRevisionリソースをテーブル形式で出力する仕組みを定義する。

### 本帳票の処理概要

ControllerRevisionリソースの一覧情報をテーブル形式で標準出力に表示する機能である。StatefulSetやDaemonSetの更新履歴（リビジョン）を一覧で確認できるようにする。

**業務上の目的・背景**：ControllerRevisionはStatefulSetやDaemonSetのリビジョン管理に使用されるリソースである。ワークロードのローリングアップデートやロールバック時に、どのリビジョンが存在し、どのコントローラーに紐づいているかを把握する必要がある。リビジョン番号とコントローラーの関係を一覧表示することで、運用者がデプロイ履歴を追跡できるようにする。

**帳票の利用シーン**：StatefulSetやDaemonSetのアップデート履歴確認時、ロールバック対象リビジョンの特定時、古いリビジョンの整理・削除時に利用される。

**主要な出力内容**：
1. ControllerRevisionの名前（Name）
2. 管理コントローラー名（Controller）：GroupKind/Name形式
3. リビジョン番号（Revision）
4. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get controllerrevisions` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタの管理者、アプリケーション運用者、SRE。

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get controllerrevisions` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテキスト出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、ヘッダー行に続いて各ControllerRevisionリソースが1行ずつ表示される。

```
┌──────────────────────────────────────────────────────────────────────────────┐
│  NAME                              CONTROLLER                REVISION   AGE │
├──────────────────────────────────────────────────────────────────────────────┤
│  my-statefulset-7bc4f98d67         statefulset/my-statefulset 3          5d  │
│  ...                                                                         │
└──────────────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | ControllerRevisionの名前 | ObjectMeta.Name | 文字列（Format: "name"） |
| 2 | Controller | 管理コントローラー名 | OwnerReferences[controller=true] | "kind/name" 形式（小文字） |
| 3 | Revision | リビジョン番号 | Revision | 整数 |
| 4 | Age | リソース作成からの経過時間 | ObjectMeta.CreationTimestamp | 人間可読な時間表記 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | 文字列 | 可変 |
| 2 | Controller | コントローラー参照 | metav1.GetControllerOf(obj) | "groupkind/name"（小文字） | 可変 |
| 3 | Revision | リビジョン番号 | obj.Revision | 整数 | 可変 |
| 4 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | HumanDuration形式 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 指定されたNamespace内のControllerRevisionリソースを取得 | No（デフォルト: 現在のNamespace） |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

テキスト出力のため改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/controllerrevisions/{namespace}/{name} | ControllerRevisionリソースの実体データ | Namespace + Name |

### テーブル別参照項目詳細

#### ControllerRevision (apps/v1)

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| metadata.ownerReferences[controller=true] | Controller | - | GetControllerOfでコントローラーOwnerReferenceを取得。APIVersionからGroupKindを算出しformatResourceNameで整形 |
| revision | Revision | - | int64型 |
| metadata.creationTimestamp | Age | - | translateTimestampSince関数で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Controller | schema.ParseGroupVersion(controllerRef.APIVersion) -> gv.WithKind(controllerRef.Kind) -> formatResourceName(gvk.GroupKind(), controllerRef.Name, true) | - | コントローラー未設定の場合は"\<none\>" |
| formatResourceName | strings.ToLower(kind.String()) + "/" + name | - | kindが空の場合はnameのみ |
| Age | time.Since(creationTimestamp) | HumanDuration関数で近似表示 | 秒/分/時/日/年に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get controllerrevisions 実行] --> B[APIサーバーへControllerRevision一覧リクエスト]
    B --> C[ControllerRevisionリソース一覧取得]
    C --> D[HumanReadableGenerator.GenerateTable呼び出し]
    D --> E[printControllerRevision/printControllerRevisionList関数でTableRow生成]
    E --> F[GetControllerOfでコントローラー参照取得]
    F --> G[ParseGroupVersion + WithKind でGVK構築]
    G --> H[formatResourceNameで表示名整形]
    H --> I[HumanReadablePrinter.PrintObjでテーブル描画]
    I --> J[標準出力へ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 指定Namespaceにリソースが存在しない | No resources found in {namespace} namespace. | 正常系 |
| APIVersion解析エラー | OwnerReferenceのAPIVersionが不正 | 行生成時にエラーを返す | メタデータの修復 |
| 権限エラー | RBAC権限不足 | Error from server (Forbidden) | RoleBindingの設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百件（revisionHistoryLimitによる制御） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | CLIツールのため制限なし |

## セキュリティ考慮事項

ControllerRevisionにはワークロードのPodテンプレート情報（Data フィールド）が含まれるが、テーブル表示では表示されない。名前とコントローラー参照のみが表示される。

## 備考

- ControllerRevisionは apps/v1 APIグループに属する
- Controllerカラムは metav1.GetControllerOf 関数で OwnerReference から取得する
- コントローラー参照がない場合は "\<none\>" と表示される
- schema.ParseGroupVersion でAPIVersionを解析し、GroupKindと名前をformatResourceNameで "kind/name" 形式に整形する
- ParseGroupVersion が失敗した場合はエラーが返される（他の多くのプリンタとは異なりエラーが発生し得る）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/apps/types.go` | ControllerRevision内部型定義。Revisionフィールド（int64）を確認 |
| 1-2 | types.go | `staging/src/k8s.io/api/apps/v1/types.go` | 外部API型定義 |

**読解のコツ**: ControllerRevisionのDataフィールドにはPodテンプレートのスナップショットが含まれるが、テーブル表示では使用されない。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内で、controllerRevisionColumnDefinition（484行目）として4カラムを定義 |

**主要処理フロー**:
1. **484行目**: controllerRevisionColumnDefinition で Name, Controller, Revision, Age の4カラム定義
2. **490行目**: printControllerRevision をハンドラ登録
3. **491行目**: printControllerRevisionList をハンドラ登録

#### Step 3: プリンター関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printControllerRevision関数（2807行目）: GetControllerOf + ParseGroupVersion + formatResourceName |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | formatResourceName関数（2843行目）: GroupKindと名前を整形 |
| 3-3 | printers.go | `pkg/printers/internalversion/printers.go` | printControllerRevisionList関数（2829行目）: リストからループ処理 |

**主要処理フロー**:
- **2812行目**: metav1.GetControllerOf(obj) でコントローラーOwnerReferenceを取得
- **2813行目**: controllerName のデフォルト値 "\<none\>"
- **2814-2821行目**: controllerRef != nil の場合、APIVersionをパースしGVKを構築、formatResourceNameで整形
- **2823行目**: Revision取得
- **2824行目**: Age取得
- **2825行目**: 4項目をセルに追加

### プログラム呼び出し階層図

```
kubectl get controllerrevisions
    |
    +-- APIサーバーからControllerRevision一覧取得
    |
    +-- HumanReadableGenerator.GenerateTable()  [pkg/printers/tablegenerator.go:78]
           |
           +-- printControllerRevisionList()  [pkg/printers/internalversion/printers.go:2829]
           |       |
           |       +-- printControllerRevision()  [pkg/printers/internalversion/printers.go:2807]
           |              |
           |              +-- metav1.GetControllerOf()
           |              +-- schema.ParseGroupVersion()
           |              +-- formatResourceName()  [pkg/printers/internalversion/printers.go:2843]
           |              +-- translateTimestampSince()  [pkg/printers/internalversion/printers.go:863]
           |
           +-- HumanReadablePrinter.PrintObj()  [staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go:95]
```

### データフロー図

```
[入力]                              [処理]                                        [出力]

etcd ControllerRevision データ ──> APIサーバー List ──> printControllerRevisionList() ──> metav1.TableRow[] ──> テーブルテキスト ──> stdout
                                                            |
                                                            +-- GetControllerOf() → OwnerReference
                                                            +-- ParseGroupVersion() → GroupVersion
                                                            +-- WithKind() → GVK
                                                            +-- formatResourceName() → "kind/name"
                                                            +-- translateTimestampSince()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | ControllerRevisionプリンタ関数（printControllerRevision: 2807行目, formatResourceName: 2843行目, カラム定義: 484行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルテキスト描画 |
| types.go | `pkg/apis/apps/types.go` | ソース | ControllerRevision内部型定義 |
| types.go | `staging/src/k8s.io/api/apps/v1/types.go` | ソース | ControllerRevision外部API型定義 |
