# 帳票設計書 37-ResourceQuota一覧

## 概要

本ドキュメントは、Kubernetes CLIツール（kubectl）における ResourceQuota リソースの一覧表示機能に関する帳票設計書である。`kubectl get quota` コマンド実行時に ResourceQuotaリソースをテーブル形式で出力する仕組みを定義する。

### 本帳票の処理概要

ResourceQuotaリソースの一覧情報をテーブル形式で標準出力に表示する機能である。Namespace内のリソース使用量と制限値を一覧で確認できるようにする。

**業務上の目的・背景**：ResourceQuotaはKubernetesにおけるNamespace単位のリソース使用制限を管理するリソースである。マルチテナント環境やコスト管理が必要な環境で、各Namespaceに割り当てられたCPU/メモリ等のリソースの使用状況と上限を把握するために不可欠である。クォータの超過を事前に検知し、リソース不足によるデプロイ失敗を防止する。

**帳票の利用シーン**：Namespace内のリソース使用状況の監視時、新規デプロイ前のリソース余裕確認時、クォータ設計の見直し時、マルチテナント環境でのリソース配分確認時に利用される。

**主要な出力内容**：
1. ResourceQuotaの名前（Name）
2. Request系リソースの使用状況（Request）：used/hard形式
3. Limit系リソースの使用状況（Limit）：used/hard形式
4. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get quota` または `kubectl get resourcequotas` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタの管理者、Namespace管理者、プラットフォームチーム。

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get quota` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテキスト出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、ヘッダー行に続いて各ResourceQuotaリソースが1行ずつ表示される。

```
┌───────────────────────────────────────────────────────────────────────────────────────────┐
│  NAME              REQUEST                                  LIMIT                    AGE  │
├───────────────────────────────────────────────────────────────────────────────────────────┤
│  compute-quota     cpu: 1/2, memory: 1Gi/4Gi               limits.cpu: 0/4          30d  │
│  ...                                                                                      │
└───────────────────────────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | ResourceQuotaの名前 | ObjectMeta.Name | 文字列（Format: "name"） |
| 2 | Request | Request系リソースの使用状況 | Status.Used / Status.Hard | "resource: used/hard, ..." 形式 |
| 3 | Limit | Limit系リソースの使用状況 | Status.Used / Status.Hard | "resource: used/hard, ..." 形式 |
| 4 | Age | リソース作成からの経過時間 | ObjectMeta.CreationTimestamp | 人間可読な時間表記 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | resourceQuota.Name | 文字列 | 可変 |
| 2 | Request | Request系リソース | Status.Used/Hard（"limits."で始まらないリソース） | "resource: used/hard" のカンマ区切り | 可変 |
| 3 | Limit | Limit系リソース | Status.Used/Hard（"limits."で始まるリソース） | "resource: used/hard" のカンマ区切り | 可変 |
| 4 | Age | 経過時間 | translateTimestampSince(resourceQuota.CreationTimestamp) | HumanDuration形式 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 指定されたNamespace内のResourceQuotaリソースを取得 | No（デフォルト: 現在のNamespace） |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |
| - | リソース名（Request/Limit内） | SortableResourceNames で昇順ソート |

### 改ページ条件

テキスト出力のため改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/resourcequotas/{namespace}/{name} | ResourceQuotaリソースの実体データ | Namespace + Name |

### テーブル別参照項目詳細

#### ResourceQuota (v1)

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| status.hard | Request/Limit（Hard値） | - | リソース名をキーとしたmap |
| status.used | Request/Limit（Used値） | - | リソース名をキーとしたmap |
| metadata.creationTimestamp | Age | - | translateTimestampSince関数で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Request | Status.Hard のキーを SortableResourceNames でソートし、"limits."で始まらないリソースを "resource: used/hard" 形式でカンマ区切りに結合 | - | 末尾の ", " は TrimSuffix で除去 |
| Limit | Status.Hard のキーを SortableResourceNames でソートし、"limits."で始まるリソースを "resource: used/hard" 形式でカンマ区切りに結合 | - | 末尾の ", " は TrimSuffix で除去 |
| Age | time.Since(creationTimestamp) | HumanDuration関数で近似表示 | 秒/分/時/日/年に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get quota 実行] --> B[APIサーバーへResourceQuota一覧リクエスト]
    B --> C[ResourceQuotaリソース一覧取得]
    C --> D[HumanReadableGenerator.GenerateTable呼び出し]
    D --> E[printResourceQuota/printResourceQuotaList関数でTableRow生成]
    E --> F[Status.Hardからリソース名一覧取得]
    F --> G[SortableResourceNamesでソート]
    G --> H{リソース名判定}
    H -->|limits.で始まる| I[limitColumnに追記]
    H -->|その他| J[requestColumnに追記]
    I --> K[末尾", "のTrimSuffix]
    J --> K
    K --> L[HumanReadablePrinter.PrintObjでテーブル描画]
    L --> M[標準出力へ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | 指定NamespaceにResourceQuotaが未定義 | No resources found in {namespace} namespace. | 正常系 |
| 権限エラー | RBAC権限不足 | Error from server (Forbidden) | RoleBindingの設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件（Namespace単位で通常少数） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | CLIツールのため制限なし |

## セキュリティ考慮事項

ResourceQuotaにはNamespaceのリソース割り当て情報が含まれるため、組織のリソース配分情報の漏洩に注意。

## 備考

- ResourceQuotaは v1 コアAPIグループに属する
- Request/Limit カラムの分類は、リソース名の先頭が "limits." で始まるかどうかで判定される
- リソース名は SortableResourceNames によってアルファベット順にソートされる
- 使用量（Used）と制限値（Hard）が "used/hard" 形式で表示され、複数リソースはカンマ区切り
- Status.Hard（制限値）が基準となり、Status.Used（使用量）と対にして表示される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/core/types.go` | ResourceQuota内部型定義。ResourceQuotaStatus の Hard/Used フィールド（ResourceList = map[ResourceName]resource.Quantity）を確認 |

**読解のコツ**: ResourceListはmap型であり、キーがResourceName（string型ベース）、値がresource.Quantity型。Request/Limitの分類はキー名の接頭辞 "limits." で判定される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内で、resourceQuotaColumnDefinitions（493行目）として4カラムを定義 |

**主要処理フロー**:
1. **493行目**: resourceQuotaColumnDefinitions で Name, Request, Limit, Age の4カラム定義
2. **499行目**: printResourceQuota をハンドラ登録
3. **500行目**: printResourceQuotaList をハンドラ登録

#### Step 3: プリンター関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printResourceQuota関数（2851行目）: Request/Limit分類ロジック |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | SortableResourceNames型（3362行目）: リソース名のソート |

**主要処理フロー**:
- **2856-2859行目**: Status.Hardからリソース名一覧を取得
- **2860行目**: SortableResourceNamesでソート
- **2862-2863行目**: requestColumn, limitColumn の2つのバッファを用意
- **2864-2876行目**: 各リソースについて、"limits."で始まる場合はlimitColumn、それ以外はrequestColumnに追記
- **2875行目**: "resource: used/hard, " 形式でフォーマット
- **2879行目**: TrimSuffix(", ") で末尾の区切りを除去し、4項目をセルに追加

### プログラム呼び出し階層図

```
kubectl get quota
    |
    +-- APIサーバーからResourceQuota一覧取得
    |
    +-- HumanReadableGenerator.GenerateTable()  [pkg/printers/tablegenerator.go:78]
           |
           +-- printResourceQuotaList()  [pkg/printers/internalversion/printers.go:2883]
           |       |
           |       +-- printResourceQuota()  [pkg/printers/internalversion/printers.go:2851]
           |              |
           |              +-- sort.Sort(SortableResourceNames)  [pkg/printers/internalversion/printers.go:3362]
           |              +-- strings.Split() → "limits." 判定
           |              +-- fmt.Fprintf() → "resource: used/hard, " 形式
           |              +-- strings.TrimSuffix()
           |              +-- translateTimestampSince()  [pkg/printers/internalversion/printers.go:863]
           |
           +-- HumanReadablePrinter.PrintObj()  [staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go:95]
```

### データフロー図

```
[入力]                          [処理]                                         [出力]

etcd ResourceQuota データ ──> APIサーバー List ──> printResourceQuotaList()
                                                       |
                                                       +-- Status.Hard keys → SortableResourceNames sort
                                                       +-- "limits." prefix → limitColumn
                                                       +-- other → requestColumn
                                                       +-- fmt.Fprintf("resource: used/hard, ")
                                                       +-- TrimSuffix(", ")
                                                       +-- translateTimestampSince()
                                                       |
                                                       +──> metav1.TableRow[] ──> テーブルテキスト ──> stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | ResourceQuotaプリンタ関数（printResourceQuota: 2851行目, SortableResourceNames: 3362行目, カラム定義: 493行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルテキスト描画 |
| types.go | `pkg/apis/core/types.go` | ソース | ResourceQuota内部型定義 |
