# 帳票設計書 38-PriorityClass一覧

## 概要

本ドキュメントは、Kubernetes CLIツール（kubectl）における PriorityClass リソースの一覧表示機能に関する帳票設計書である。`kubectl get priorityclasses` コマンド実行時に PriorityClassリソースをテーブル形式で出力する仕組みを定義する。

### 本帳票の処理概要

PriorityClassリソースの一覧情報をテーブル形式で標準出力に表示する機能である。Podのスケジューリング優先度クラスの名前、優先度値、グローバルデフォルト設定を一覧で確認できるようにする。

**業務上の目的・背景**：PriorityClassはKubernetesにおけるPodのスケジューリング優先度を定義するリソースである。リソース競合時にどのPodが優先されるか、またプリエンプション（低優先度Podの退避）の挙動を制御する。クラスタ管理者は利用可能な優先度クラスとその値、デフォルト設定を把握し、ワークロードの優先順位を適切に管理する必要がある。

**帳票の利用シーン**：ワークロードの優先度設計時、Podスケジューリング問題の調査時、プリエンプションポリシーの確認時に利用される。

**主要な出力内容**：
1. PriorityClassの名前（Name）
2. 優先度値（Value）
3. グローバルデフォルト設定（Global-Default）
4. リソースの経過時間（Age）
5. プリエンプションポリシー（PreemptionPolicy）（Wideモードのみ）

**帳票の出力タイミング**：ユーザーが `kubectl get priorityclasses` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタの管理者、アプリケーション設計者、SRE。

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get priorityclasses` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテキスト出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、ヘッダー行に続いて各PriorityClassリソースが1行ずつ表示される。Wideモード時はPreemptionPolicyカラムが追加される。

```
通常モード:
┌───────────────────────────────────────────────────────────────┐
│  NAME                     VALUE        GLOBAL-DEFAULT   AGE  │
├───────────────────────────────────────────────────────────────┤
│  system-cluster-critical   2000000000  false            30d  │
│  ...                                                          │
└───────────────────────────────────────────────────────────────┘

Wideモード:
┌──────────────────────────────────────────────────────────────────────────────────┐
│  NAME                     VALUE        GLOBAL-DEFAULT   AGE   PREEMPTIONPOLICY  │
├──────────────────────────────────────────────────────────────────────────────────┤
│  system-cluster-critical   2000000000  false            30d   PreemptLowerPriority │
└──────────────────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | PriorityClassの名前 | ObjectMeta.Name | 文字列（Format: "name"） |
| 2 | Value | 優先度値 | Value | 整数（int64にキャスト） |
| 3 | Global-Default | グローバルデフォルト設定 | GlobalDefault | boolean |
| 4 | Age | リソース作成からの経過時間 | ObjectMeta.CreationTimestamp | 人間可読な時間表記 |
| 5 | PreemptionPolicy | プリエンプションポリシー | PreemptionPolicy | 文字列（Wideモードのみ表示） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | 文字列 | 可変 |
| 2 | Value | 優先度値 | int64(obj.Value) | 整数 | 可変 |
| 3 | Global-Default | デフォルト設定 | obj.GlobalDefault | boolean | 可変 |
| 4 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | HumanDuration形式 | 可変 |
| 5 | PreemptionPolicy | プリエンプションポリシー | string(*obj.PreemptionPolicy)（Wideモードのみ） | 文字列（nilの場合は空文字） | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

テキスト出力のため改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/priorityclasses/{name} | PriorityClassリソースの実体データ | Name |

### テーブル別参照項目詳細

#### PriorityClass (scheduling.k8s.io/v1)

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| value | Value | - | int32型をint64にキャストして表示 |
| globalDefault | Global-Default | - | boolean |
| metadata.creationTimestamp | Age | - | translateTimestampSince関数で変換 |
| preemptionPolicy | PreemptionPolicy | options.Wide == true | ポインタ型。nilの場合は空文字。Wideモードのみ |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Value | int64(obj.Value) | - | int32をint64にキャスト |
| PreemptionPolicy | obj.PreemptionPolicy != nil ? string(*obj.PreemptionPolicy) : "" | - | Wideモードのみ。ポインタnilチェック |
| Age | time.Since(creationTimestamp) | HumanDuration関数で近似表示 | 秒/分/時/日/年に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get priorityclasses 実行] --> B[APIサーバーへPriorityClass一覧リクエスト]
    B --> C[PriorityClassリソース一覧取得]
    C --> D[HumanReadableGenerator.GenerateTable呼び出し]
    D --> E[printPriorityClass/printPriorityClassList関数でTableRow生成]
    E --> F[Name, Value, GlobalDefault, Age をセルに追加]
    F --> G{Wideモード?}
    G -->|Yes| H[PreemptionPolicy をセルに追加]
    G -->|No| I[そのまま]
    H --> J[HumanReadablePrinter.PrintObjでテーブル描画]
    I --> J
    J --> K[標準出力へ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | PriorityClassが未定義 | No resources found | システムデフォルトのPriorityClassは通常存在する |
| 権限エラー | RBAC権限不足 | Error from server (Forbidden) | ClusterRoleBindingの設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜十数件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | CLIツールのため制限なし |

## セキュリティ考慮事項

PriorityClassはクラスタスコープのリソースであり、クラスタレベルのRBAC権限が必要。優先度値の設計情報が含まれるため、ワークロード優先度に関する情報漏洩に注意。

## 備考

- PriorityClassは scheduling.k8s.io/v1 APIグループに属するクラスタスコープリソース
- Value フィールドは int32 型だが、テーブル行のセルには int64 にキャストして追加される
- PreemptionPolicy はポインタ型（*PreemptionPolicy）であり、Wideモードの場合のみ表示される
- Wideモードでない場合、PreemptionPolicy カラムは表示されない（options.Wide チェック）
- システム組み込みの PriorityClass（system-cluster-critical, system-node-critical）は通常存在する

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/scheduling/types.go` | PriorityClass内部型定義。Value（int32）、GlobalDefault（bool）、PreemptionPolicy（*PreemptionPolicy）を確認 |
| 1-2 | types.go | `staging/src/k8s.io/api/scheduling/v1/types.go` | 外部API型定義。SwaggerDocからカラム説明文を取得 |

**読解のコツ**: PreemptionPolicy はポインタ型で、Wideモード時のみ参照される条件分岐に注目。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内で、priorityClassColumnDefinitions（502行目）として5カラムを定義 |

**主要処理フロー**:
1. **502行目**: priorityClassColumnDefinitions で Name, Value, Global-Default, Age, PreemptionPolicy の5カラム定義
2. **509行目**: printPriorityClass をハンドラ登録
3. **510行目**: printPriorityClassList をハンドラ登録

#### Step 3: プリンター関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printPriorityClass関数（2895行目）: Wideモード分岐ロジック |

**主要処理フロー**:
- **2900-2903行目**: Name, int64(Value), GlobalDefault, Age をセルに追加
- **2904行目**: options.Wide チェック
- **2905-2909行目**: Wideモードの場合、PreemptionPolicy をnil判定してセルに追加

### プログラム呼び出し階層図

```
kubectl get priorityclasses [-o wide]
    |
    +-- APIサーバーからPriorityClass一覧取得
    |
    +-- HumanReadableGenerator.GenerateTable()  [pkg/printers/tablegenerator.go:78]
           |
           +-- printPriorityClassList()  [pkg/printers/internalversion/printers.go:2914]
           |       |
           |       +-- printPriorityClass()  [pkg/printers/internalversion/printers.go:2895]
           |              |
           |              +-- translateTimestampSince()  [pkg/printers/internalversion/printers.go:863]
           |              +-- [Wide] PreemptionPolicy nil判定
           |
           +-- HumanReadablePrinter.PrintObj()  [staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go:95]
```

### データフロー図

```
[入力]                         [処理]                                       [出力]

etcd PriorityClass データ ──> APIサーバー List ──> printPriorityClassList()
                                                       |
                                                       +-- Name, int64(Value), GlobalDefault, Age
                                                       +-- [Wide] PreemptionPolicy (*ptr → string)
                                                       |
                                                       +──> metav1.TableRow[] ──> テーブルテキスト ──> stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | PriorityClassプリンタ関数（printPriorityClass: 2895行目, カラム定義: 502行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルテキスト描画 |
| types.go | `pkg/apis/scheduling/types.go` | ソース | PriorityClass内部型定義 |
| types.go | `staging/src/k8s.io/api/scheduling/v1/types.go` | ソース | PriorityClass外部API型定義 |
