# 帳票設計書 39-RuntimeClass一覧

## 概要

本ドキュメントは、Kubernetes CLIツール（kubectl）における RuntimeClass リソースの一覧表示機能に関する帳票設計書である。`kubectl get runtimeclasses` コマンド実行時に RuntimeClassリソースをテーブル形式で出力する仕組みを定義する。

### 本帳票の処理概要

RuntimeClassリソースの一覧情報をテーブル形式で標準出力に表示する機能である。クラスタで利用可能なコンテナランタイム設定を一覧で確認できるようにする。

**業務上の目的・背景**：RuntimeClassはKubernetesにおけるコンテナランタイムの設定を抽象化するリソースである。異なるコンテナランタイム（runc、gVisor、Kata Containersなど）を選択可能にし、ワークロードのセキュリティ要件やパフォーマンス特性に応じた適切なランタイムを指定できるようにする。クラスタ管理者は利用可能なRuntimeClassとその対応ハンドラーを把握する必要がある。

**帳票の利用シーン**：コンテナランタイムの構成確認時、新規ワークロードのランタイム選択時、セキュリティ要件に基づくランタイム設定の監査時に利用される。

**主要な出力内容**：
1. RuntimeClassの名前（Name）
2. ハンドラー名（Handler）
3. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get runtimeclasses` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタの管理者、セキュリティチーム、アプリケーション設計者。

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get runtimeclasses` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテキスト出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、ヘッダー行に続いて各RuntimeClassリソースが1行ずつ表示される。

```
┌──────────────────────────────────────────────┐
│  NAME          HANDLER         AGE           │
├──────────────────────────────────────────────┤
│  gvisor        runsc           30d           │
│  kata          kata-runtime    15d           │
│  ...                                         │
└──────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | RuntimeClassの名前 | ObjectMeta.Name | 文字列（Format: "name"） |
| 2 | Handler | コンテナランタイムハンドラー名 | Handler | 文字列 |
| 3 | Age | リソース作成からの経過時間 | ObjectMeta.CreationTimestamp | 人間可読な時間表記 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | 文字列 | 可変 |
| 2 | Handler | ハンドラー名 | obj.Handler | 文字列 | 可変 |
| 3 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | HumanDuration形式 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

テキスト出力のため改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/runtimeclasses/{name} | RuntimeClassリソースの実体データ | Name |

### テーブル別参照項目詳細

#### RuntimeClass (node.k8s.io/v1)

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| handler | Handler | - | コンテナランタイムのハンドラー名 |
| metadata.creationTimestamp | Age | - | translateTimestampSince関数で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | time.Since(creationTimestamp) | HumanDuration関数で近似表示 | 秒/分/時/日/年に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get runtimeclasses 実行] --> B[APIサーバーへRuntimeClass一覧リクエスト]
    B --> C[RuntimeClassリソース一覧取得]
    C --> D[HumanReadableGenerator.GenerateTable呼び出し]
    D --> E[printRuntimeClass/printRuntimeClassList関数でTableRow生成]
    E --> F[HumanReadablePrinter.PrintObjでテーブル描画]
    F --> G[標準出力へ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | RuntimeClassが未定義 | No resources found | RuntimeClassの作成 |
| 権限エラー | RBAC権限不足 | Error from server (Forbidden) | ClusterRoleBindingの設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | CLIツールのため制限なし |

## セキュリティ考慮事項

RuntimeClassはクラスタスコープリソースであり、クラスタレベルのRBAC権限が必要。ランタイム構成情報が含まれるため、クラスタのセキュリティアーキテクチャに関する情報漏洩に注意。

## 備考

- RuntimeClassは node.k8s.io/v1 APIグループに属するクラスタスコープリソース
- 内部型は `nodeapi.RuntimeClass` として参照される（パッケージエイリアス nodeapi = "k8s.io/kubernetes/pkg/apis/node"）
- 全フィールドが直接値（ポインタ型でない）のため、nil判定は不要
- プリンタ関数はシンプルで、Name, Handler, Ageの3項目を直接セルに追加するのみ

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/node/types.go` | RuntimeClass内部型定義。Handlerフィールドを確認 |
| 1-2 | types.go | `staging/src/k8s.io/api/node/v1/types.go` | 外部API型定義 |

**読解のコツ**: RuntimeClassにはScheduling（NodeSelectorとTolerations）やOverhead（Podリソースオーバーヘッド）のオプショナルフィールドがあるが、テーブル表示には使用されない。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内で、runtimeClassColumnDefinitions（512行目）として3カラムを定義 |

**主要処理フロー**:
1. **512行目**: runtimeClassColumnDefinitions で Name, Handler, Age の3カラム定義
2. **517行目**: printRuntimeClass をハンドラ登録
3. **518行目**: printRuntimeClassList をハンドラ登録

#### Step 3: プリンター関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printRuntimeClass関数（2926行目）: シンプルに3フィールドをセルに追加 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printRuntimeClassList関数（2938行目）: リストからループ処理 |

**主要処理フロー**:
- **2931行目**: Name取得
- **2932行目**: Handler取得
- **2933行目**: Name, Handler, translateTimestampSince(CreationTimestamp) をセルに追加

### プログラム呼び出し階層図

```
kubectl get runtimeclasses
    |
    +-- APIサーバーからRuntimeClass一覧取得
    |
    +-- HumanReadableGenerator.GenerateTable()  [pkg/printers/tablegenerator.go:78]
           |
           +-- printRuntimeClassList()  [pkg/printers/internalversion/printers.go:2938]
           |       |
           |       +-- printRuntimeClass()  [pkg/printers/internalversion/printers.go:2926]
           |              |
           |              +-- translateTimestampSince()  [pkg/printers/internalversion/printers.go:863]
           |
           +-- HumanReadablePrinter.PrintObj()  [staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go:95]
```

### データフロー図

```
[入力]                        [処理]                                     [出力]

etcd RuntimeClass データ ──> APIサーバー List ──> printRuntimeClassList() ──> metav1.TableRow[] ──> テーブルテキスト ──> stdout
                                                       |
                                                       +-- translateTimestampSince()
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | RuntimeClassプリンタ関数（printRuntimeClass: 2926行目, カラム定義: 512行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルテキスト描画 |
| types.go | `pkg/apis/node/types.go` | ソース | RuntimeClass内部型定義 |
| types.go | `staging/src/k8s.io/api/node/v1/types.go` | ソース | RuntimeClass外部API型定義 |
