# 帳票設計書 4-ReplicationController一覧

## 概要

本ドキュメントは、Kubernetes の ReplicationController リソース一覧をテーブル形式で標準出力に出力する帳票の設計を定義する。`kubectl get rc` コマンド実行時に使用される。

### 本帳票の処理概要

本帳票は、Kubernetes クラスタ上の ReplicationController リソースの一覧情報を、テーブル形式で標準出力に表示する処理を行う。

**業務上の目的・背景**：ReplicationController は指定された数の Pod レプリカが常に稼働していることを保証するリソースである。現在は ReplicaSet / Deployment の使用が推奨されているが、レガシーなワークロードでは依然として使用されている。運用者がレプリカ数の管理状態（Desired / Current / Ready）を確認し、スケーリングの正常性を把握するために必要な帳票である。

**帳票の利用シーン**：レプリカ数の確認、スケーリング操作後の状態確認、レガシーワークロードの管理。

**主要な出力内容**：
1. ReplicationController 名（Name）
2. 希望レプリカ数（Desired）
3. 現在のレプリカ数（Current）
4. Ready 状態のレプリカ数（Ready）
5. 作成からの経過時間（Age）
6. Wide 出力時: コンテナ名、イメージ名、セレクタ

**帳票の出力タイミング**：ユーザが `kubectl get rc` または `kubectl get replicationcontrollers` コマンドを実行した際に出力される。

**帳票の利用者**：Kubernetes クラスタ管理者、アプリケーション開発者。

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | ターミナル（CLI） | N/A | `kubectl get rc [flags]` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 標準出力（テキスト / テーブル形式） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字（tabwriter） |
| ヘッダー表示 | デフォルト有効 |
| Wide 出力 | Containers, Images, Selector が追加（Priority=1） |

## 帳票レイアウト

### レイアウト概要

```
┌───────────────────────────────────────────────────────────┐
│  NAME    DESIRED   CURRENT   READY   AGE                 │
├───────────────────────────────────────────────────────────┤
│  rc-1    3         3         3       5d                   │
│  rc-2    2         2         1       1d                   │
└───────────────────────────────────────────────────────────┘
```

Wide 出力時:
```
NAME  DESIRED  CURRENT  READY  AGE  CONTAINERS  IMAGES       SELECTOR
rc-1  3        3        3      5d   nginx       nginx:1.21   app=web
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | RC の名前 | `obj.ObjectMeta.Name` | 文字列（name フォーマット） |
| 2 | Desired | 希望レプリカ数 | `obj.Spec.Replicas` | 整数（int64）、nil 時はデフォルト 0 |
| 3 | Current | 現在のレプリカ数 | `obj.Status.Replicas` | 整数（int64） |
| 4 | Ready | Ready レプリカ数 | `obj.Status.ReadyReplicas` | 整数（int64） |
| 5 | Age | 経過時間 | `obj.ObjectMeta.CreationTimestamp` | `translateTimestampSince` |

### 明細部（Wide 出力時の追加カラム）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 6 | Containers | コンテナ名一覧 | `obj.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 7 | Images | イメージ名一覧 | `obj.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 8 | Selector | Pod セレクタ | `obj.Spec.Selector` | key=value カンマ区切り | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象 Namespace | No |
| All Namespaces | 全 Namespace | No |
| Label Selector | ラベルフィルタ | No |
| Field Selector | フィールドフィルタ | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | RC 名（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: `/registry/controllers/{namespace}/{name}` | RC オブジェクトの永続化ストア | N/A |

### テーブル別参照項目詳細

#### ReplicationController リソース（API: `v1/replicationcontrollers`）

| 参照項目（フィールド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | N/A | RC の名前 |
| `metadata.creationTimestamp` | Age | N/A | 経過時間に変換 |
| `spec.replicas` | Desired | N/A | ptr.Deref で nil 時に 0 を使用 |
| `status.replicas` | Current | N/A | 現在のレプリカ数 |
| `status.readyReplicas` | Ready | N/A | Ready レプリカ数 |
| `spec.template.spec.containers` | Containers, Images (wide) | N/A | layoutContainerCells で変換 |
| `spec.selector` | Selector (wide) | N/A | labels.FormatLabels で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Desired | `int64(ptr.Deref(obj.Spec.Replicas, 0))` | N/A | nil の場合デフォルト 0 |
| Current | `int64(obj.Status.Replicas)` | N/A | |
| Ready | `int64(obj.Status.ReadyReplicas)` | N/A | |
| Containers/Images | `layoutContainerCells(containers)` | N/A | Template が nil の場合は空配列 |
| Selector | `labels.FormatLabels(obj.Spec.Selector)` | N/A | map[string]string 形式 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get rc 実行] --> B[API サーバへリクエスト]
    B --> C[RC リスト取得]
    C --> D[printReplicationControllerList]
    D --> E[printReplicationController で各行生成]
    E --> F[HumanReadablePrinter でテーブル出力]
    F --> G[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | RC が存在しない | `No resources found in {namespace} namespace.` | 条件見直し |
| API エラー | 接続失敗 | API エラーメッセージ | kubeconfig 確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数百件 |
| 目標出力時間 | 即時 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

- RC 一覧取得には `replicationcontrollers` リソースの `list` / `get` 権限が必要
- 機密情報は含まれない（イメージ名のみ）

## 備考

- ReplicationController はレガシーリソースであり、ReplicaSet / Deployment の使用が推奨される
- Spec.Template が nil の場合、Wide 出力のコンテナ情報は空となる
- Spec.Replicas が nil の場合、ptr.Deref により 0 がデフォルト値として使用される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printers.go | `pkg/printers/internalversion/printers.go` | replicationControllerColumnDefinitions（行 129-138）: Name, Desired, Current, Ready, Age（Priority=0）+ Containers, Images, Selector（Priority=1） |

**読解のコツ**: Desired/Current/Ready カラムの Type は "integer" であり、セルへの追加時に int64 にキャストされる点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | kubectl get コマンド共通エントリーポイント |

#### Step 3: print 関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printReplicationController`（行 1162-1181）: ptr.Deref で Replicas のデフォルト処理、Wide 時に Template nil チェック後 layoutContainerCells |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | `printReplicationControllerList`（行 1183-1193）: Items を順に委譲 |

**主要処理フロー**:
- **行 1167**: `ptr.Deref(obj.Spec.Replicas, 0)` で Desired を取得
- **行 1168-1169**: Status から Current, Ready を取得
- **行 1171**: Name, Desired(int64), Current(int64), Ready(int64), Age をセルに追加
- **行 1172-1179**: Wide 出力時、Template が nil でなければコンテナ情報とセレクタを追加

### プログラム呼び出し階層図

```
kubectl get rc
    |
    +-- GetOptions.Run() [get.go]
           |
           +-- API Server Request
           |       |
           |       +-- printReplicationControllerList() [printers.go 行1183]
           |               |
           |               +-- printReplicationController() [printers.go 行1162]
           |                       |
           |                       +-- ptr.Deref() [k8s.io/utils/ptr]
           |                       +-- layoutContainerCells() [printers.go 行2767]
           |                       +-- labels.FormatLabels()
           |
           +-- HumanReadablePrinter.PrintObj()
```

### データフロー図

```
[入力]                              [処理]                              [出力]

API Server (etcd)              printReplicationController()       標準出力 (stdout)
  RC Object                --> - Replicas デフォルト処理         --> テーブル形式テキスト
  (api.ReplicationController)  - Status から Current/Ready          NAME DESIRED CURRENT ...
                               - layoutContainerCells (wide)        rc1  3       3       3  5d
                               - labels.FormatLabels (wide)
                               - TableRow 生成
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | RC 用カラム定義と print 関数（行 129-140, 1162-1193） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルレンダリング |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl get コマンドエントリーポイント |
