# 帳票設計書 40-VolumeAttachment一覧

## 概要

本ドキュメントは、Kubernetes CLIツール（kubectl）における VolumeAttachment リソースの一覧表示機能に関する帳票設計書である。`kubectl get volumeattachments` コマンド実行時に VolumeAttachmentリソースをテーブル形式で出力する仕組みを定義する。

### 本帳票の処理概要

VolumeAttachmentリソースの一覧情報をテーブル形式で標準出力に表示する機能である。永続ボリュームがどのノードにアタッチされているか、どのCSIドライバーが処理しているか、アタッチ状態を一覧で確認できるようにする。

**業務上の目的・背景**：VolumeAttachmentはKubernetesにおけるボリュームのノードへのアタッチ操作を追跡するリソースである。CSIドライバーがボリュームをノードに物理的にアタッチする処理の状態を管理する。ストレージ関連の問題（ボリュームがアタッチできない、デタッチが完了しない等）の調査時に、アタッチ状態を確認するために不可欠である。

**帳票の利用シーン**：ストレージのアタッチ問題の調査時、ノード退役前のボリュームデタッチ確認時、CSIドライバーの動作確認時、孤立したVolumeAttachmentの検出時に利用される。

**主要な出力内容**：
1. VolumeAttachmentの名前（Name）
2. アタッチャー（CSIドライバー名）（Attacher）
3. PersistentVolume名（PV）
4. ノード名（Node）
5. アタッチ済みフラグ（Attached）
6. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get volumeattachments` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタの管理者、ストレージ管理者、SRE。

## 帳票種別

一覧表（テーブル形式標準出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get volumeattachments` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout）へのテキスト出力 |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で、ヘッダー行に続いて各VolumeAttachmentリソースが1行ずつ表示される。

```
┌───────────────────────────────────────────────────────────────────────────────────────┐
│  NAME                                ATTACHER              PV             NODE    ATTACHED   AGE │
├───────────────────────────────────────────────────────────────────────────────────────┤
│  csi-att-abc123                      csi.example.com      pvc-xyz456     node-1  true       5d  │
│  ...                                                                                              │
└───────────────────────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | VolumeAttachmentの名前 | ObjectMeta.Name | 文字列（Format: "name"） |
| 2 | Attacher | CSIドライバー名 | Spec.Attacher | 文字列（Format: "name"） |
| 3 | PV | PersistentVolume名 | Spec.Source.PersistentVolumeName | 文字列（nilの場合は空文字） |
| 4 | Node | アタッチ先ノード名 | Spec.NodeName | 文字列 |
| 5 | Attached | アタッチ済みフラグ | Status.Attached | boolean |
| 6 | Age | リソース作成からの経過時間 | ObjectMeta.CreationTimestamp | 人間可読な時間表記 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | 文字列 | 可変 |
| 2 | Attacher | CSIドライバー名 | obj.Spec.Attacher | 文字列 | 可変 |
| 3 | PV | PV名 | *obj.Spec.Source.PersistentVolumeName（nilなら空文字） | 文字列 | 可変 |
| 4 | Node | ノード名 | obj.Spec.NodeName | 文字列 | 可変 |
| 5 | Attached | アタッチ状態 | obj.Status.Attached | boolean | 可変 |
| 6 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | HumanDuration形式 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバーのデフォルト） |

### 改ページ条件

テキスト出力のため改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/volumeattachments/{name} | VolumeAttachmentリソースの実体データ | Name |

### テーブル別参照項目詳細

#### VolumeAttachment (storage.k8s.io/v1)

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| spec.attacher | Attacher | - | CSIドライバー名 |
| spec.source.persistentVolumeName | PV | - | ポインタ型。nilの場合は空文字を表示 |
| spec.nodeName | Node | - | アタッチ先ノード名 |
| status.attached | Attached | - | boolean。アタッチ完了状態 |
| metadata.creationTimestamp | Age | - | translateTimestampSince関数で変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| PV | obj.Spec.Source.PersistentVolumeName != nil ? *obj.Spec.Source.PersistentVolumeName : "" | - | ポインタnil時のフォールバック |
| Age | time.Since(creationTimestamp) | HumanDuration関数で近似表示 | 秒/分/時/日/年に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get volumeattachments 実行] --> B[APIサーバーへVolumeAttachment一覧リクエスト]
    B --> C[VolumeAttachmentリソース一覧取得]
    C --> D[HumanReadableGenerator.GenerateTable呼び出し]
    D --> E[printVolumeAttachment/printVolumeAttachmentList関数でTableRow生成]
    E --> F[PersistentVolumeNameのnil判定]
    F --> G[6項目をセルに追加]
    G --> H[HumanReadablePrinter.PrintObjでテーブル描画]
    H --> I[標準出力へ表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | VolumeAttachmentが存在しない | No resources found | 正常系 |
| 権限エラー | RBAC権限不足 | Error from server (Forbidden) | ClusterRoleBindingの設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百件（ノード数 x ボリューム数に比例） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | CLIツールのため制限なし |

## セキュリティ考慮事項

VolumeAttachmentはクラスタスコープリソースであり、クラスタレベルのRBAC権限が必要。ノード名、PV名、CSIドライバー名が含まれるため、クラスタのストレージ構成とノード構成に関する情報漏洩に注意。

## 備考

- VolumeAttachmentは storage.k8s.io/v1 APIグループに属するクラスタスコープリソース
- PersistentVolumeName はポインタ型（*string）であり、nilの場合は空文字として表示される（インラインボリュームソースの場合にnilとなる）
- Attacher カラムの Format 属性も "name" が設定されている（他のリソースではNameのみだが、VolumeAttachmentではAttacherにも設定）
- Status.Attached は boolean で、CSIドライバーがアタッチ完了を報告した場合に true となる

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/storage/types.go` | VolumeAttachment, VolumeAttachmentSpec, VolumeAttachmentSource, VolumeAttachmentStatus の内部型定義。Source.PersistentVolumeNameが*string型であることを確認 |
| 1-2 | types.go | `staging/src/k8s.io/api/storage/v1/types.go` | 外部API型定義。SwaggerDocからカラム説明文を取得 |

**読解のコツ**: VolumeAttachmentSourceにはPersistentVolumeNameとInlineVolumeSpecの2種類があり、PersistentVolumeNameがnilの場合はインラインボリュームが使用されている。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | AddHandlers関数内で、volumeAttachmentColumnDefinitions（520行目）として6カラムを定義 |

**主要処理フロー**:
1. **520行目**: volumeAttachmentColumnDefinitions で Name, Attacher, PV, Node, Attached, Age の6カラム定義
2. **528行目**: printVolumeAttachment をハンドラ登録
3. **529行目**: printVolumeAttachmentList をハンドラ登録

#### Step 3: プリンター関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | printVolumeAttachment関数（2951行目）: PersistentVolumeNameのnil判定処理 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printVolumeAttachmentList関数（2966行目）: リストからループ処理 |

**主要処理フロー**:
- **2956行目**: Name取得
- **2957行目**: pvName初期値を空文字に設定
- **2958-2959行目**: PersistentVolumeNameがnilでなければ値を取得
- **2961行目**: Name, Attacher, pvName, NodeName, Status.Attached, translateTimestampSince(CreationTimestamp) の6項目をセルに追加

### プログラム呼び出し階層図

```
kubectl get volumeattachments
    |
    +-- APIサーバーからVolumeAttachment一覧取得
    |
    +-- HumanReadableGenerator.GenerateTable()  [pkg/printers/tablegenerator.go:78]
           |
           +-- printVolumeAttachmentList()  [pkg/printers/internalversion/printers.go:2966]
           |       |
           |       +-- printVolumeAttachment()  [pkg/printers/internalversion/printers.go:2951]
           |              |
           |              +-- PersistentVolumeName nil判定
           |              +-- translateTimestampSince()  [pkg/printers/internalversion/printers.go:863]
           |
           +-- HumanReadablePrinter.PrintObj()  [staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go:95]
```

### データフロー図

```
[入力]                              [処理]                                           [出力]

etcd VolumeAttachment データ ──> APIサーバー List ──> printVolumeAttachmentList()
                                                          |
                                                          +-- PersistentVolumeName nil判定 → pvName
                                                          +-- Name, Attacher, pvName, NodeName, Attached
                                                          +-- translateTimestampSince()
                                                          |
                                                          +──> metav1.TableRow[] ──> テーブルテキスト ──> stdout
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | VolumeAttachmentプリンタ関数（printVolumeAttachment: 2951行目, カラム定義: 520行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルテキスト描画 |
| types.go | `pkg/apis/storage/types.go` | ソース | VolumeAttachment内部型定義 |
| types.go | `staging/src/k8s.io/api/storage/v1/types.go` | ソース | VolumeAttachment外部API型定義 |
