# 帳票設計書 41-EndpointSlice一覧

## 概要

本ドキュメントは、Kubernetes EndpointSliceリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get endpointslices` コマンド実行時に、EndpointSliceオブジェクトの情報を人間が読みやすいテーブル形式で標準出力へ出力する処理の仕様を定義する。

### 本帳票の処理概要

本帳票は、Kubernetes Discovery APIグループに属するEndpointSliceリソースの一覧情報を、テーブル形式で整形して出力する機能を提供する。

**業務上の目的・背景**：EndpointSliceは、Serviceに紐づくネットワークエンドポイントを効率的に管理するためのリソースである。従来のEndpointsリソースに比べ、大規模クラスタにおけるスケーラビリティが向上している。クラスタ管理者やDevOpsエンジニアが、ServiceのバックエンドPodへのトラフィック到達性を確認・診断するために、EndpointSliceの一覧表示が必要となる。

**帳票の利用シーン**：Serviceに接続できない場合のトラブルシューティング、ネットワーク構成の確認、エンドポイントの正常性確認、kube-proxyの動作検証などの場面で利用される。

**主要な出力内容**：
1. EndpointSlice名（Name）
2. アドレスタイプ（AddressType）- IPv4/IPv6/FQDN
3. ポート情報（Ports）- 最大3件表示、超過分は件数表示
4. エンドポイントアドレス（Endpoints）- 最大3件表示、超過分は件数表示
5. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get endpointslices` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、SRE、DevOpsエンジニア、ネットワーク管理者

## 帳票種別

一覧表（テーブル形式リソース一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get endpointslices` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字 |
| ヘッダー行 | あり（カラム名を大文字で表示） |
| 代替出力形式 | JSON / YAML / JSONPath / GoTemplate |

## 帳票レイアウト

### レイアウト概要

EndpointSliceリソースの情報を5カラムのテーブル形式で出力する。ヘッダー行にカラム名、以降の各行に1つのEndpointSliceの情報を表示する。

```
NAMESPACE   NAME                      ADDRESSTYPE   PORTS   ENDPOINTS               AGE
default     my-service-abc12          IPv4          80      10.0.0.1,10.0.0.2       5d
default     my-service-def34          IPv4          443     10.0.1.1,10.0.1.2,...   3d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | EndpointSlice名 | ObjectMeta.Name | 文字列そのまま |
| 2 | ADDRESSTYPE | アドレスタイプ | EndpointSlice.AddressType | 文字列（IPv4/IPv6/FQDN） |
| 3 | PORTS | ポート番号一覧 | EndpointSlice.Ports | カンマ区切り（最大3件、超過時は`+ N more...`） |
| 4 | ENDPOINTS | エンドポイントアドレス一覧 | EndpointSlice.Endpoints | カンマ区切り（最大3件、超過時は`+ N more...`） |
| 5 | AGE | 作成からの経過時間 | ObjectMeta.CreationTimestamp | 相対時間（例: 5d, 3h） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | string | 可変 |
| 2 | AddressType | アドレスタイプ | obj.AddressType | string(AddressType) | 可変 |
| 3 | Ports | ポート一覧 | formatDiscoveryPorts(obj.Ports) | カンマ区切り文字列 | 可変 |
| 4 | Endpoints | エンドポイント一覧 | formatDiscoveryEndpoints(obj.Endpoints) | カンマ区切り文字列 | 可変 |
| 5 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | 相対時間文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象Namespaceの指定（`-n`/`--namespace`フラグ） | No（デフォルト: 現在のNamespace） |
| --all-namespaces | 全Namespaceのリソースを表示 | No |
| ラベルセレクタ | `-l`フラグによるラベルフィルタリング | No |
| フィールドセレクタ | `--field-selector`フラグによるフィールドフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（デフォルト） |

### 改ページ条件

改ページは発生しない（ターミナルへのストリーム出力のため）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| EndpointSlice（etcd） | EndpointSliceリソース情報の取得 | API Serverへのリスト/取得リクエスト |

### テーブル別参照項目詳細

#### EndpointSlice

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | NAME | Namespace内の全EndpointSlice | - |
| addressType | ADDRESSTYPE | - | IPv4/IPv6/FQDN |
| ports[].port | PORTS | - | nilの場合は"*"、name指定の場合はname表示 |
| ports[].name | PORTS | port がnilの場合 | ポート番号が未設定時の代替表示 |
| endpoints[].addresses[] | ENDPOINTS | - | 各エンドポイントのアドレス一覧 |
| metadata.creationTimestamp | AGE | - | 相対時間に変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Ports表示文字列 | formatDiscoveryPorts: 最大3ポートをカンマ区切り、超過分は`+ N more...` | N/A | portがnilなら"*"、nameがあればname表示 |
| Endpoints表示文字列 | formatDiscoveryEndpoints: 最大3アドレスをカンマ区切り、超過分は`+ N more...` | N/A | 各endpointの全addressesをフラット化 |
| Age | 現在時刻 - CreationTimestamp | N/A | translateTimestampSince関数で相対時間表示 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get endpointslices 実行] --> B[GetOptions.Run]
    B --> C[API Serverへリスト要求]
    C --> D[EndpointSliceList取得]
    D --> E[printEndpointSliceList呼び出し]
    E --> F[各EndpointSliceをprintEndpointSlice処理]
    F --> G[TableRow生成]
    G --> H[HumanReadablePrinter.PrintObj]
    H --> I[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未検出 | 指定Namespaceにリソースが存在しない | `No resources found in {namespace} namespace.` | 対象Namespaceの確認 |
| 権限不足 | RBAC権限が不足している | `Error from server (Forbidden): ...` | 適切なRoleBinding設定 |
| API未対応 | APIグループが無効 | `error: the server doesn't have a resource type "endpointslices"` | APIバージョンの確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千件（大規模クラスタでServiceあたり複数のEndpointSlice） |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | N/A（CLIツールのため） |

## セキュリティ考慮事項

EndpointSliceにはPodのIPアドレスが含まれるため、ネットワーク構成情報の漏洩防止の観点から、RBAC権限設定による適切なアクセス制御が必要である。discovery.k8s.io APIグループへのget/list権限が必要。

## 備考

- EndpointSliceはKubernetes v1.21でGAとなった機能であり、従来のEndpointsリソースを補完・置換する目的で設計されている。
- Portsカラム・Endpointsカラムは最大3件までの表示となり、超過分は`+ N more...`形式で件数のみ表示される。
- JSON/YAML/JSONPath/GoTemplate形式での出力にも対応（`-o`フラグ指定時）。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

EndpointSliceリソースの内部表現を把握することが最初のステップである。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/discovery/types.go` | EndpointSlice構造体（29行目）: AddressType、Endpoints、Portsフィールドの定義を確認 |
| 1-2 | types.go | `pkg/apis/discovery/types.go` | Endpoint構造体・EndpointPort構造体: 個々のエンドポイントとポートの構造を理解 |

**読解のコツ**: `pkg/apis/discovery/types.go`はKubernetes内部API型であり、外部APIバージョン（`k8s.io/api/discovery/v1`）と変換可能な構造になっている。

#### Step 2: エントリーポイントを理解する

kubectlの`get`コマンドがどのようにリソース一覧を取得し、テーブル出力を呼び出すかを確認する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | NewCmdGet関数（161行目）: getコマンドの初期化処理 |
| 2-2 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | Run関数（443行目）: リソース取得とプリンター呼び出しのメインフロー |

**主要処理フロー**:
1. **161行目**: NewCmdGetでコマンド定義とフラグ設定
2. **443行目**: Run関数でAPI Serverからリソース取得、プリンターで出力

#### Step 3: テーブルカラム定義と出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | endpointSliceColumnDefinitions（531-537行目）: テーブルカラムの定義 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printEndpointSlice関数（1612-1618行目）: 個別EndpointSliceのテーブル行生成 |
| 3-3 | printers.go | `pkg/printers/internalversion/printers.go` | printEndpointSliceList関数（1620-1630行目）: リスト全体のテーブル生成 |

**主要処理フロー**:
- **531-537行目**: Name, AddressType, Ports, Endpoints, Ageの5カラムを定義
- **1612-1618行目**: 各EndpointSliceオブジェクトからTableRowを生成、formatDiscoveryPorts/formatDiscoveryEndpointsで表示文字列整形
- **1620-1630行目**: リストの各アイテムをループしてprintEndpointSliceを呼び出し

#### Step 4: ヘルパー関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 4-1 | printers.go | `pkg/printers/internalversion/printers.go` | formatDiscoveryPorts関数（800-820行目）: ポート情報の整形（最大3件表示） |
| 4-2 | printers.go | `pkg/printers/internalversion/printers.go` | formatDiscoveryEndpoints関数（822-838行目）: エンドポイントアドレスの整形（最大3件表示） |
| 4-3 | printers.go | `pkg/printers/internalversion/printers.go` | listWithMoreString関数（840行目〜）: 超過分の`+ N more...`表示処理 |

### プログラム呼び出し階層図

```
kubectl get endpointslices
    |
    +-- NewCmdGet (staging/src/k8s.io/kubectl/pkg/cmd/get/get.go:161)
    |       |
    |       +-- GetOptions.Run (get.go:443)
    |               |
    |               +-- API Server リクエスト (EndpointSliceList取得)
    |               |
    |               +-- HumanReadablePrinter.PrintObj
    |                       |
    |                       +-- printEndpointSliceList (printers.go:1620)
    |                               |
    |                               +-- printEndpointSlice (printers.go:1612)
    |                                       |
    |                                       +-- formatDiscoveryPorts (printers.go:800)
    |                                       +-- formatDiscoveryEndpoints (printers.go:822)
    |                                       +-- translateTimestampSince
```

### データフロー図

```
[入力]                    [処理]                              [出力]

API Server          printEndpointSliceList              標準出力(stdout)
(etcd)         +----------------------------------+
               |                                  |
EndpointSlice  |  printEndpointSlice               |    NAME  ADDRESSTYPE  PORTS  ENDPOINTS  AGE
List --------->|    +- formatDiscoveryPorts   -----|-->  ...   IPv4         80     10.0.0.1   5d
               |    +- formatDiscoveryEndpoints    |
               |    +- translateTimestampSince     |
               +----------------------------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| types.go | `pkg/apis/discovery/types.go` | ソース | EndpointSlice内部API型定義 |
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | テーブルカラム定義・出力関数 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printEndpointSliceのテストケース |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力 |
