# 帳票設計書 42-CSINode一覧

## 概要

本ドキュメントは、Kubernetes CSINodeリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get csinodes` コマンド実行時に、CSINodeオブジェクトの情報を人間が読みやすいテーブル形式で標準出力へ出力する処理の仕様を定義する。

### 本帳票の処理概要

本帳票は、Kubernetes Storage APIグループに属するCSINodeリソースの一覧情報を、テーブル形式で整形して出力する機能を提供する。

**業務上の目的・背景**：CSINodeは、各ノードにインストールされているCSI（Container Storage Interface）ドライバーの情報を保持するリソースである。ストレージの可用性やドライバーの配置状況を確認するために、クラスタ管理者がCSINodeの一覧を参照する必要がある。ノードごとにどのCSIドライバーが利用可能かを把握することで、ストレージプロビジョニングの問題を診断できる。

**帳票の利用シーン**：CSIドライバーのインストール確認、ストレージ関連の障害調査、ノードのストレージ機能確認、CSIドライバーのアップグレード後の動作確認などの場面で利用される。

**主要な出力内容**：
1. CSINode名（Name）- ノード名と同一
2. 登録ドライバー数（Drivers）
3. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get csinodes` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、ストレージ管理者、SRE

## 帳票種別

一覧表（テーブル形式リソース一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get csinodes` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字 |
| ヘッダー行 | あり（カラム名を大文字で表示） |
| 代替出力形式 | JSON / YAML / JSONPath / GoTemplate |

## 帳票レイアウト

### レイアウト概要

CSINodeリソースの情報を3カラムのテーブル形式で出力する。

```
NAME           DRIVERS   AGE
node-1         2         30d
node-2         1         15d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | CSINode名（ノード名） | ObjectMeta.Name | 文字列そのまま |
| 2 | DRIVERS | 登録CSIドライバー数 | len(CSINode.Spec.Drivers) | 整数 |
| 3 | AGE | 作成からの経過時間 | ObjectMeta.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | string | 可変 |
| 2 | Drivers | ドライバー数 | int64(len(obj.Spec.Drivers)) | integer | 可変 |
| 3 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | 相対時間文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ラベルセレクタ | `-l`フラグによるラベルフィルタリング | No |
| フィールドセレクタ | `--field-selector`フラグによるフィールドフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（デフォルト） |

### 改ページ条件

改ページは発生しない（ターミナルへのストリーム出力のため）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| CSINode（etcd） | CSINodeリソース情報の取得 | API Serverへのリスト/取得リクエスト |

### テーブル別参照項目詳細

#### CSINode

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | NAME | クラスタ内の全CSINode | ノード名と同一 |
| spec.drivers | DRIVERS | - | 配列長をカウント |
| metadata.creationTimestamp | AGE | - | 相対時間に変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Drivers | len(obj.Spec.Drivers) | N/A | ドライバー配列の要素数 |
| Age | 現在時刻 - CreationTimestamp | N/A | translateTimestampSince関数で相対時間表示 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get csinodes 実行] --> B[GetOptions.Run]
    B --> C[API Serverへリスト要求]
    C --> D[CSINodeList取得]
    D --> E[printCSINodeList呼び出し]
    E --> F[各CSINodeをprintCSINode処理]
    F --> G[TableRow生成]
    G --> H[HumanReadablePrinter.PrintObj]
    H --> I[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未検出 | クラスタにCSINodeが存在しない | `No resources found` | CSIドライバーのインストール確認 |
| 権限不足 | RBAC権限が不足している | `Error from server (Forbidden): ...` | 適切なClusterRoleBinding設定 |
| API未対応 | storage APIグループが無効 | `error: the server doesn't have a resource type "csinodes"` | APIバージョンの確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | クラスタのノード数と同数（数十〜数千件） |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | N/A（CLIツールのため） |

## セキュリティ考慮事項

CSINodeはクラスタスコープのリソースであり、ノードのストレージ構成情報が含まれる。storage.k8s.io APIグループへのget/list権限が必要。

## 備考

- CSINodeはクラスタスコープのリソースであり、Namespace指定は不要。
- metadata.nameはKubernetesノード名と同一である。
- CSINodeはKubernetes v1.17でGAとなった。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/storage/types.go` | CSINode構造体（546行目）: Specフィールドの構造を確認 |
| 1-2 | types.go | `pkg/apis/storage/types.go` | CSINodeSpec構造体（557行目）: Driversフィールド（CSINodeDriverの配列） |

**読解のコツ**: CSINodeのNameはノード名と一致する設計になっている点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | NewCmdGet関数（161行目）: getコマンドの初期化 |
| 2-2 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | Run関数（443行目）: リソース取得と出力のメインフロー |

#### Step 3: テーブルカラム定義と出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | csiNodeColumnDefinitions（541-545行目）: Name, Drivers, Ageの3カラム定義 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printCSINode関数（1632-1638行目）: ドライバー数をlen(obj.Spec.Drivers)で算出 |
| 3-3 | printers.go | `pkg/printers/internalversion/printers.go` | printCSINodeList関数（1640-1650行目）: リスト全体の処理 |

**主要処理フロー**:
- **1636行目**: `row.Cells = append(row.Cells, obj.Name, int64(len(obj.Spec.Drivers)), translateTimestampSince(obj.CreationTimestamp))`

### プログラム呼び出し階層図

```
kubectl get csinodes
    |
    +-- NewCmdGet (get.go:161)
    |       |
    |       +-- GetOptions.Run (get.go:443)
    |               |
    |               +-- API Server リクエスト (CSINodeList取得)
    |               |
    |               +-- HumanReadablePrinter.PrintObj
    |                       |
    |                       +-- printCSINodeList (printers.go:1640)
    |                               |
    |                               +-- printCSINode (printers.go:1632)
    |                                       |
    |                                       +-- translateTimestampSince
```

### データフロー図

```
[入力]                [処理]                          [出力]

API Server      printCSINodeList                 標準出力(stdout)
(etcd)     +------------------------------+
           |                              |
CSINode    | printCSINode                  |    NAME  DRIVERS  AGE
List ----->|   +- len(Spec.Drivers)   -----|->  node-1  2     30d
           |   +- translateTimestampSince  |
           +------------------------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| types.go | `pkg/apis/storage/types.go` | ソース | CSINode内部API型定義 |
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | テーブルカラム定義・出力関数 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printCSINodeのテストケース |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力 |
