# 帳票設計書 43-CSIDriver一覧

## 概要

本ドキュメントは、Kubernetes CSIDriverリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get csidrivers` コマンド実行時に、CSIDriverオブジェクトの情報を人間が読みやすいテーブル形式で標準出力へ出力する処理の仕様を定義する。

### 本帳票の処理概要

本帳票は、Kubernetes Storage APIグループに属するCSIDriverリソースの一覧情報を、テーブル形式で整形して出力する機能を提供する。

**業務上の目的・背景**：CSIDriverは、クラスタに登録されたCSI（Container Storage Interface）ドライバーの仕様情報を保持するリソースである。各ドライバーがVolumeアタッチを必要とするか、Pod情報をマウント時に提供するか、ストレージ容量追跡に対応するかなど、ドライバーの機能特性を確認するために必要となる。クラスタ管理者がストレージプロビジョニング戦略を策定・管理する際に参照する。

**帳票の利用シーン**：CSIドライバーのインストール状況確認、ドライバーの機能特性確認、ストレージ関連のトラブルシューティング、新規CSIドライバー導入時の検証などの場面で利用される。

**主要な出力内容**：
1. CSIDriver名（Name）
2. アタッチ要否（AttachRequired）
3. Pod情報マウント（PodInfoOnMount）
4. ストレージ容量追跡（StorageCapacity）
5. トークンリクエスト（TokenRequests）
6. 再公開要否（RequiresRepublish）
7. ボリュームライフサイクルモード（Modes）
8. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get csidrivers` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、ストレージ管理者、SRE

## 帳票種別

一覧表（テーブル形式リソース一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get csidrivers` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字 |
| ヘッダー行 | あり（カラム名を大文字で表示） |
| 代替出力形式 | JSON / YAML / JSONPath / GoTemplate |

## 帳票レイアウト

### レイアウト概要

CSIDriverリソースの情報を8カラムのテーブル形式で出力する。

```
NAME                  ATTACHREQUIRED   PODINFOONMOUNT   STORAGECAPACITY   TOKENREQUESTS   REQUIRESREPUBLISH   MODES        AGE
ebs.csi.aws.com       true             false            true              <unset>         false               Persistent   30d
efs.csi.aws.com       false            false            false             <unset>         false               Persistent   25d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | CSIDriver名 | ObjectMeta.Name | 文字列 |
| 2 | ATTACHREQUIRED | アタッチ要否 | Spec.AttachRequired | boolean（デフォルト: true） |
| 3 | PODINFOONMOUNT | Pod情報マウント | Spec.PodInfoOnMount | boolean（デフォルト: false） |
| 4 | STORAGECAPACITY | ストレージ容量追跡 | Spec.StorageCapacity | boolean（デフォルト: false） |
| 5 | TOKENREQUESTS | トークンリクエストのAudience | Spec.TokenRequests | カンマ区切り文字列（未設定時: `<unset>`） |
| 6 | REQUIRESREPUBLISH | 再公開要否 | Spec.RequiresRepublish | boolean（デフォルト: false） |
| 7 | MODES | ボリュームライフサイクルモード | Spec.VolumeLifecycleModes | カンマ区切り文字列（未設定時: `<none>`） |
| 8 | AGE | 作成からの経過時間 | ObjectMeta.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | ドライバー名 | obj.Name | string | 可変 |
| 2 | AttachRequired | アタッチ要否 | *obj.Spec.AttachRequired (nilならtrue) | boolean | 可変 |
| 3 | PodInfoOnMount | Pod情報 | *obj.Spec.PodInfoOnMount (nilならfalse) | boolean | 可変 |
| 4 | StorageCapacity | 容量追跡 | *obj.Spec.StorageCapacity (nilならfalse) | boolean | 可変 |
| 5 | TokenRequests | トークン | Spec.TokenRequests各要素のAudience結合 | string | 可変 |
| 6 | RequiresRepublish | 再公開 | *obj.Spec.RequiresRepublish (nilならfalse) | boolean | 可変 |
| 7 | Modes | モード | Spec.VolumeLifecycleModes結合 | string | 可変 |
| 8 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | string | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ラベルセレクタ | `-l`フラグによるラベルフィルタリング | No |
| フィールドセレクタ | `--field-selector`フラグによるフィールドフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（デフォルト） |

### 改ページ条件

改ページは発生しない（ターミナルへのストリーム出力のため）。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| CSIDriver（etcd） | CSIDriverリソース情報の取得 | API Serverへのリスト/取得リクエスト |

### テーブル別参照項目詳細

#### CSIDriver

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | NAME | クラスタ内の全CSIDriver | ドライバー名 |
| spec.attachRequired | ATTACHREQUIRED | - | nilの場合はtrueがデフォルト |
| spec.podInfoOnMount | PODINFOONMOUNT | - | nilの場合はfalseがデフォルト |
| spec.storageCapacity | STORAGECAPACITY | - | nilの場合はfalseがデフォルト |
| spec.tokenRequests[].audience | TOKENREQUESTS | - | nilの場合は`<unset>` |
| spec.requiresRepublish | REQUIRESREPUBLISH | - | nilの場合はfalseがデフォルト |
| spec.volumeLifecycleModes[] | MODES | - | 空の場合は`<none>` |
| metadata.creationTimestamp | AGE | - | 相対時間に変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| AttachRequired | Spec.AttachRequiredがnilならtrue、それ以外は*Spec.AttachRequired | N/A | ポインタのデリファレンス |
| PodInfoOnMount | Spec.PodInfoOnMountがnilならfalse、それ以外は*Spec.PodInfoOnMount | N/A | ポインタのデリファレンス |
| StorageCapacity | Spec.StorageCapacityがnilならfalse、それ以外は*Spec.StorageCapacity | N/A | ポインタのデリファレンス |
| TokenRequests | Spec.TokenRequestsがnilなら`<unset>`、それ以外は各Audienceをカンマ結合 | N/A | - |
| RequiresRepublish | Spec.RequiresRepublishがnilならfalse、それ以外は*Spec.RequiresRepublish | N/A | ポインタのデリファレンス |
| Modes | Spec.VolumeLifecycleModesが空なら`<none>`、それ以外はカンマ結合 | N/A | - |
| Age | 現在時刻 - CreationTimestamp | N/A | translateTimestampSince |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get csidrivers 実行] --> B[GetOptions.Run]
    B --> C[API Serverへリスト要求]
    C --> D[CSIDriverList取得]
    D --> E[printCSIDriverList呼び出し]
    E --> F[各CSIDriverをprintCSIDriver処理]
    F --> G[各フィールドのnil判定・デフォルト値適用]
    G --> H[TableRow生成]
    H --> I[HumanReadablePrinter.PrintObj]
    I --> J[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未検出 | クラスタにCSIDriverが存在しない | `No resources found` | CSIドライバーのインストール確認 |
| 権限不足 | RBAC権限が不足 | `Error from server (Forbidden): ...` | 適切なClusterRoleBinding設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件（インストール済みCSIドライバー数） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A（CLIツールのため） |

## セキュリティ考慮事項

CSIDriverはクラスタスコープのリソースであり、ストレージインフラの構成情報が含まれる。storage.k8s.io APIグループへのget/list権限が必要。

## 備考

- CSIDriverはクラスタスコープのリソースであり、Namespace指定は不要。
- boolean型フィールドはポインタ型（*bool）で定義されており、nilの場合はデフォルト値が適用される。
- TokenRequestsが設定されている場合、各TokenRequestのAudienceをカンマ区切りで表示する。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/storage/types.go` | CSIDriver構造体（241行目）: Specフィールドの構造 |
| 1-2 | types.go | `pkg/apis/storage/types.go` | CSIDriverSpec構造体: AttachRequired, PodInfoOnMount, StorageCapacity, TokenRequests, RequiresRepublish, VolumeLifecycleModesの各フィールド |

**読解のコツ**: boolean型フィールドがポインタ（*bool）で定義されている点に注意。nil判定によるデフォルト値処理がprint関数内で行われる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | NewCmdGet関数（161行目） |
| 2-2 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | Run関数（443行目） |

#### Step 3: テーブルカラム定義と出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | csiDriverColumnDefinitions（549-563行目）: 8カラムの定義、appendで段階的に構築 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printCSIDriver関数（1652-1696行目）: nil判定付きの複雑なフィールド処理 |
| 3-3 | printers.go | `pkg/printers/internalversion/printers.go` | printCSIDriverList関数（1698-1708行目）: リスト処理 |

**主要処理フロー**:
- **1656-1658行目**: AttachRequiredのnil判定（デフォルトtrue）
- **1660-1662行目**: PodInfoOnMountのnil判定（デフォルトfalse）
- **1664-1671行目**: VolumeLifecycleModesのカンマ結合、空なら`<none>`
- **1674-1678行目**: StorageCapacityのnil判定（デフォルトfalse）
- **1680-1687行目**: TokenRequestsのAudience結合、nilなら`<unset>`
- **1688-1692行目**: RequiresRepublishのnil判定（デフォルトfalse）

### プログラム呼び出し階層図

```
kubectl get csidrivers
    |
    +-- NewCmdGet (get.go:161)
    |       |
    |       +-- GetOptions.Run (get.go:443)
    |               |
    |               +-- API Server リクエスト (CSIDriverList取得)
    |               |
    |               +-- HumanReadablePrinter.PrintObj
    |                       |
    |                       +-- printCSIDriverList (printers.go:1698)
    |                               |
    |                               +-- printCSIDriver (printers.go:1652)
    |                                       |
    |                                       +-- nil判定・デフォルト値処理
    |                                       +-- strings.Join (VolumeLifecycleModes)
    |                                       +-- strings.Join (TokenRequests Audiences)
    |                                       +-- translateTimestampSince
```

### データフロー図

```
[入力]                [処理]                                    [出力]

API Server      printCSIDriverList                        標準出力(stdout)
(etcd)     +------------------------------------------+
           |                                          |
CSIDriver  | printCSIDriver                            |    NAME  ATTACHREQUIRED  ...  MODES  AGE
List ----->|   +- *AttachRequired (nil->true)      ----|->  ebs   true            ...  Persistent  30d
           |   +- *PodInfoOnMount (nil->false)         |
           |   +- *StorageCapacity (nil->false)        |
           |   +- TokenRequests->Audiences join        |
           |   +- *RequiresRepublish (nil->false)      |
           |   +- VolumeLifecycleModes join            |
           |   +- translateTimestampSince              |
           +------------------------------------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| types.go | `pkg/apis/storage/types.go` | ソース | CSIDriver内部API型定義 |
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | テーブルカラム定義・出力関数 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printCSIDriverのテストケース |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力 |
