# 帳票設計書 44-CSIStorageCapacity一覧

## 概要

本ドキュメントは、Kubernetes CSIStorageCapacityリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get csistoragecapacities` コマンド実行時に、CSIStorageCapacityオブジェクトの情報を人間が読みやすいテーブル形式で標準出力へ出力する処理の仕様を定義する。

### 本帳票の処理概要

本帳票は、Kubernetes Storage APIグループに属するCSIStorageCapacityリソースの一覧情報を、テーブル形式で整形して出力する機能を提供する。

**業務上の目的・背景**：CSIStorageCapacityは、CSIドライバーが報告するストレージ容量情報を保持するリソースである。Kubernetesスケジューラがストレージ容量を考慮してPodをスケジューリングする際に参照される。クラスタ管理者がストレージの利用可能容量を確認し、容量不足によるスケジューリング失敗の原因を調査するために必要となる。

**帳票の利用シーン**：ストレージ容量の確認、PVCのプロビジョニング失敗時のトラブルシューティング、ストレージリソースの容量計画、CSIドライバーのストレージ容量報告動作の検証などの場面で利用される。

**主要な出力内容**：
1. CSIStorageCapacity名（Name）
2. ストレージクラス名（StorageClassName）
3. 容量（Capacity）

**帳票の出力タイミング**：ユーザーが `kubectl get csistoragecapacities` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、ストレージ管理者、SRE

## 帳票種別

一覧表（テーブル形式リソース一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get csistoragecapacities` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字 |
| ヘッダー行 | あり（カラム名を大文字で表示） |
| 代替出力形式 | JSON / YAML / JSONPath / GoTemplate |

## 帳票レイアウト

### レイアウト概要

CSIStorageCapacityリソースの情報を3カラムのテーブル形式で出力する。

```
NAME                              STORAGECLASSNAME   CAPACITY
csisc-abc123                      standard           100Gi
csisc-def456                      premium-ssd        500Gi
csisc-ghi789                      standard           <unset>
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | CSIStorageCapacity名 | ObjectMeta.Name | 文字列 |
| 2 | STORAGECLASSNAME | ストレージクラス名 | StorageClassName | 文字列 |
| 3 | CAPACITY | ストレージ容量 | Capacity | リソース量文字列（未設定時: `<unset>`） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | string | 可変 |
| 2 | StorageClassName | ストレージクラス名 | obj.StorageClassName | string | 可変 |
| 3 | Capacity | 容量 | obj.Capacity.String() (nilなら`<unset>`) | string | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象Namespaceの指定（`-n`/`--namespace`フラグ） | No（デフォルト: 現在のNamespace） |
| --all-namespaces | 全Namespaceのリソースを表示 | No |
| ラベルセレクタ | `-l`フラグによるラベルフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（デフォルト） |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| CSIStorageCapacity（etcd） | CSIStorageCapacityリソース情報の取得 | API Serverへのリスト/取得リクエスト |

### テーブル別参照項目詳細

#### CSIStorageCapacity

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | NAME | Namespace内の全CSIStorageCapacity | - |
| storageClassName | STORAGECLASSNAME | - | StorageClassの名前 |
| capacity | CAPACITY | - | nilの場合は`<unset>` |
| metadata.creationTimestamp | - | - | 本帳票ではAgeカラムなし |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Capacity表示文字列 | obj.Capacityがnilなら`<unset>`、それ以外はobj.Capacity.String() | N/A | resource.Quantity型のString()メソッド |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get csistoragecapacities 実行] --> B[GetOptions.Run]
    B --> C[API Serverへリスト要求]
    C --> D[CSIStorageCapacityList取得]
    D --> E[printCSIStorageCapacityList呼び出し]
    E --> F[各CSIStorageCapacityをprintCSIStorageCapacity処理]
    F --> G[Capacityのnil判定]
    G --> H[TableRow生成]
    H --> I[HumanReadablePrinter.PrintObj]
    I --> J[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未検出 | 指定Namespaceにリソースが存在しない | `No resources found in {namespace} namespace.` | CSIドライバーのStorageCapacity設定確認 |
| 権限不足 | RBAC権限が不足 | `Error from server (Forbidden): ...` | 適切なRoleBinding設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十〜数百件（ノード数 x StorageClass数に依存） |
| 目標出力時間 | 数秒以内 |
| 同時出力数上限 | N/A（CLIツールのため） |

## セキュリティ考慮事項

CSIStorageCapacityはNamespacedリソースであり、ストレージ容量情報が含まれる。storage.k8s.io APIグループへのget/list権限が必要。

## 備考

- CSIStorageCapacityはNamespacedリソースである（CSIDriver/CSINodeとは異なる）。
- Capacityフィールドはresource.Quantity型で、nil許容。nilの場合は`<unset>`と表示される。
- 本帳票にはAgeカラムが含まれない（Name, StorageClassName, Capacityの3カラムのみ）。
- CSIStorageCapacityはKubernetes v1.24でGAとなった。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/storage/types.go` | CSIStorageCapacity構造体（652行目）: NodeTopology, StorageClassName, Capacity, MaximumVolumeSizeフィールド |

**読解のコツ**: Capacityフィールドは`*resource.Quantity`型で、nilの場合の処理がprint関数内で必要となる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | Run関数（443行目） |

#### Step 3: テーブルカラム定義と出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | csiStorageCapacityColumnDefinitions（567-571行目）: Name, StorageClassName, Capacityの3カラム定義 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printCSIStorageCapacity関数（1710-1722行目）: Capacityのnil判定処理 |
| 3-3 | printers.go | `pkg/printers/internalversion/printers.go` | printCSIStorageCapacityList関数（1724-1734行目）: リスト処理 |

**主要処理フロー**:
- **1715-1718行目**: Capacityがnilなら`<unset>`、それ以外はobj.Capacity.String()
- **1720行目**: `row.Cells = append(row.Cells, obj.Name, obj.StorageClassName, capacity)`

### プログラム呼び出し階層図

```
kubectl get csistoragecapacities
    |
    +-- NewCmdGet (get.go:161)
    |       |
    |       +-- GetOptions.Run (get.go:443)
    |               |
    |               +-- API Server リクエスト (CSIStorageCapacityList取得)
    |               |
    |               +-- HumanReadablePrinter.PrintObj
    |                       |
    |                       +-- printCSIStorageCapacityList (printers.go:1724)
    |                               |
    |                               +-- printCSIStorageCapacity (printers.go:1710)
    |                                       |
    |                                       +-- Capacity nil判定
    |                                       +-- Capacity.String()
```

### データフロー図

```
[入力]                    [処理]                                [出力]

API Server          printCSIStorageCapacityList            標準出力(stdout)
(etcd)         +--------------------------------------+
               |                                      |
CSIStorage     | printCSIStorageCapacity                |    NAME  STORAGECLASSNAME  CAPACITY
Capacity ----->|   +- Capacity nil ? "<unset>" : ------|->  csisc  standard          100Gi
List           |       Capacity.String()               |
               +--------------------------------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| types.go | `pkg/apis/storage/types.go` | ソース | CSIStorageCapacity内部API型定義 |
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | テーブルカラム定義・出力関数 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printCSIStorageCapacityのテストケース |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力 |
