# 帳票設計書 46-ValidatingWebhookConfiguration一覧

## 概要

本ドキュメントは、Kubernetes ValidatingWebhookConfigurationリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get validatingwebhookconfigurations` コマンド実行時に、ValidatingWebhookConfigurationオブジェクトの情報を人間が読みやすいテーブル形式で標準出力へ出力する処理の仕様を定義する。

### 本帳票の処理概要

本帳票は、Kubernetes AdmissionRegistration APIグループに属するValidatingWebhookConfigurationリソースの一覧情報を、テーブル形式で整形して出力する機能を提供する。

**業務上の目的・背景**：ValidatingWebhookConfigurationは、Kubernetes APIサーバーに対する検証（Validating）Admission Webhookの設定を定義するリソースである。APIリクエストが処理される前にWebhookを呼び出してオブジェクトの検証を行い、ポリシー違反の場合はリクエストを拒否する。セキュリティポリシー、リソース制約、命名規則の強制などに利用される。MutatingWebhookとは異なり、オブジェクトの変更は行わず検証のみを行う。

**帳票の利用シーン**：Admission Webhookの設定確認、ポリシー適用状況の確認、リソース作成・更新が拒否される原因の調査、Webhook設定のトラブルシューティングなどの場面で利用される。

**主要な出力内容**：
1. ValidatingWebhookConfiguration名（Name）
2. 登録Webhook数（Webhooks）
3. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get validatingwebhookconfigurations` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、セキュリティ管理者、SRE、プラットフォームエンジニア

## 帳票種別

一覧表（テーブル形式リソース一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get validatingwebhookconfigurations` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字 |
| ヘッダー行 | あり（カラム名を大文字で表示） |
| 代替出力形式 | JSON / YAML / JSONPath / GoTemplate |

## 帳票レイアウト

### レイアウト概要

ValidatingWebhookConfigurationリソースの情報を3カラムのテーブル形式で出力する。

```
NAME                                      WEBHOOKS   AGE
cert-manager-webhook                      1          30d
gatekeeper-validating-webhook-config      2          25d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | ValidatingWebhookConfiguration名 | ObjectMeta.Name | 文字列 |
| 2 | WEBHOOKS | 登録Webhook数 | len(Webhooks) | 整数 |
| 3 | AGE | 作成からの経過時間 | ObjectMeta.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | string | 可変 |
| 2 | Webhooks | Webhook数 | int64(len(obj.Webhooks)) | integer | 可変 |
| 3 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | 相対時間文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ラベルセレクタ | `-l`フラグによるラベルフィルタリング | No |
| フィールドセレクタ | `--field-selector`フラグによるフィールドフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（デフォルト） |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ValidatingWebhookConfiguration（etcd） | リソース情報の取得 | API Serverへのリスト/取得リクエスト |

### テーブル別参照項目詳細

#### ValidatingWebhookConfiguration

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | NAME | クラスタ内の全ValidatingWebhookConfiguration | - |
| webhooks | WEBHOOKS | - | 配列長をカウント |
| metadata.creationTimestamp | AGE | - | 相対時間に変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Webhooks | int64(len(obj.Webhooks)) | N/A | Webhooks配列の要素数 |
| Age | 現在時刻 - CreationTimestamp | N/A | translateTimestampSince関数 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get validatingwebhookconfigurations 実行] --> B[GetOptions.Run]
    B --> C[API Serverへリスト要求]
    C --> D[ValidatingWebhookConfigurationList取得]
    D --> E[printValidatingWebhookList呼び出し]
    E --> F[各ValidatingWebhookConfigurationをprintValidatingWebhook処理]
    F --> G[TableRow生成]
    G --> H[HumanReadablePrinter.PrintObj]
    H --> I[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未検出 | クラスタにリソースが存在しない | `No resources found` | Webhook設定の確認 |
| 権限不足 | RBAC権限が不足 | `Error from server (Forbidden): ...` | 適切なClusterRoleBinding設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A（CLIツールのため） |

## セキュリティ考慮事項

ValidatingWebhookConfigurationはクラスタスコープのリソースであり、セキュリティポリシーの検証設定を含む。不正な変更・削除はセキュリティポリシーのバイパスにつながるため、admissionregistration.k8s.io APIグループへの適切なRBAC権限設定が重要。

## 備考

- ValidatingWebhookConfigurationはクラスタスコープのリソースであり、Namespace指定は不要。
- MutatingWebhookConfigurationとカラム構成は同一（Name, Webhooks, Age）。
- 出力処理のロジックも同等であるが、参照するフィールド型がValidatingWebhookである点が異なる。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/admissionregistration/types.go` | ValidatingWebhookConfiguration構造体: Webhooksフィールド（ValidatingWebhookの配列） |

**読解のコツ**: MutatingWebhookConfigurationと構造が類似しているが、Webhooksフィールドの型がValidatingWebhookである点に注意。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | Run関数（443行目） |

#### Step 3: テーブルカラム定義と出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | validatingWebhookColumnDefinitions（583-587行目）: Name, Webhooks, Ageの3カラム定義 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printValidatingWebhook関数（1756-1762行目）: len(obj.Webhooks)でWebhook数を取得 |
| 3-3 | printers.go | `pkg/printers/internalversion/printers.go` | printValidatingWebhookList関数（1764-1774行目）: リスト処理 |

**主要処理フロー**:
- **1760行目**: `row.Cells = append(row.Cells, obj.Name, int64(len(obj.Webhooks)), translateTimestampSince(obj.CreationTimestamp))`

### プログラム呼び出し階層図

```
kubectl get validatingwebhookconfigurations
    |
    +-- NewCmdGet (get.go:161)
    |       |
    |       +-- GetOptions.Run (get.go:443)
    |               |
    |               +-- API Server リクエスト (ValidatingWebhookConfigurationList取得)
    |               |
    |               +-- HumanReadablePrinter.PrintObj
    |                       |
    |                       +-- printValidatingWebhookList (printers.go:1764)
    |                               |
    |                               +-- printValidatingWebhook (printers.go:1756)
    |                                       |
    |                                       +-- len(obj.Webhooks)
    |                                       +-- translateTimestampSince
```

### データフロー図

```
[入力]                          [処理]                            [出力]

API Server                printValidatingWebhookList         標準出力(stdout)
(etcd)               +----------------------------------+
                     |                                  |
ValidatingWebhook    | printValidatingWebhook            |    NAME  WEBHOOKS  AGE
Configuration ------>|   +- len(Webhooks)           -----|->  cert   1        30d
List                 |   +- translateTimestampSince      |
                     +----------------------------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| types.go | `pkg/apis/admissionregistration/types.go` | ソース | ValidatingWebhookConfiguration内部API型定義 |
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | テーブルカラム定義・出力関数 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printValidatingWebhookのテストケース |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力 |
