# 帳票設計書 47-ValidatingAdmissionPolicy一覧

## 概要

本ドキュメントは、Kubernetes ValidatingAdmissionPolicyリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get validatingadmissionpolicies` コマンド実行時に、ValidatingAdmissionPolicyオブジェクトの情報を人間が読みやすいテーブル形式で標準出力へ出力する処理の仕様を定義する。

### 本帳票の処理概要

本帳票は、Kubernetes AdmissionRegistration APIグループに属するValidatingAdmissionPolicyリソースの一覧情報を、テーブル形式で整形して出力する機能を提供する。

**業務上の目的・背景**：ValidatingAdmissionPolicyは、CEL（Common Expression Language）を用いてインラインでAdmission検証ルールを定義できるリソースである。従来のValidatingWebhookConfigurationと異なり、外部Webhookサーバーを必要とせずにKubernetes API Server内で直接ポリシー評価が行われる。これにより、Webhook呼び出しのレイテンシーやWebhookサーバーの可用性に関する課題を解消できる。クラスタ管理者がポリシーの一覧と検証ルール数を把握するために必要となる。

**帳票の利用シーン**：ポリシー設定の確認、CELベースの検証ルールの管理状況確認、ポリシー適用のトラブルシューティング、新規ポリシー導入後の検証などの場面で利用される。

**主要な出力内容**：
1. ValidatingAdmissionPolicy名（Name）
2. 検証ルール数（Validations）
3. パラメータリソース種別（ParamKind）
4. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get validatingadmissionpolicies` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、セキュリティ管理者、SRE、プラットフォームエンジニア

## 帳票種別

一覧表（テーブル形式リソース一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get validatingadmissionpolicies` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字 |
| ヘッダー行 | あり（カラム名を大文字で表示） |
| 代替出力形式 | JSON / YAML / JSONPath / GoTemplate |

## 帳票レイアウト

### レイアウト概要

ValidatingAdmissionPolicyリソースの情報を4カラムのテーブル形式で出力する。

```
NAME                          VALIDATIONS   PARAMKIND                AGE
deny-privileged-containers    3             v1/ConfigMap             5d
require-labels                1             <unset>                  10d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | ValidatingAdmissionPolicy名 | ObjectMeta.Name | 文字列 |
| 2 | VALIDATIONS | 検証ルール数 | len(Spec.Validations) | 整数 |
| 3 | PARAMKIND | パラメータリソース種別 | Spec.ParamKind | APIVersion/Kind形式（未設定時: `<unset>`） |
| 4 | AGE | 作成からの経過時間 | ObjectMeta.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | string | 可変 |
| 2 | Validations | 検証ルール数 | int64(len(obj.Spec.Validations)) | integer | 可変 |
| 3 | ParamKind | パラメータ種別 | obj.Spec.ParamKind.APIVersion + "/" + obj.Spec.ParamKind.Kind | string | 可変 |
| 4 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | 相対時間文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ラベルセレクタ | `-l`フラグによるラベルフィルタリング | No |
| フィールドセレクタ | `--field-selector`フラグによるフィールドフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（デフォルト） |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ValidatingAdmissionPolicy（etcd） | リソース情報の取得 | API Serverへのリスト/取得リクエスト |

### テーブル別参照項目詳細

#### ValidatingAdmissionPolicy

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | NAME | クラスタ内の全ValidatingAdmissionPolicy | - |
| spec.validations | VALIDATIONS | - | 配列長をカウント |
| spec.paramKind.apiVersion | PARAMKIND | - | APIVersion部分 |
| spec.paramKind.kind | PARAMKIND | - | Kind部分 |
| metadata.creationTimestamp | AGE | - | 相対時間に変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Validations | int64(len(obj.Spec.Validations)) | N/A | Validations配列の要素数 |
| ParamKind表示文字列 | Spec.ParamKindがnilなら`<unset>`、それ以外はAPIVersion + "/" + Kind | N/A | - |
| Age | 現在時刻 - CreationTimestamp | N/A | translateTimestampSince関数 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get validatingadmissionpolicies 実行] --> B[GetOptions.Run]
    B --> C[API Serverへリスト要求]
    C --> D[ValidatingAdmissionPolicyList取得]
    D --> E[printValidatingAdmissionPolicyList呼び出し]
    E --> F[各ValidatingAdmissionPolicyをprintValidatingAdmissionPolicy処理]
    F --> G[ParamKindのnil判定]
    G --> H[TableRow生成]
    H --> I[HumanReadablePrinter.PrintObj]
    I --> J[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未検出 | クラスタにリソースが存在しない | `No resources found` | ポリシー設定の確認 |
| 権限不足 | RBAC権限が不足 | `Error from server (Forbidden): ...` | 適切なClusterRoleBinding設定 |
| API未対応 | APIバージョンが未対応 | `error: the server doesn't have a resource type ...` | Kubernetesバージョンの確認（v1.30+） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A（CLIツールのため） |

## セキュリティ考慮事項

ValidatingAdmissionPolicyはクラスタスコープのリソースであり、セキュリティポリシーの定義を含む。不正な変更・削除はセキュリティポリシーのバイパスにつながる。admissionregistration.k8s.io APIグループへの適切なRBAC権限設定が重要。

## 備考

- ValidatingAdmissionPolicyはKubernetes v1.30でGAとなった機能。
- CEL（Common Expression Language）を用いてインラインで検証ルールを定義可能。
- ParamKindが設定されている場合、外部パラメータリソースを参照してポリシーの動作をパラメータ化できる。
- ValidatingAdmissionPolicyBindingと組み合わせて使用する。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/admissionregistration/types.go` | ValidatingAdmissionPolicy構造体（132行目）: Spec.Validations, Spec.ParamKindフィールド |
| 1-2 | types.go | `pkg/apis/admissionregistration/types.go` | ValidatingAdmissionPolicySpec構造体: Validations（検証ルール配列）、ParamKind（パラメータ参照） |

**読解のコツ**: ParamKindはポインタ型であり、nil判定が必要。APIVersion + "/" + Kind形式で表示文字列を構築する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | Run関数（443行目） |

#### Step 3: テーブルカラム定義と出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | validatingAdmissionPolicyカラム定義（591-596行目）: Name, Validations, ParamKind, Ageの4カラム |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printValidatingAdmissionPolicy関数（1776-1786行目）: ParamKindのnil判定とAPIVersion/Kind結合 |
| 3-3 | printers.go | `pkg/printers/internalversion/printers.go` | printValidatingAdmissionPolicyList関数（1788-1798行目）: リスト処理 |

**主要処理フロー**:
- **1780-1783行目**: ParamKindがnilなら`<unset>`、それ以外はAPIVersion + "/" + Kind
- **1784行目**: `row.Cells = append(row.Cells, obj.Name, int64(len(obj.Spec.Validations)), paramKind, translateTimestampSince(obj.CreationTimestamp))`

### プログラム呼び出し階層図

```
kubectl get validatingadmissionpolicies
    |
    +-- NewCmdGet (get.go:161)
    |       |
    |       +-- GetOptions.Run (get.go:443)
    |               |
    |               +-- API Server リクエスト (ValidatingAdmissionPolicyList取得)
    |               |
    |               +-- HumanReadablePrinter.PrintObj
    |                       |
    |                       +-- printValidatingAdmissionPolicyList (printers.go:1788)
    |                               |
    |                               +-- printValidatingAdmissionPolicy (printers.go:1776)
    |                                       |
    |                                       +-- ParamKind nil判定
    |                                       +-- APIVersion + "/" + Kind 結合
    |                                       +-- len(Spec.Validations)
    |                                       +-- translateTimestampSince
```

### データフロー図

```
[入力]                          [処理]                                    [出力]

API Server                printValidatingAdmissionPolicyList          標準出力(stdout)
(etcd)               +------------------------------------------+
                     |                                          |
ValidatingAdmission  | printValidatingAdmissionPolicy            |    NAME  VALIDATIONS  PARAMKIND  AGE
Policy List -------->|   +- ParamKind nil ? "<unset>" :     -----|->  deny   3           v1/CM      5d
                     |       APIVersion+"/"+Kind                |
                     |   +- len(Spec.Validations)               |
                     |   +- translateTimestampSince              |
                     +------------------------------------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| types.go | `pkg/apis/admissionregistration/types.go` | ソース | ValidatingAdmissionPolicy内部API型定義 |
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | テーブルカラム定義・出力関数 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printValidatingAdmissionPolicyのテストケース |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力 |
