# 帳票設計書 48-ValidatingAdmissionPolicyBinding一覧

## 概要

本ドキュメントは、Kubernetes ValidatingAdmissionPolicyBindingリソースの一覧をテーブル形式で出力する帳票の設計書である。`kubectl get validatingadmissionpolicybindings` コマンド実行時に、ValidatingAdmissionPolicyBindingオブジェクトの情報を人間が読みやすいテーブル形式で標準出力へ出力する処理の仕様を定義する。

### 本帳票の処理概要

本帳票は、Kubernetes AdmissionRegistration APIグループに属するValidatingAdmissionPolicyBindingリソースの一覧情報を、テーブル形式で整形して出力する機能を提供する。

**業務上の目的・背景**：ValidatingAdmissionPolicyBindingは、ValidatingAdmissionPolicyをクラスタ内のリソースに紐づけ、ポリシーの適用範囲と適用パラメータを定義するリソースである。ポリシー定義（ValidatingAdmissionPolicy）と適用設定（Binding）を分離することで、同じポリシーを異なるパラメータで複数のリソースに適用できる柔軟性を提供する。クラスタ管理者がポリシーの適用状況を把握し、どのポリシーがどのパラメータで適用されているかを確認するために必要となる。

**帳票の利用シーン**：ポリシーの適用状況確認、ポリシーバインディングの管理、パラメータ参照の検証、ポリシー適用のトラブルシューティングなどの場面で利用される。

**主要な出力内容**：
1. ValidatingAdmissionPolicyBinding名（Name）
2. 紐づけポリシー名（PolicyName）
3. パラメータ参照（ParamRef）
4. 作成からの経過時間（Age）

**帳票の出力タイミング**：ユーザーが `kubectl get validatingadmissionpolicybindings` コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、セキュリティ管理者、SRE、プラットフォームエンジニア

## 帳票種別

一覧表（テーブル形式リソース一覧）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | ターミナル（CLI） | - | `kubectl get validatingadmissionpolicybindings` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字 |
| ヘッダー行 | あり（カラム名を大文字で表示） |
| 代替出力形式 | JSON / YAML / JSONPath / GoTemplate |

## 帳票レイアウト

### レイアウト概要

ValidatingAdmissionPolicyBindingリソースの情報を4カラムのテーブル形式で出力する。

```
NAME                                   POLICYNAME                      PARAMREF                  AGE
deny-privileged-binding                deny-privileged-containers      default/my-params         5d
require-labels-binding                 require-labels                  <unset>                   10d
selector-based-binding                 some-policy                     app=web                   3d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | NAME | Binding名 | ObjectMeta.Name | 文字列 |
| 2 | POLICYNAME | 紐づけポリシー名 | Spec.PolicyName | 文字列 |
| 3 | PARAMREF | パラメータ参照 | Spec.ParamRef | Namespace/Name形式またはSelector文字列（未設定時: `<unset>`） |
| 4 | AGE | 作成からの経過時間 | ObjectMeta.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | リソース名 | obj.Name | string | 可変 |
| 2 | PolicyName | ポリシー名 | obj.Spec.PolicyName | string | 可変 |
| 3 | ParamRef | パラメータ参照 | 下記計算仕様参照 | string | 可変 |
| 4 | Age | 経過時間 | translateTimestampSince(obj.CreationTimestamp) | 相対時間文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| ラベルセレクタ | `-l`フラグによるラベルフィルタリング | No |
| フィールドセレクタ | `--field-selector`フラグによるフィールドフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（デフォルト） |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| ValidatingAdmissionPolicyBinding（etcd） | リソース情報の取得 | API Serverへのリスト/取得リクエスト |

### テーブル別参照項目詳細

#### ValidatingAdmissionPolicyBinding

| 参照項目（カラム名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | NAME | クラスタ内の全ValidatingAdmissionPolicyBinding | - |
| spec.policyName | POLICYNAME | - | 紐づけ先のValidatingAdmissionPolicy名 |
| spec.paramRef.name | PARAMREF | - | パラメータリソース名 |
| spec.paramRef.namespace | PARAMREF | - | パラメータリソースのNamespace |
| spec.paramRef.selector | PARAMREF | name未設定時 | ラベルセレクタ文字列 |
| metadata.creationTimestamp | AGE | - | 相対時間に変換 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ParamRef表示文字列 | 下記条件分岐参照 | N/A | 複雑な条件分岐あり |
| Age | 現在時刻 - CreationTimestamp | N/A | translateTimestampSince関数 |

**ParamRef表示文字列の条件分岐**:
1. Spec.ParamRefがnil -> `<unset>`
2. ParamRef.Nameが設定されている場合:
   - Namespaceが設定されている -> `{Namespace}/{Name}`
   - Namespaceが未設定 -> `*/{Name}`（クラスタスコープの可能性）
3. ParamRef.Nameが未設定でSelectorが設定されている -> `Selector.String()`
4. 上記以外 -> `<unset>`

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get validatingadmissionpolicybindings 実行] --> B[GetOptions.Run]
    B --> C[API Serverへリスト要求]
    C --> D[ValidatingAdmissionPolicyBindingList取得]
    D --> E[printValidatingAdmissionPolicyBindingList呼び出し]
    E --> F[各Bindingをprint処理]
    F --> G[ParamRefの条件分岐処理]
    G --> H[TableRow生成]
    H --> I[HumanReadablePrinter.PrintObj]
    I --> J[テーブル形式で標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース未検出 | クラスタにリソースが存在しない | `No resources found` | バインディング設定の確認 |
| 権限不足 | RBAC権限が不足 | `Error from server (Forbidden): ...` | 適切なClusterRoleBinding設定 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A（CLIツールのため） |

## セキュリティ考慮事項

ValidatingAdmissionPolicyBindingはクラスタスコープのリソースであり、ポリシーの適用範囲を制御する。不正な変更・削除はポリシー適用の無効化につながる。admissionregistration.k8s.io APIグループへの適切なRBAC権限設定が重要。

## 備考

- ValidatingAdmissionPolicyBindingはクラスタスコープのリソース。
- ValidatingAdmissionPolicyと組み合わせて使用する。
- ParamRefのNamespace未設定時に`*/`プレフィックスが付与されるのは、クラスタスコープかどうかをprint関数内で判別できないための措置。

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/admissionregistration/types.go` | ValidatingAdmissionPolicyBinding構造体: Spec.PolicyName, Spec.ParamRefフィールド |

**読解のコツ**: ParamRefは複雑な条件分岐がある。Name, Namespace, Selectorの組み合わせによって表示が変わる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | Run関数（443行目） |

#### Step 3: テーブルカラム定義と出力処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | validatingAdmissionPolicyBindingカラム定義（600-605行目）: Name, PolicyName, ParamRef, Ageの4カラム |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | printValidatingAdmissionPolicyBinding関数（1800-1820行目）: ParamRefの複雑な条件分岐処理 |
| 3-3 | printers.go | `pkg/printers/internalversion/printers.go` | printValidatingAdmissionPolicyBindingList関数（1822-1832行目）: リスト処理 |

**主要処理フロー**:
- **1804行目**: paramName初期値`<unset>`
- **1805行目**: ParamRefのnil判定
- **1806-1813行目**: Nameが設定されている場合、Namespaceの有無で表示分岐
- **1814-1816行目**: Nameが未設定でSelectorが設定されている場合
- **1818行目**: `row.Cells = append(row.Cells, obj.Name, obj.Spec.PolicyName, paramName, translateTimestampSince(obj.CreationTimestamp))`

### プログラム呼び出し階層図

```
kubectl get validatingadmissionpolicybindings
    |
    +-- NewCmdGet (get.go:161)
    |       |
    |       +-- GetOptions.Run (get.go:443)
    |               |
    |               +-- API Server リクエスト (ValidatingAdmissionPolicyBindingList取得)
    |               |
    |               +-- HumanReadablePrinter.PrintObj
    |                       |
    |                       +-- printValidatingAdmissionPolicyBindingList (printers.go:1822)
    |                               |
    |                               +-- printValidatingAdmissionPolicyBinding (printers.go:1800)
    |                                       |
    |                                       +-- ParamRef nil判定
    |                                       +-- Name/Namespace/Selector条件分岐
    |                                       +-- translateTimestampSince
```

### データフロー図

```
[入力]                              [処理]                                        [出力]

API Server                    printValidatingAdmissionPolicyBindingList       標準出力(stdout)
(etcd)                   +------------------------------------------------+
                         |                                                |
ValidatingAdmission      | printValidatingAdmissionPolicyBinding           |    NAME  POLICYNAME  PARAMREF  AGE
PolicyBinding List ----->|   +- ParamRef nil判定                       ----|->  bind1  policy1    ns/param  5d
                         |   +- Name有: Namespace有 -> ns/name            |
                         |   +- Name有: Namespace無 -> */name             |
                         |   +- Name無: Selector有 -> selector.String()   |
                         |   +- translateTimestampSince                   |
                         +------------------------------------------------+
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| types.go | `pkg/apis/admissionregistration/types.go` | ソース | ValidatingAdmissionPolicyBinding内部API型定義 |
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | テーブルカラム定義・出力関数 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printValidatingAdmissionPolicyBindingのテストケース（7194行目, 7433行目） |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl getコマンドのエントリーポイント |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力 |
