# 帳票設計書 5-ReplicaSet一覧

## 概要

本ドキュメントは、Kubernetes の ReplicaSet リソース一覧をテーブル形式で標準出力に出力する帳票の設計を定義する。`kubectl get rs` コマンド実行時に使用される。

### 本帳票の処理概要

本帳票は、Kubernetes クラスタ上の ReplicaSet リソースの一覧情報を、テーブル形式で標準出力に表示する処理を行う。

**業務上の目的・背景**：ReplicaSet は Deployment の下位リソースとして Pod のレプリカ数を管理するコントローラである。Deployment による更新時に新旧の ReplicaSet が生成されるため、ローリングアップデートの進行状況を把握したり、過去のリビジョンを確認したりする場面で重要な帳票となる。Desired / Current / Ready の各レプリカ数を比較することでスケーリングの健全性を確認できる。

**帳票の利用シーン**：Deployment のローリングアップデート状況の確認、レプリカ数の監視、スケーリング結果の確認、過去リビジョンの ReplicaSet の確認。

**主要な出力内容**：
1. ReplicaSet 名（Name）
2. 希望レプリカ数（Desired）
3. 現在のレプリカ数（Current）
4. Ready 状態のレプリカ数（Ready）
5. 作成からの経過時間（Age）
6. Wide 出力時: コンテナ名、イメージ名、セレクタ

**帳票の出力タイミング**：ユーザが `kubectl get rs` または `kubectl get replicasets` コマンドを実行した際に出力される。

**帳票の利用者**：Kubernetes クラスタ管理者、アプリケーション開発者、SRE。

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | ターミナル（CLI） | N/A | `kubectl get rs [flags]` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 標準出力（テキスト / テーブル形式） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字（tabwriter） |
| ヘッダー表示 | デフォルト有効 |
| Wide 出力 | Containers, Images, Selector が追加（Priority=1） |

## 帳票レイアウト

### レイアウト概要

```
┌───────────────────────────────────────────────────────────┐
│  NAME          DESIRED   CURRENT   READY   AGE           │
├───────────────────────────────────────────────────────────┤
│  app-abc123    3         3         3       5d            │
│  app-def456    0         0         0       10d           │
└───────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | RS の名前 | `obj.ObjectMeta.Name` | 文字列（name フォーマット） |
| 2 | Desired | 希望レプリカ数 | `obj.Spec.Replicas` | 整数（int64） |
| 3 | Current | 現在のレプリカ数 | `obj.Status.Replicas` | 整数（int64） |
| 4 | Ready | Ready レプリカ数 | `obj.Status.ReadyReplicas` | 整数（int64） |
| 5 | Age | 経過時間 | `obj.ObjectMeta.CreationTimestamp` | `translateTimestampSince` |

### 明細部（Wide 出力時の追加カラム）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 6 | Containers | コンテナ名一覧 | `obj.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 7 | Images | イメージ名一覧 | `obj.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 8 | Selector | Pod セレクタ | `obj.Spec.Selector` | LabelSelector 文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象 Namespace | No |
| All Namespaces | 全 Namespace | No |
| Label Selector | ラベルフィルタ | No |
| Field Selector | フィールドフィルタ | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | RS 名（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: `/registry/replicasets/{namespace}/{name}` | RS オブジェクトの永続化ストア | N/A |

### テーブル別参照項目詳細

#### ReplicaSet リソース（API: `apps/v1/replicasets`）

| 参照項目（フィールド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | N/A | RS の名前 |
| `metadata.creationTimestamp` | Age | N/A | 経過時間に変換 |
| `spec.replicas` | Desired | N/A | int32 を int64 にキャスト |
| `status.replicas` | Current | N/A | int32 を int64 にキャスト |
| `status.readyReplicas` | Ready | N/A | int32 を int64 にキャスト |
| `spec.template.spec.containers` | Containers, Images (wide) | N/A | layoutContainerCells |
| `spec.selector` | Selector (wide) | N/A | metav1.FormatLabelSelector |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Desired | `int64(obj.Spec.Replicas)` | N/A | RC と異なり ptr.Deref は不使用 |
| Current | `int64(obj.Status.Replicas)` | N/A | |
| Ready | `int64(obj.Status.ReadyReplicas)` | N/A | |
| Containers/Images | `layoutContainerCells(obj.Spec.Template.Spec.Containers)` | N/A | |
| Selector | `metav1.FormatLabelSelector(obj.Spec.Selector)` | N/A | RC と異なり LabelSelector 型 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get rs 実行] --> B[API サーバへリクエスト]
    B --> C[RS リスト取得]
    C --> D[printReplicaSetList]
    D --> E[printReplicaSet で各行生成]
    E --> F[HumanReadablePrinter でテーブル出力]
    F --> G[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | RS が存在しない | `No resources found in {namespace} namespace.` | 条件見直し |
| API エラー | 接続失敗 | API エラーメッセージ | kubeconfig 確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数千件（Deployment 数に依存） |
| 目標出力時間 | 即時 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

- RS 一覧取得には `replicasets` リソース（apps グループ）の `list` / `get` 権限が必要

## 備考

- ReplicaSet は通常 Deployment により自動管理されるため、直接操作は非推奨
- RC と異なり、Spec.Replicas は直接 int64 にキャスト（ptr.Deref 不使用）
- Selector は RC の map[string]string ではなく metav1.LabelSelector 型を使用

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printers.go | `pkg/printers/internalversion/printers.go` | replicaSetColumnDefinitions（行 142-150）: Name, Desired, Current, Ready, Age + wide: Containers, Images, Selector |

**読解のコツ**: RC と同じカラム構成だが、Selector が `metav1.FormatLabelSelector` で整形される点が異なる。

#### Step 2: print 関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printReplicaSet`（行 1195-1210）: Spec.Replicas を直接 int64 にキャスト、Wide 時に FormatLabelSelector を使用 |
| 2-2 | printers.go | `pkg/printers/internalversion/printers.go` | `printReplicaSetList`（行 1212-1222）: Items を順に委譲 |

**主要処理フロー**:
- **行 1200**: `obj.Spec.Replicas` を直接取得（ptr.Deref 不使用）
- **行 1201-1202**: Status から Current, Ready を取得
- **行 1204**: Name, Desired(int64), Current(int64), Ready(int64), Age をセルに追加
- **行 1205-1208**: Wide 時にコンテナ情報と `metav1.FormatLabelSelector` でセレクタを追加

### プログラム呼び出し階層図

```
kubectl get rs
    |
    +-- GetOptions.Run() [get.go]
           |
           +-- API Server Request
           |       |
           |       +-- printReplicaSetList() [printers.go 行1212]
           |               |
           |               +-- printReplicaSet() [printers.go 行1195]
           |                       |
           |                       +-- layoutContainerCells() [printers.go 行2767]
           |                       +-- metav1.FormatLabelSelector()
           |
           +-- HumanReadablePrinter.PrintObj()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

API Server (etcd)          printReplicaSet()                  標準出力 (stdout)
  RS Object            --> - Replicas int64 キャスト        --> テーブル形式テキスト
  (apps.ReplicaSet)        - Status から Current/Ready          NAME DESIRED CURRENT ...
                           - layoutContainerCells (wide)        rs1  3       3       3  5d
                           - FormatLabelSelector (wide)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | RS 用カラム定義と print 関数（行 142-153, 1195-1222） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルレンダリング |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl get コマンドエントリーポイント |
