# 帳票設計書 51-FlowSchema一覧

## 概要

本ドキュメントは、KubernetesのFlowSchemaリソースをテーブル形式で一覧出力する帳票の設計書である。FlowSchemaはAPI Priority and Fairness（APF）機構において、受信APIリクエストをフロー（グループ）に分類するためのルールを定義するリソースであり、本帳票はその一覧表示を担う。

### 本帳票の処理概要

**業務上の目的・背景**：Kubernetesクラスタでは、APIサーバへのリクエスト流量を制御するためにAPI Priority and Fairness機構が導入されている。FlowSchemaはリクエストをどの優先度レベルに振り分けるかを定義するリソースであり、クラスタ管理者が現在の流量制御ルールを確認し、適切な設定が行われているかを検証するために本帳票が必要となる。

**帳票の利用シーン**：クラスタ管理者がAPIサーバのリクエスト振り分けルールを確認する際に`kubectl get flowschemas`コマンドを実行して利用する。特に、リクエストの優先度設定の見直しや、壊れたPriorityLevelConfigurationへの参照がないかを確認する場面で利用される。

**主要な出力内容**：
1. FlowSchema名
2. 参照先のPriorityLevel名
3. MatchingPrecedence（マッチング優先度）
4. DistinguisherMethod（識別方法）
5. リソースの経過時間（Age）
6. MissingPL（壊れたPriorityLevelConfiguration参照の有無）

**帳票の出力タイミング**：ユーザが`kubectl get flowschemas`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、プラットフォームエンジニア、SRE担当者。

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（kubectl） | - | `kubectl get flowschemas` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | 横 |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で各FlowSchemaリソースを1行ずつ出力する。カラムは固定6列で構成される。

```
NAME                  PRIORITYLEVEL   MATCHINGPRECEDENCE   DISTINGUISHERMETHOD   AGE   MISSINGPL
exempt                exempt          1                    <none>                10d   False
catch-all             catch-all       10000                ByUser                10d   False
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | FlowSchemaのリソース名 | obj.Name | 文字列 |
| 2 | PriorityLevel | 参照先のPriorityLevelConfiguration名 | obj.Spec.PriorityLevelConfiguration.Name | 文字列 |
| 3 | MatchingPrecedence | リクエストマッチングの優先度（数値が小さいほど優先） | obj.Spec.MatchingPrecedence | 整数 |
| 4 | DistinguisherMethod | フロー内の識別方法 | obj.Spec.DistinguisherMethod.Type | 文字列（nilの場合`<none>`） |
| 5 | Age | 作成からの経過時間 | obj.CreationTimestamp | 相対時間（例: 10d） |
| 6 | MissingPL | 壊れたPL参照の有無 | obj.Status.Conditions（FlowSchemaConditionDangling） | 文字列（True/False/?） |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | 各FlowSchemaの名前 | obj.Name | 文字列 | 可変 |
| 2 | PriorityLevel | 各FlowSchemaの優先度レベル | obj.Spec.PriorityLevelConfiguration.Name | 文字列 | 可変 |
| 3 | MatchingPrecedence | マッチング優先度 | obj.Spec.MatchingPrecedence | int64 | 可変 |
| 4 | DistinguisherMethod | 識別方法タイプ | obj.Spec.DistinguisherMethod | 文字列 | 可変 |
| 5 | Age | 経過時間 | obj.CreationTimestamp | 相対時間 | 可変 |
| 6 | MissingPL | PL参照ステータス | obj.Status.Conditions | 文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | FlowSchemaはクラスタスコープのため、Namespace指定は不要 | No |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | FlowSchemaSequence（MatchingPrecedence+Name） | 昇順 |

### 改ページ条件

ターミナル出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/flowschemas/ | FlowSchemaリソースの格納先 | リソース名で直接アクセス |

### テーブル別参照項目詳細

#### FlowSchema

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| spec.priorityLevelConfiguration.name | PriorityLevel | - | - |
| spec.matchingPrecedence | MatchingPrecedence | - | int32をint64にキャスト |
| spec.distinguisherMethod.type | DistinguisherMethod | - | nilの場合`<none>` |
| metadata.creationTimestamp | Age | - | translateTimestampSinceで相対時間化 |
| status.conditions | MissingPL | type == FlowSchemaConditionDangling | conditionのStatusを表示 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | 現在時刻 - CreationTimestamp | - | duration.HumanDurationで人間可読形式に変換 |
| MissingPL | Status.ConditionsからDanglingタイプを検索 | - | 見つからない場合は`?`を表示 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get flowschemas] --> B[APIサーバからFlowSchemaList取得]
    B --> C[FlowSchemaSequenceでソート]
    C --> D[各FlowSchemaに対してprintFlowSchema呼び出し]
    D --> E[TableRow生成]
    E --> F[HumanReadablePrinter.PrintObjでテーブル出力]
    F --> G[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | FlowSchemaが存在しない | `No resources found` | - |
| API接続エラー | APIサーバへの接続失敗 | 接続エラーメッセージ | kubeconfigの確認 |
| 権限エラー | FlowSchemaのlist権限がない | `Forbidden` | RBACの設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十件（システムデフォルトで約10件程度） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

FlowSchemaはクラスタ全体のリクエスト制御ルールを含むため、参照にはcluster-admin相当の権限が必要。出力内容に機密情報は含まれないが、クラスタのリクエスト制御設計が露出する可能性がある。

## 備考

- FlowSchemaリストはMatchingPrecedenceとNameの組み合わせ（FlowSchemaSequence）でソートされる（printers.go 3003-3007行目）
- MissingPLカラムは、参照先のPriorityLevelConfigurationが存在しない場合に`True`を表示し、問題の早期発見を支援する

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

FlowSchemaリソースの内部表現と、テーブル出力に使われるカラム定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/flowcontrol/types.go` | FlowSchema, FlowSchemaSpec, FlowSchemaStatus, FlowSchemaConditionの構造体定義 |
| 1-2 | printers.go | `pkg/printers/internalversion/printers.go` | 627-636行目: flowSchemaColumnDefinitionsの定義。6カラム（Name, PriorityLevel, MatchingPrecedence, DistinguisherMethod, Age, MissingPL）の定義を確認 |

**読解のコツ**: flowcontrolv1パッケージのSwaggerDocメソッドがカラムの説明文を提供している。内部APIバージョンとv1バージョンの両方を参照すること。

#### Step 2: エントリーポイントを理解する

AddHandlers関数でテーブルハンドラが登録される仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 93行目: AddHandlers関数。PrintHandlerインタフェースにTableHandlerを登録するエントリーポイント |
| 2-2 | tablegenerator.go | `pkg/printers/tablegenerator.go` | 125行目: TableHandler関数。カラム定義と印刷関数を関連付ける |

**主要処理フロー**:
1. **93行目**: AddHandlers関数が呼ばれる
2. **635-636行目**: flowSchemaColumnDefinitionsとprintFlowSchema/printFlowSchemaList関数がTableHandlerとして登録

#### Step 3: 印刷処理を理解する

printFlowSchema関数とprintFlowSchemaList関数の実装を読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | 2978-2999行目: printFlowSchema関数。単一FlowSchemaからTableRowを生成。DistinguisherMethodのnil判定、Status.ConditionsからDanglingの検出ロジックを確認 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | 3001-3016行目: printFlowSchemaList関数。FlowSchemaSequenceによるソート処理を確認 |

**主要処理フロー**:
- **2983行目**: obj.Nameを取得
- **2984行目**: obj.Spec.PriorityLevelConfiguration.Nameを取得
- **2985-2988行目**: DistinguisherMethodがnilなら`<none>`、そうでなければTypeを使用
- **2989-2995行目**: Status.ConditionsからFlowSchemaConditionDanglingを検索し、badPLRefを設定
- **2996行目**: TableRow.Cellsに全カラム値を追加
- **3003-3007行目**: リスト出力時にFlowSchemaSequenceでソート

### プログラム呼び出し階層図

```
AddHandlers (printers.go:93)
    |
    +-- h.TableHandler(flowSchemaColumnDefinitions, printFlowSchema) (printers.go:635)
    +-- h.TableHandler(flowSchemaColumnDefinitions, printFlowSchemaList) (printers.go:636)
            |
            +-- sort.Sort(FlowSchemaSequence) (printers.go:3007)
            +-- printFlowSchema (printers.go:2978)
                    |
                    +-- translateTimestampSince (printers.go内共通関数)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

FlowSchema              printFlowSchema()                   TableRow
(etcd経由API取得)  --->  Name, PriorityLevel,           ---> (HumanReadablePrinter
                         MatchingPrecedence,                   によりテーブル形式で
                         DistinguisherMethod,                   stdoutへ出力)
                         Age, MissingPL を抽出

FlowSchemaList   --->   printFlowSchemaList()           ---> []TableRow
                         FlowSchemaSequenceでソート後
                         各要素にprintFlowSchemaを適用
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | FlowSchemaのテーブル出力ロジック本体（627-636, 2978-3016行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | TableHandler登録・TableRow生成の共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル整形出力 |
| types.go | `pkg/apis/flowcontrol/types.go` | ソース | FlowSchema内部API型定義 |
| util.go | `pkg/apis/flowcontrol/util/` | ソース | FlowSchemaSequence型（ソート用） |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | FlowSchemaテーブル出力のテストケース |
