# 帳票設計書 52-PriorityLevelConfiguration一覧

## 概要

本ドキュメントは、KubernetesのPriorityLevelConfigurationリソースをテーブル形式で一覧出力する帳票の設計書である。PriorityLevelConfigurationはAPI Priority and Fairness（APF）機構において、リクエストの優先度レベルとキューイング設定を定義するリソースであり、本帳票はその一覧表示を担う。

### 本帳票の処理概要

**業務上の目的・背景**：KubernetesクラスタのAPIサーバは、API Priority and Fairness機構によりリクエストの優先度制御を行う。PriorityLevelConfigurationは各優先度レベルの同時実行数やキューイングパラメータを定義するリソースであり、クラスタ管理者がAPIリクエストの優先度制御設定を把握し、適切なリソース配分が行われているかを確認するために本帳票が必要となる。

**帳票の利用シーン**：クラスタ管理者がAPIサーバの優先度レベル設定を確認する際に`kubectl get prioritylevelconfigurations`コマンドを実行して利用する。特に、同時実行数シェアやキューイング設定の確認・調整を行う場面で利用される。

**主要な出力内容**：
1. PriorityLevelConfiguration名
2. Type（Exempt/Limited）
3. NominalConcurrencyShares（名目同時実行シェア数）
4. Queues（キュー数）
5. HandSize（ハンドサイズ）
6. QueueLengthLimit（キュー長制限）
7. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザが`kubectl get prioritylevelconfigurations`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、プラットフォームエンジニア、SRE担当者。

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（kubectl） | - | `kubectl get prioritylevelconfigurations` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | 横 |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で各PriorityLevelConfigurationリソースを1行ずつ出力する。カラムは固定7列で構成される。

```
NAME        TYPE      NOMINALCONCURRENCYSHARES   QUEUES   HANDSIZE   QUEUELENGTHLIMIT   AGE
exempt      Exempt    <none>                     <none>   <none>     <none>              10d
workload    Limited   30                         64       6          50                  10d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | PriorityLevelConfigurationのリソース名 | obj.Name | 文字列 |
| 2 | Type | 優先度レベルタイプ（Exempt/Limited） | obj.Spec.Type | 文字列 |
| 3 | NominalConcurrencyShares | 名目同時実行シェア数 | obj.Spec.Limited.NominalConcurrencyShares | 整数（Limitedがnilの場合`<none>`） |
| 4 | Queues | キュー数 | obj.Spec.Limited.LimitResponse.Queuing.Queues | 整数（nilの場合`<none>`） |
| 5 | HandSize | ハンドサイズ | obj.Spec.Limited.LimitResponse.Queuing.HandSize | 整数（nilの場合`<none>`） |
| 6 | QueueLengthLimit | キュー長制限 | obj.Spec.Limited.LimitResponse.Queuing.QueueLengthLimit | 整数（nilの場合`<none>`） |
| 7 | Age | 作成からの経過時間 | obj.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | 各PriorityLevelConfigurationの名前 | obj.Name | 文字列 | 可変 |
| 2 | Type | タイプ | obj.Spec.Type | 文字列 | 可変 |
| 3 | NominalConcurrencyShares | シェア数 | obj.Spec.Limited | 整数/文字列 | 可変 |
| 4 | Queues | キュー数 | obj.Spec.Limited.LimitResponse.Queuing | 整数/文字列 | 可変 |
| 5 | HandSize | ハンドサイズ | obj.Spec.Limited.LimitResponse.Queuing | 整数/文字列 | 可変 |
| 6 | QueueLengthLimit | キュー長 | obj.Spec.Limited.LimitResponse.Queuing | 整数/文字列 | 可変 |
| 7 | Age | 経過時間 | obj.CreationTimestamp | 相対時間 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | PriorityLevelConfigurationはクラスタスコープのため、Namespace指定は不要 | No |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | リスト取得順（APIサーバ返却順） | - |

### 改ページ条件

ターミナル出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/prioritylevelconfigurations/ | PriorityLevelConfigurationリソースの格納先 | リソース名で直接アクセス |

### テーブル別参照項目詳細

#### PriorityLevelConfiguration

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| spec.type | Type | - | string(obj.Spec.Type)でキャスト |
| spec.limited.nominalConcurrencyShares | NominalConcurrencyShares | - | Limitedがnilの場合`<none>` |
| spec.limited.limitResponse.queuing.queues | Queues | - | Queuingがnilの場合`<none>` |
| spec.limited.limitResponse.queuing.handSize | HandSize | - | Queuingがnilの場合`<none>` |
| spec.limited.limitResponse.queuing.queueLengthLimit | QueueLengthLimit | - | Queuingがnilの場合`<none>` |
| metadata.creationTimestamp | Age | - | translateTimestampSinceで相対時間化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | 現在時刻 - CreationTimestamp | - | duration.HumanDurationで人間可読形式に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get prioritylevelconfigurations] --> B[APIサーバからPriorityLevelConfigurationList取得]
    B --> C[各PriorityLevelConfigurationに対してprintPriorityLevelConfiguration呼び出し]
    C --> D[Spec.Limitedのnil判定]
    D --> E{Limited != nil?}
    E -->|Yes| F[NominalConcurrencySharesとQueuing設定を取得]
    E -->|No| G[全てのLimited項目を<none>に設定]
    F --> H[TableRow生成]
    G --> H
    H --> I[HumanReadablePrinter.PrintObjでテーブル出力]
    I --> J[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | PriorityLevelConfigurationが存在しない | `No resources found` | - |
| API接続エラー | APIサーバへの接続失敗 | 接続エラーメッセージ | kubeconfigの確認 |
| 権限エラー | PriorityLevelConfigurationのlist権限がない | `Forbidden` | RBACの設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜十数件（システムデフォルトで約10件程度） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

PriorityLevelConfigurationはクラスタ全体のリクエスト優先度制御設定を含むため、参照にはcluster-admin相当の権限が推奨される。出力内容にはキューイング設定パラメータが含まれるが、直接的な機密情報は含まれない。

## 備考

- TypeがExemptの場合、Limited関連のフィールド（NominalConcurrencyShares, Queues, HandSize, QueueLengthLimit）は全て`<none>`で表示される
- TypeがLimitedでもLimitResponse.Queuingがnilの場合（Reject戦略の場合）、キュー関連フィールドは`<none>`で表示される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

PriorityLevelConfigurationリソースの内部表現とキューイング設定の構造を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/flowcontrol/types.go` | PriorityLevelConfiguration, PriorityLevelConfigurationSpec, LimitedPriorityLevelConfiguration, QueuingConfigurationの構造体定義 |
| 1-2 | printers.go | `pkg/printers/internalversion/printers.go` | 638-648行目: priorityLevelColumnDefinitionsの定義。7カラムの定義を確認 |

**読解のコツ**: PriorityLevelConfigurationのSpec構造は階層が深い（Spec -> Limited -> LimitResponse -> Queuing）。nilチェックの階層を意識して読むこと。

#### Step 2: エントリーポイントを理解する

AddHandlers関数でテーブルハンドラが登録される仕組みを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 93行目: AddHandlers関数 |
| 2-2 | printers.go | `pkg/printers/internalversion/printers.go` | 647-648行目: printPriorityLevelConfiguration/printPriorityLevelConfigurationListの登録 |

**主要処理フロー**:
1. **93行目**: AddHandlers関数が呼ばれる
2. **647-648行目**: priorityLevelColumnDefinitionsとprint関数がTableHandlerとして登録

#### Step 3: 印刷処理を理解する

printPriorityLevelConfiguration関数の実装を読む。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3058-3078行目: printPriorityLevelConfiguration関数。Spec.Limitedのnil判定、Queuing設定の取得ロジック |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | 3080-3090行目: printPriorityLevelConfigurationList関数 |

**主要処理フロー**:
- **3062行目**: obj.Nameを取得
- **3063-3066行目**: ncs, queues, handSize, queueLengthLimitの初期値を`<none>`に設定
- **3067行目**: Spec.Limitedがnilでない場合のみ値を上書き
- **3068行目**: NominalConcurrencySharesを取得
- **3069行目**: LimitResponse.Queuingがnilでない場合のみキュー設定を取得
- **3075行目**: TableRow.Cellsに全カラム値を追加

### プログラム呼び出し階層図

```
AddHandlers (printers.go:93)
    |
    +-- h.TableHandler(priorityLevelColumnDefinitions, printPriorityLevelConfiguration) (printers.go:647)
    +-- h.TableHandler(priorityLevelColumnDefinitions, printPriorityLevelConfigurationList) (printers.go:648)
            |
            +-- printPriorityLevelConfiguration (printers.go:3058)
                    |
                    +-- translateTimestampSince (printers.go内共通関数)
```

### データフロー図

```
[入力]                              [処理]                                    [出力]

PriorityLevelConfiguration   printPriorityLevelConfiguration()          TableRow
(etcd経由API取得)        --> Name, Type取得                          --> (HumanReadablePrinter
                              Spec.Limited nil判定                        によりテーブル形式で
                              -> nil: 全項目<none>                        stdoutへ出力)
                              -> not nil: NCS取得
                                 Queuing nil判定
                                 -> nil: キュー項目<none>
                                 -> not nil: Queues,HandSize,
                                    QueueLengthLimit取得
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | PriorityLevelConfigurationのテーブル出力ロジック本体（638-648, 3058-3090行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | TableHandler登録・TableRow生成の共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル整形出力 |
| types.go | `pkg/apis/flowcontrol/types.go` | ソース | PriorityLevelConfiguration内部API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | PriorityLevelConfigurationテーブル出力のテストケース |
