# 帳票設計書 53-StorageVersion一覧

## 概要

本ドキュメントは、KubernetesのStorageVersionリソースをテーブル形式で一覧出力する帳票の設計書である。StorageVersionはKubernetesのAPIサーバ内部で使用されるリソースで、各APIリソースのストレージエンコーディングバージョンを追跡する。本帳票はその一覧表示を担う。

### 本帳票の処理概要

**業務上の目的・背景**：Kubernetesクラスタでは複数のAPIサーバが稼働する場合があり、各サーバがリソースをetcdに保存する際のエンコーディングバージョンが異なる可能性がある。StorageVersionリソースは各APIサーバが使用するストレージバージョンを記録し、クラスタ全体で一貫したストレージバージョンが使われているかを監視するために必要となる。

**帳票の利用シーン**：クラスタ管理者がストレージバージョンの一貫性を確認する際に`kubectl get storageversions`コマンドを実行して利用する。特に、APIサーバのアップグレード時やストレージマイグレーション時に、各サーバのエンコーディングバージョンを確認する場面で利用される。

**主要な出力内容**：
1. StorageVersion名
2. CommonEncodingVersion（共通エンコーディングバージョン）
3. StorageVersions（各APIサーバのストレージバージョン）
4. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザが`kubectl get storageversions`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、プラットフォームエンジニア。

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（kubectl） | - | `kubectl get storageversions` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | 横 |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で各StorageVersionリソースを1行ずつ出力する。カラムは固定4列で構成される。

```
NAME                      COMMONENCODINGVERSION   STORAGEVERSIONS                          AGE
apps.deployments          apps/v1                 server1=apps/v1,server2=apps/v1          10d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | StorageVersionのリソース名 | obj.Name | 文字列 |
| 2 | CommonEncodingVersion | 全APIサーバで共通のエンコーディングバージョン | obj.Status.CommonEncodingVersion | 文字列（nilの場合`<unset>`） |
| 3 | StorageVersions | 各APIサーバのストレージバージョン一覧 | obj.Status.StorageVersions | `serverID=version`形式のカンマ区切り（最大3件、以降は省略表示） |
| 4 | Age | 作成からの経過時間 | obj.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | 各StorageVersionの名前 | obj.Name | 文字列 | 可変 |
| 2 | CommonEncodingVersion | 共通バージョン | obj.Status.CommonEncodingVersion | 文字列 | 可変 |
| 3 | StorageVersions | サーバ別バージョン一覧 | obj.Status.StorageVersions | 文字列 | 可変 |
| 4 | Age | 経過時間 | obj.CreationTimestamp | 相対時間 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | StorageVersionはクラスタスコープのため、Namespace指定は不要 | No |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | リスト取得順（APIサーバ返却順） | - |

### 改ページ条件

ターミナル出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/storageversions/ | StorageVersionリソースの格納先 | リソース名で直接アクセス |

### テーブル別参照項目詳細

#### StorageVersion

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| status.commonEncodingVersion | CommonEncodingVersion | - | nilの場合`<unset>` |
| status.storageVersions | StorageVersions | - | formatStorageVersionsで整形（最大3件表示） |
| metadata.creationTimestamp | Age | - | translateTimestampSinceで相対時間化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | 現在時刻 - CreationTimestamp | - | duration.HumanDurationで人間可読形式に変換 |
| StorageVersions表示 | 各ServerStorageVersionを`{APIServerID}={EncodingVersion}`形式で結合 | - | 最大3件まで表示。4件以上の場合は`(+N more)`を付加 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get storageversions] --> B[APIサーバからStorageVersionList取得]
    B --> C[各StorageVersionに対してprintStorageVersion呼び出し]
    C --> D[CommonEncodingVersionのnil判定]
    D --> E{CommonEncodingVersion != nil?}
    E -->|Yes| F[CommonEncodingVersionの値を使用]
    E -->|No| G[<unset>を設定]
    F --> H[formatStorageVersionsでStorageVersions整形]
    G --> H
    H --> I[TableRow生成]
    I --> J[HumanReadablePrinter.PrintObjでテーブル出力]
    J --> K[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | StorageVersionが存在しない | `No resources found` | - |
| API接続エラー | APIサーバへの接続失敗 | 接続エラーメッセージ | kubeconfigの確認 |
| 権限エラー | StorageVersionのlist権限がない | `Forbidden` | RBACの設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十件〜数百件（APIリソースの種類数に依存） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

StorageVersionはクラスタ内部のストレージエンコーディング情報を含むため、参照にはcluster-admin相当の権限が推奨される。出力内容にはAPIサーバIDとエンコーディングバージョン情報が含まれるが、直接的な機密情報は含まれない。

## 備考

- StorageVersionsカラムは最大3件のAPIサーバ情報を表示し、4件以上の場合は`(+N more)`で省略表示される（formatStorageVersions関数、printers.go 3030-3044行目）
- CommonEncodingVersionがnilの場合は、各APIサーバで異なるエンコーディングバージョンが使用されていることを示す

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

StorageVersionリソースの内部表現を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/apiserverinternal/types.go` | StorageVersion, StorageVersionStatus, ServerStorageVersionの構造体定義 |
| 1-2 | printers.go | `pkg/printers/internalversion/printers.go` | 650-657行目: storageVersionColumnDefinitionsの定義。4カラムの定義を確認 |

**読解のコツ**: StorageVersionはStatus.StorageVersionsに各APIサーバ情報を配列で保持し、Status.CommonEncodingVersionは全サーバ共通のバージョンをポインタで保持する。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 656-657行目: printStorageVersion/printStorageVersionListの登録 |

**主要処理フロー**:
1. **656行目**: storageVersionColumnDefinitionsとprintStorageVersion関数がTableHandlerとして登録
2. **657行目**: storageVersionColumnDefinitionsとprintStorageVersionList関数がTableHandlerとして登録

#### Step 3: 印刷処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3018-3028行目: printStorageVersion関数。CommonEncodingVersionのnil判定、formatStorageVersions呼び出し |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | 3030-3044行目: formatStorageVersions関数。最大3件の`APIServerID=EncodingVersion`形式整形 |

**主要処理フロー**:
- **3022-3025行目**: CommonEncodingVersionがnilなら`<unset>`、そうでなければポインタの値を使用
- **3026行目**: formatStorageVersions関数でStorageVersionsを整形しTableRowに追加
- **3031-3043行目**: 最大3件まで`serverID=version`を表示、4件以上は`(+N more)`を付加

### プログラム呼び出し階層図

```
AddHandlers (printers.go:93)
    |
    +-- h.TableHandler(storageVersionColumnDefinitions, printStorageVersion) (printers.go:656)
    +-- h.TableHandler(storageVersionColumnDefinitions, printStorageVersionList) (printers.go:657)
            |
            +-- printStorageVersion (printers.go:3018)
                    |
                    +-- formatStorageVersions (printers.go:3030)
                    |       |
                    |       +-- listWithMoreString (printers.go内共通関数)
                    |
                    +-- translateTimestampSince (printers.go内共通関数)
```

### データフロー図

```
[入力]                          [処理]                              [出力]

StorageVersion            printStorageVersion()                TableRow
(etcd経由API取得)  --->   Name取得                          ---> (HumanReadablePrinter
                           CommonEncodingVersion nil判定           によりテーブル形式で
                           formatStorageVersions()                 stdoutへ出力)
                             max3件のserverID=version形式
                             4件以上は(+N more)付加
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | StorageVersionのテーブル出力ロジック本体（650-657, 3018-3056行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | TableHandler登録・TableRow生成の共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル整形出力 |
| types.go | `pkg/apis/apiserverinternal/types.go` | ソース | StorageVersion内部API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | StorageVersionテーブル出力のテストケース |
