# 帳票設計書 54-Scale出力

## 概要

本ドキュメントは、KubernetesのScaleリソースの情報をテーブル形式で出力する帳票の設計書である。Scaleはリソースのレプリカ数を管理するためのサブリソースであり、本帳票はその表示を担う。

### 本帳票の処理概要

**業務上の目的・背景**：Kubernetesでは、Deployment、ReplicaSet、StatefulSetなどのワークロードリソースにスケーリング機能が提供されている。Scaleサブリソースは、これらのリソースの希望レプリカ数と実際に利用可能なレプリカ数を管理する。本帳票は、スケーリング操作の結果やワークロードのスケール状態を確認するために必要となる。

**帳票の利用シーン**：クラスタ管理者がワークロードのスケール状態を確認する際に`kubectl get scale`コマンドを実行して利用する。特に、オートスケーリングの動作確認やスケールアウト/スケールインの結果確認の場面で利用される。

**主要な出力内容**：
1. リソース名（Name）
2. 希望レプリカ数（Desired）
3. 利用可能レプリカ数（Available）
4. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザが`kubectl get scale`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、アプリケーション開発者、SRE担当者。

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（kubectl） | - | `kubectl get scale` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | 横 |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式でScaleリソースの情報を1行で出力する。カラムは固定4列で構成される。

```
NAME          DESIRED   AVAILABLE   AGE
my-deploy     3         3           10d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | Scaleリソースの名前 | obj.Name | 文字列 |
| 2 | Desired | 希望レプリカ数 | obj.Spec.Replicas | 整数（int64） |
| 3 | Available | 利用可能なレプリカ数 | obj.Status.Replicas | 整数（int64） |
| 4 | Age | 作成からの経過時間 | obj.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | 対象リソースの名前 | obj.Name | 文字列 | 可変 |
| 2 | Desired | 希望レプリカ数 | obj.Spec.Replicas | int64 | 可変 |
| 3 | Available | 利用可能レプリカ数 | obj.Status.Replicas | int64 | 可変 |
| 4 | Age | 経過時間 | obj.CreationTimestamp | 相対時間 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| 対象リソース | スケール対象のリソース（Deployment, ReplicaSet等） | Yes |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | 単一リソースのため該当なし | - |

### 改ページ条件

ターミナル出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| 対象リソースのScaleサブリソース | Scaleリソース情報の取得 | /scale エンドポイント経由 |

### テーブル別参照項目詳細

#### Scale

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| spec.replicas | Desired | - | int32をint64にキャスト |
| status.replicas | Available | - | int32をint64にキャスト |
| metadata.creationTimestamp | Age | - | translateTimestampSinceで相対時間化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | 現在時刻 - CreationTimestamp | - | duration.HumanDurationで人間可読形式に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get scale] --> B[対象リソースのScaleサブリソース取得]
    B --> C[printScale呼び出し]
    C --> D[TableRow生成]
    D --> E[HumanReadablePrinter.PrintObjでテーブル出力]
    E --> F[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| リソース不存在 | 対象リソースが存在しない | `NotFound` | リソース名の確認 |
| API接続エラー | APIサーバへの接続失敗 | 接続エラーメッセージ | kubeconfigの確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件（単一リソースのScaleサブリソース） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

Scale情報にはレプリカ数の情報のみが含まれ、機密性は低い。ただし、スケール操作の権限管理は対象リソースのRBAC設定に準じる。

## 備考

- ScaleはサブリソースであるためList操作は存在せず、printScaleList関数は定義されていない
- Desired（Spec.Replicas）とAvailable（Status.Replicas）はともにint32からint64にキャストされて出力される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

Scaleリソースの内部表現を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/autoscaling/types.go` | Scale, ScaleSpec, ScaleStatusの構造体定義 |
| 1-2 | printers.go | `pkg/printers/internalversion/printers.go` | 659-665行目: scaleColumnDefinitionsの定義。4カラム（Name, Desired, Available, Age）の定義を確認 |

**読解のコツ**: Scaleはautoscalingパッケージに定義されているが、Deployment等の多くのリソースのサブリソースとして利用される。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 665行目: printScale関数のみが登録される（List関数は存在しない） |

**主要処理フロー**:
1. **665行目**: scaleColumnDefinitionsとprintScale関数がTableHandlerとして登録

#### Step 3: 印刷処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3149-3155行目: printScale関数。Spec.ReplicasとStatus.Replicasのint64キャスト |

**主要処理フロー**:
- **3153行目**: obj.Name, int64(obj.Spec.Replicas), int64(obj.Status.Replicas), Age をTableRowに追加

### プログラム呼び出し階層図

```
AddHandlers (printers.go:93)
    |
    +-- h.TableHandler(scaleColumnDefinitions, printScale) (printers.go:665)
            |
            +-- printScale (printers.go:3149)
                    |
                    +-- translateTimestampSince (printers.go内共通関数)
```

### データフロー図

```
[入力]                    [処理]                    [出力]

Scale               printScale()               TableRow
(APIサブリソース)  --> Name, Desired,         --> (HumanReadablePrinter
                      Available, Age抽出          によりテーブル形式で
                                                  stdoutへ出力)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | Scaleのテーブル出力ロジック本体（659-665, 3149-3155行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | TableHandler登録・TableRow生成の共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル整形出力 |
| types.go | `pkg/apis/autoscaling/types.go` | ソース | Scale内部API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | Scaleテーブル出力のテストケース |
