# 帳票設計書 55-DeviceClass一覧

## 概要

本ドキュメントは、KubernetesのDeviceClassリソースをテーブル形式で一覧出力する帳票の設計書である。DeviceClassはDynamic Resource Allocation（DRA）機構においてデバイスの分類を定義するリソースであり、本帳票はその一覧表示を担う。

### 本帳票の処理概要

**業務上の目的・背景**：KubernetesのDynamic Resource Allocation機能では、GPU、FPGA、ネットワークデバイスなどの特殊なハードウェアリソースを動的に割り当てることができる。DeviceClassはこれらのデバイスの分類を定義し、デバイスの選択条件や設定を抽象化する。クラスタ管理者がどのようなデバイスクラスが定義されているかを確認するために本帳票が必要となる。

**帳票の利用シーン**：クラスタ管理者がクラスタに定義されたデバイスクラスを確認する際に`kubectl get deviceclasses`コマンドを実行して利用する。デバイスの割り当て設定の確認やトラブルシューティングの場面で利用される。

**主要な出力内容**：
1. DeviceClass名
2. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザが`kubectl get deviceclasses`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、プラットフォームエンジニア。

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（kubectl） | - | `kubectl get deviceclasses` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | 横 |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で各DeviceClassリソースを1行ずつ出力する。カラムは固定2列のシンプルな構成である。

```
NAME        AGE
gpu-class   10d
fpga-class  5d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | DeviceClassのリソース名 | obj.Name | 文字列 |
| 2 | Age | 作成からの経過時間 | obj.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | 各DeviceClassの名前 | obj.Name | 文字列 | 可変 |
| 2 | Age | 経過時間 | obj.CreationTimestamp | 相対時間 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | DeviceClassはクラスタスコープのため、Namespace指定は不要 | No |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | リスト取得順（APIサーバ返却順） | - |

### 改ページ条件

ターミナル出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/deviceclasses/ | DeviceClassリソースの格納先 | リソース名で直接アクセス |

### テーブル別参照項目詳細

#### DeviceClass

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| metadata.creationTimestamp | Age | - | translateTimestampSinceで相対時間化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | 現在時刻 - CreationTimestamp | - | duration.HumanDurationで人間可読形式に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get deviceclasses] --> B[APIサーバからDeviceClassList取得]
    B --> C[各DeviceClassに対してprintDeviceClass呼び出し]
    C --> D[TableRow生成]
    D --> E[HumanReadablePrinter.PrintObjでテーブル出力]
    E --> F[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | DeviceClassが存在しない | `No resources found` | - |
| API接続エラー | APIサーバへの接続失敗 | 接続エラーメッセージ | kubeconfigの確認 |
| 権限エラー | DeviceClassのlist権限がない | `Forbidden` | RBACの設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

DeviceClassはクラスタスコープのリソースであるため、参照にはcluster-admin相当の権限が推奨される。出力内容にはデバイス名のみが含まれ、機密情報は含まれない。

## 備考

- DeviceClassのテーブル出力はNameとAgeの2カラムのみで、非常にシンプルな構成である
- DeviceClassの詳細な設定（デバイス選択条件、設定パラメータ等）はdescribeコマンドやYAML/JSON出力で確認する必要がある

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

DeviceClassリソースの内部表現を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/resource/types.go` | DeviceClass, DeviceClassListの構造体定義 |
| 1-2 | printers.go | `pkg/printers/internalversion/printers.go` | 667-672行目: deviceClassColumnDefinitionsの定義。2カラム（Name, Age）の定義を確認 |

**読解のコツ**: DeviceClassはresourceパッケージに定義されている。テーブル出力はシンプルだが、Specには複雑なデバイス選択条件が含まれる場合がある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 671-672行目: printDeviceClass/printDeviceClassListの登録 |

**主要処理フロー**:
1. **671行目**: deviceClassColumnDefinitionsとprintDeviceClass関数がTableHandlerとして登録
2. **672行目**: deviceClassColumnDefinitionsとprintDeviceClassList関数がTableHandlerとして登録

#### Step 3: 印刷処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3157-3164行目: printDeviceClass関数 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | 3166-3176行目: printDeviceClassList関数 |

**主要処理フロー**:
- **3161行目**: obj.NameとtranslateTimestampSince(obj.CreationTimestamp)をTableRowに追加

### プログラム呼び出し階層図

```
AddHandlers (printers.go:93)
    |
    +-- h.TableHandler(deviceClassColumnDefinitions, printDeviceClass) (printers.go:671)
    +-- h.TableHandler(deviceClassColumnDefinitions, printDeviceClassList) (printers.go:672)
            |
            +-- printDeviceClass (printers.go:3157)
                    |
                    +-- translateTimestampSince (printers.go内共通関数)
```

### データフロー図

```
[入力]                     [処理]                    [出力]

DeviceClass           printDeviceClass()         TableRow
(etcd経由API取得) --> Name, Age抽出           --> (HumanReadablePrinter
                                                   によりテーブル形式で
                                                   stdoutへ出力)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | DeviceClassのテーブル出力ロジック本体（667-672, 3157-3176行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | TableHandler登録・TableRow生成の共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル整形出力 |
| types.go | `pkg/apis/resource/types.go` | ソース | DeviceClass内部API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | DeviceClassテーブル出力のテストケース |
