# 帳票設計書 56-ResourceClaim一覧

## 概要

本ドキュメントは、KubernetesのResourceClaimリソースをテーブル形式で一覧出力する帳票の設計書である。ResourceClaimはDynamic Resource Allocation（DRA）機構においてデバイスリソースの割り当て要求を表すリソースであり、本帳票はその一覧表示と割り当て状態の確認を担う。

### 本帳票の処理概要

**業務上の目的・背景**：KubernetesのDynamic Resource Allocation機能では、GPUなどの特殊なハードウェアリソースをPodに動的に割り当てることができる。ResourceClaimはリソースの割り当て要求を表し、その状態（pending、allocated、reserved等）を追跡する。クラスタ管理者やアプリケーション開発者がリソース割り当ての現在の状態を把握し、割り当て問題を特定するために本帳票が必要となる。

**帳票の利用シーン**：クラスタ管理者がリソース割り当ての状態を確認する際に`kubectl get resourceclaims`コマンドを実行して利用する。特に、リソースの割り当て待ち状態のPodや、割り当て済みリソースの確認、トラブルシューティングの場面で利用される。

**主要な出力内容**：
1. ResourceClaim名
2. 状態（State）: pending / allocated / reserved / deleted の組み合わせ
3. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザが`kubectl get resourceclaims`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、アプリケーション開発者、プラットフォームエンジニア。

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（kubectl） | - | `kubectl get resourceclaims` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | 横 |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で各ResourceClaimリソースを1行ずつ出力する。カラムは固定3列で構成される。

```
NAME              STATE               AGE
my-gpu-claim      allocated,reserved  10d
pending-claim     pending             5m
deleting-claim    deleted,allocated   1h
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | ResourceClaimのリソース名 | obj.Name | 文字列 |
| 2 | State | リソース割り当ての現在の状態 | resourceClaimState(obj) | カンマ区切り文字列 |
| 3 | Age | 作成からの経過時間 | obj.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | 各ResourceClaimの名前 | obj.Name | 文字列 | 可変 |
| 2 | State | 割り当て状態 | resourceClaimState(obj) | カンマ区切り文字列 | 可変 |
| 3 | Age | 経過時間 | obj.CreationTimestamp | 相対時間 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | ResourceClaimが属するNamespace | No（デフォルトはdefault） |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | リスト取得順（APIサーバ返却順） | - |

### 改ページ条件

ターミナル出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/resourceclaims/{namespace}/ | ResourceClaimリソースの格納先 | Namespace+リソース名で直接アクセス |

### テーブル別参照項目詳細

#### ResourceClaim

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| metadata.deletionTimestamp | State（deletedの判定） | - | nilでなければ"deleted"を追加 |
| status.allocation | State（allocatedの判定） | - | nilでなければ"allocated"を追加 |
| status.reservedFor | State（reservedの判定） | - | 長さ>0なら"reserved"を追加 |
| metadata.creationTimestamp | Age | - | translateTimestampSinceで相対時間化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | 現在時刻 - CreationTimestamp | - | duration.HumanDurationで人間可読形式に変換 |
| State | resourceClaimState関数で算出 | - | deleted, pending, allocated, reservedの組み合わせをカンマ区切りで表示 |

### State（状態）判定ロジック

resourceClaimState関数（printers.go 3187-3203行目）による状態判定：

1. DeletionTimestampがnilでない場合、"deleted"を追加
2. Status.Allocationがnilの場合：
   - DeletionTimestampもnilの場合、"pending"を追加
3. Status.Allocationがnilでない場合：
   - "allocated"を追加
   - Status.ReservedForの長さが0より大きい場合、"reserved"を追加
4. 全状態をカンマ区切りで結合して返す

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get resourceclaims] --> B[APIサーバからResourceClaimList取得]
    B --> C[各ResourceClaimに対してprintResourceClaim呼び出し]
    C --> D[resourceClaimState関数で状態算出]
    D --> E{DeletionTimestamp?}
    E -->|非nil| F[deleted追加]
    E -->|nil| G[DeletionTimestampなし]
    F --> H{Allocation?}
    G --> H
    H -->|nil + DeletionTimestampなし| I[pending追加]
    H -->|非nil| J[allocated追加]
    J --> K{ReservedFor?}
    K -->|長さ>0| L[reserved追加]
    K -->|空| M[reservedなし]
    I --> N[TableRow生成]
    L --> N
    M --> N
    N --> O[HumanReadablePrinter.PrintObjでテーブル出力]
    O --> P[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | ResourceClaimが存在しない | `No resources found` | - |
| API接続エラー | APIサーバへの接続失敗 | 接続エラーメッセージ | kubeconfigの確認 |
| 権限エラー | ResourceClaimのlist権限がない | `Forbidden` | RBACの設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数百件（ワークロード数とデバイス使用数に依存） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

ResourceClaimはNamespaceスコープのリソースであり、参照にはNamespace内でのResourceClaimのlist権限が必要。出力内容にはリソース割り当て状態のみが含まれ、直接的な機密情報は含まれない。

## 備考

- Stateカラムは複数の状態をカンマ区切りで表示する（例: "deleted,allocated"）
- "pending"は、Allocationがnilかつ削除中でない場合にのみ表示される
- ResourceClaimはNamespaceスコープのリソースである

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

ResourceClaimリソースの内部表現と状態判定に使われるフィールドを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/resource/types.go` | ResourceClaim, ResourceClaimStatus, AllocationResult, ResourceClaimConsumerReferenceの構造体定義 |
| 1-2 | printers.go | `pkg/printers/internalversion/printers.go` | 674-680行目: resourceClaimColumnDefinitionsの定義。3カラム（Name, State, Age）の定義を確認 |

**読解のコツ**: ResourceClaimの状態はStatus.Allocation（割り当て結果）とStatus.ReservedFor（予約先）、そしてDeletionTimestamp（削除マーカー）の組み合わせで決まる。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 679-680行目: printResourceClaim/printResourceClaimListの登録 |

**主要処理フロー**:
1. **679行目**: resourceClaimColumnDefinitionsとprintResourceClaim関数がTableHandlerとして登録
2. **680行目**: resourceClaimColumnDefinitionsとprintResourceClaimList関数がTableHandlerとして登録

#### Step 3: 印刷処理と状態判定を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3178-3185行目: printResourceClaim関数。resourceClaimState呼び出し |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | 3187-3203行目: resourceClaimState関数。状態判定ロジックの核心部分 |

**主要処理フロー**:
- **3182行目**: obj.Name, resourceClaimState(obj), AgeをTableRowに追加
- **3189-3191行目**: DeletionTimestampがnilでなければ"deleted"を追加
- **3192-3195行目**: Allocationがnilかつ削除中でなければ"pending"を追加
- **3196-3201行目**: Allocationが非nilなら"allocated"を追加、ReservedForが非空なら"reserved"を追加
- **3202行目**: 状態をカンマ区切りで結合

### プログラム呼び出し階層図

```
AddHandlers (printers.go:93)
    |
    +-- h.TableHandler(resourceClaimColumnDefinitions, printResourceClaim) (printers.go:679)
    +-- h.TableHandler(resourceClaimColumnDefinitions, printResourceClaimList) (printers.go:680)
            |
            +-- printResourceClaim (printers.go:3178)
                    |
                    +-- resourceClaimState (printers.go:3187)
                    +-- translateTimestampSince (printers.go内共通関数)
```

### データフロー図

```
[入力]                        [処理]                              [出力]

ResourceClaim            printResourceClaim()               TableRow
(etcd経由API取得)  --->  Name取得                        ---> (HumanReadablePrinter
                          resourceClaimState()                  によりテーブル形式で
                            DeletionTimestamp判定               stdoutへ出力)
                            Allocation nil判定
                            ReservedFor長さ判定
                          Age算出
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | ResourceClaimのテーブル出力ロジック本体（674-680, 3178-3215行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | TableHandler登録・TableRow生成の共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル整形出力 |
| types.go | `pkg/apis/resource/types.go` | ソース | ResourceClaim内部API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | ResourceClaimテーブル出力のテストケース |
