# 帳票設計書 57-ResourceClaimTemplate一覧

## 概要

本ドキュメントは、KubernetesのResourceClaimTemplateリソースをテーブル形式で一覧出力する帳票の設計書である。ResourceClaimTemplateはDynamic Resource Allocation（DRA）機構においてResourceClaimの生成テンプレートを定義するリソースであり、本帳票はその一覧表示を担う。

### 本帳票の処理概要

**業務上の目的・背景**：KubernetesのDynamic Resource Allocation機能では、Podの起動時にResourceClaimを自動生成するためにResourceClaimTemplateが使用される。テンプレートにより、各Podが個別のResourceClaimを持つことが可能となり、リソース割り当ての柔軟性が向上する。クラスタ管理者やアプリケーション開発者がどのようなResourceClaimテンプレートが定義されているかを確認するために本帳票が必要となる。

**帳票の利用シーン**：クラスタ管理者がResourceClaimテンプレートの一覧を確認する際に`kubectl get resourceclaimtemplates`コマンドを実行して利用する。Podのリソース割り当て設定の確認やテンプレートの管理場面で利用される。

**主要な出力内容**：
1. ResourceClaimTemplate名
2. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザが`kubectl get resourceclaimtemplates`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、アプリケーション開発者。

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（kubectl） | - | `kubectl get resourceclaimtemplates` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | 横 |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で各ResourceClaimTemplateリソースを1行ずつ出力する。カラムは固定2列のシンプルな構成である。

```
NAME                  AGE
gpu-claim-template    10d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | ResourceClaimTemplateのリソース名 | obj.Name | 文字列 |
| 2 | Age | 作成からの経過時間 | obj.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | 各ResourceClaimTemplateの名前 | obj.Name | 文字列 | 可変 |
| 2 | Age | 経過時間 | obj.CreationTimestamp | 相対時間 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | ResourceClaimTemplateが属するNamespace | No（デフォルトはdefault） |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | リスト取得順（APIサーバ返却順） | - |

### 改ページ条件

ターミナル出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/resourceclaimtemplates/{namespace}/ | ResourceClaimTemplateリソースの格納先 | Namespace+リソース名で直接アクセス |

### テーブル別参照項目詳細

#### ResourceClaimTemplate

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| metadata.creationTimestamp | Age | - | translateTimestampSinceで相対時間化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | 現在時刻 - CreationTimestamp | - | duration.HumanDurationで人間可読形式に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get resourceclaimtemplates] --> B[APIサーバからResourceClaimTemplateList取得]
    B --> C[各ResourceClaimTemplateに対してprintResourceClaimTemplate呼び出し]
    C --> D[TableRow生成]
    D --> E[HumanReadablePrinter.PrintObjでテーブル出力]
    E --> F[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | ResourceClaimTemplateが存在しない | `No resources found` | - |
| API接続エラー | APIサーバへの接続失敗 | 接続エラーメッセージ | kubeconfigの確認 |
| 権限エラー | ResourceClaimTemplateのlist権限がない | `Forbidden` | RBACの設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

ResourceClaimTemplateはNamespaceスコープのリソースであり、参照にはNamespace内でのResourceClaimTemplateのlist権限が必要。出力内容にはテンプレート名と経過時間のみが含まれ、機密情報は含まれない。

## 備考

- ResourceClaimTemplateのテーブル出力はNameとAgeの2カラムのみで、非常にシンプルな構成である
- テンプレートの詳細な設定（デバイス要求条件等）はdescribeコマンドやYAML/JSON出力で確認する必要がある
- ResourceClaimTemplateはNamespaceスコープのリソースである

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/resource/types.go` | ResourceClaimTemplate, ResourceClaimTemplateListの構造体定義 |
| 1-2 | printers.go | `pkg/printers/internalversion/printers.go` | 682-687行目: resourceClaimTemplateColumnDefinitionsの定義。2カラム（Name, Age）の定義を確認 |

**読解のコツ**: ResourceClaimTemplateはResourceClaimのSpec部分をテンプレートとして保持する。テーブル出力にはSpecの詳細は含まれない。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 686-687行目: printResourceClaimTemplate/printResourceClaimTemplateListの登録 |

#### Step 3: 印刷処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3217-3224行目: printResourceClaimTemplate関数 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | 3226-3236行目: printResourceClaimTemplateList関数 |

**主要処理フロー**:
- **3221行目**: obj.NameとtranslateTimestampSince(obj.CreationTimestamp)をTableRowに追加

### プログラム呼び出し階層図

```
AddHandlers (printers.go:93)
    |
    +-- h.TableHandler(resourceClaimTemplateColumnDefinitions, printResourceClaimTemplate) (printers.go:686)
    +-- h.TableHandler(resourceClaimTemplateColumnDefinitions, printResourceClaimTemplateList) (printers.go:687)
            |
            +-- printResourceClaimTemplate (printers.go:3217)
                    |
                    +-- translateTimestampSince (printers.go内共通関数)
```

### データフロー図

```
[入力]                            [処理]                          [出力]

ResourceClaimTemplate        printResourceClaimTemplate()    TableRow
(etcd経由API取得)      --->  Name, Age抽出                --> (HumanReadablePrinter
                                                               によりテーブル形式で
                                                               stdoutへ出力)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | ResourceClaimTemplateのテーブル出力ロジック本体（682-687, 3217-3236行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | TableHandler登録・TableRow生成の共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル整形出力 |
| types.go | `pkg/apis/resource/types.go` | ソース | ResourceClaimTemplate内部API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | ResourceClaimTemplateテーブル出力のテストケース |
