# 帳票設計書 58-ResourceSlice一覧

## 概要

本ドキュメントは、KubernetesのResourceSliceリソースをテーブル形式で一覧出力する帳票の設計書である。ResourceSliceはDynamic Resource Allocation（DRA）機構においてノード上の利用可能なデバイスリソースを公開するリソースであり、本帳票はその一覧表示を担う。

### 本帳票の処理概要

**業務上の目的・背景**：KubernetesのDynamic Resource Allocation機能では、各ノード上のデバイスドライバがResourceSliceを作成し、利用可能なデバイスリソースをスケジューラに公開する。クラスタ管理者がクラスタ全体のデバイスリソースの可用性を把握し、リソース割り当ての計画やトラブルシューティングを行うために本帳票が必要となる。

**帳票の利用シーン**：クラスタ管理者がクラスタ内のデバイスリソースの分布状況を確認する際に`kubectl get resourceslices`コマンドを実行して利用する。特に、各ノードにどのドライバのどのプールがあるかを一覧で確認する場面で利用される。

**主要な出力内容**：
1. ResourceSlice名
2. Node名（デバイスが存在するノード）
3. Driver名（デバイスドライバ名）
4. Pool名（リソースプール名）
5. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザが`kubectl get resourceslices`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、プラットフォームエンジニア。

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（kubectl） | - | `kubectl get resourceslices` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | 横 |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で各ResourceSliceリソースを1行ずつ出力する。カラムは固定5列で構成される。

```
NAME                    NODE          DRIVER              POOL         AGE
node1-gpu-slice-abc     node1         nvidia.com          gpu-pool     10d
node2-gpu-slice-def     node2         nvidia.com          gpu-pool     10d
network-slice-xyz                     mellanox.com        rdma-pool    5d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | ResourceSliceのリソース名 | obj.Name | 文字列 |
| 2 | Node | デバイスが存在するノード名 | obj.Spec.NodeName | 文字列（nilの場合は空文字列） |
| 3 | Driver | デバイスドライバ名 | obj.Spec.Driver | 文字列 |
| 4 | Pool | リソースプール名 | obj.Spec.Pool.Name | 文字列 |
| 5 | Age | 作成からの経過時間 | obj.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | 各ResourceSliceの名前 | obj.Name | 文字列 | 可変 |
| 2 | Node | ノード名 | obj.Spec.NodeName | 文字列 | 可変 |
| 3 | Driver | ドライバ名 | obj.Spec.Driver | 文字列 | 可変 |
| 4 | Pool | プール名 | obj.Spec.Pool.Name | 文字列 | 可変 |
| 5 | Age | 経過時間 | obj.CreationTimestamp | 相対時間 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | ResourceSliceはクラスタスコープのため、Namespace指定は不要 | No |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | リスト取得順（APIサーバ返却順） | - |

### 改ページ条件

ターミナル出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/resourceslices/ | ResourceSliceリソースの格納先 | リソース名で直接アクセス |

### テーブル別参照項目詳細

#### ResourceSlice

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| spec.nodeName | Node | - | ポインタ型。nilの場合は空文字列 |
| spec.driver | Driver | - | - |
| spec.pool.name | Pool | - | - |
| metadata.creationTimestamp | Age | - | translateTimestampSinceで相対時間化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | 現在時刻 - CreationTimestamp | - | duration.HumanDurationで人間可読形式に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get resourceslices] --> B[APIサーバからResourceSliceList取得]
    B --> C[各ResourceSliceに対してprintResourceSlice呼び出し]
    C --> D{Spec.NodeName != nil?}
    D -->|Yes| E[NodeNameの値を使用]
    D -->|No| F[空文字列を使用]
    E --> G[TableRow生成]
    F --> G
    G --> H[HumanReadablePrinter.PrintObjでテーブル出力]
    H --> I[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | ResourceSliceが存在しない | `No resources found` | - |
| API接続エラー | APIサーバへの接続失敗 | 接続エラーメッセージ | kubeconfigの確認 |
| 権限エラー | ResourceSliceのlist権限がない | `Forbidden` | RBACの設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数十件〜数百件（ノード数 x デバイスドライバ数に依存） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

ResourceSliceはクラスタスコープのリソースであり、参照にはcluster-admin相当の権限が推奨される。出力内容にはノード名、ドライバ名、プール名が含まれるが、直接的な機密情報は含まれない。ただし、クラスタのハードウェア構成情報が露出する可能性がある。

## 備考

- Spec.NodeNameはポインタ型（*string）であり、ノードに紐づかないリソース（ネットワークリソース等）の場合はnilとなる
- クラスタスコープのリソースであるため、全ノードのResourceSliceが一覧表示される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/resource/types.go` | ResourceSlice, ResourceSliceSpec, ResourcePoolの構造体定義 |
| 1-2 | printers.go | `pkg/printers/internalversion/printers.go` | 689-697行目: nodeResourceSliceColumnDefinitionsの定義。5カラム（Name, Node, Driver, Pool, Age）の定義を確認 |

**読解のコツ**: ResourceSliceSpecのNodeNameはポインタ型（*string）であり、nilチェックが必要。DriverとPool.Nameは直接アクセス可能。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 696-697行目: printResourceSlice/printResourceSliceListの登録 |

#### Step 3: 印刷処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3238-3249行目: printResourceSlice関数。NodeNameのnil判定ロジック |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | 3251-3261行目: printResourceSliceList関数 |

**主要処理フロー**:
- **3242-3245行目**: NodeNameがnilでなければポインタの値を使用、nilなら空文字列
- **3246行目**: Name, nodeName, Driver, Pool.Name, AgeをTableRowに追加

### プログラム呼び出し階層図

```
AddHandlers (printers.go:93)
    |
    +-- h.TableHandler(nodeResourceSliceColumnDefinitions, printResourceSlice) (printers.go:696)
    +-- h.TableHandler(nodeResourceSliceColumnDefinitions, printResourceSliceList) (printers.go:697)
            |
            +-- printResourceSlice (printers.go:3238)
                    |
                    +-- translateTimestampSince (printers.go内共通関数)
```

### データフロー図

```
[入力]                        [処理]                             [出力]

ResourceSlice            printResourceSlice()              TableRow
(etcd経由API取得)  --->  Name取得                        --> (HumanReadablePrinter
                          NodeName nil判定                     によりテーブル形式で
                          Driver, Pool.Name取得                stdoutへ出力)
                          Age算出
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | ResourceSliceのテーブル出力ロジック本体（689-697, 3238-3261行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | TableHandler登録・TableRow生成の共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル整形出力 |
| types.go | `pkg/apis/resource/types.go` | ソース | ResourceSlice内部API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | ResourceSliceテーブル出力のテストケース |
