# 帳票設計書 59-DeviceTaintRule一覧

## 概要

本ドキュメントは、KubernetesのDeviceTaintRuleリソースをテーブル形式で一覧出力する帳票の設計書である。DeviceTaintRuleはDynamic Resource Allocation（DRA）機構においてデバイスにTaint（汚染マーク）を付与するためのルールを定義するリソースであり、本帳票はその一覧表示を担う。

### 本帳票の処理概要

**業務上の目的・背景**：KubernetesのDynamic Resource Allocation機能では、特定のデバイスに対してTaintを設定することで、対応するTolerationを持たないResourceClaimからのデバイス使用を制限できる。DeviceTaintRuleはこのTaintの付与ルールを定義する。クラスタ管理者がデバイスのTaint設定状況を確認し、リソース制御が適切に行われているかを検証するために本帳票が必要となる。

**帳票の利用シーン**：クラスタ管理者がデバイスのTaintルールを確認する際に`kubectl get devicetaintrules`コマンドを実行して利用する。特に、特定のデバイスを特定のワークロードに限定したい場合のルール確認やデバッグの場面で利用される。

**主要な出力内容**：
1. DeviceTaintRule名
2. Taintのキー（Key）
3. Taintの値（Value）
4. Taintのエフェクト（Effect）
5. Taintの追加時刻（TimeAdded）
6. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザが`kubectl get devicetaintrules`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、プラットフォームエンジニア。

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（kubectl） | - | `kubectl get devicetaintrules` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | 横 |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で各DeviceTaintRuleリソースを1行ずつ出力する。カラムは固定6列で構成される。

```
NAME                KEY                   VALUE     EFFECT           TIMEADDED   AGE
gpu-maintenance     maintenance.device    true      NoSchedule       5d          10d
network-restrict    restricted.device     premium   NoExecute        1d          3d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | DeviceTaintRuleのリソース名 | obj.Name | 文字列 |
| 2 | Key | Taintのキー | obj.Spec.Taint.Key | 文字列 |
| 3 | Value | Taintの値 | obj.Spec.Taint.Value | 文字列 |
| 4 | Effect | Taintのエフェクト | obj.Spec.Taint.Effect | 文字列 |
| 5 | TimeAdded | Taintが追加された時刻 | obj.Spec.Taint.TimeAdded | 相対時間（nilの場合は空文字列） |
| 6 | Age | 作成からの経過時間 | obj.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | 各DeviceTaintRuleの名前 | obj.Name | 文字列 | 可変 |
| 2 | Key | Taintキー | obj.Spec.Taint.Key | 文字列 | 可変 |
| 3 | Value | Taint値 | obj.Spec.Taint.Value | 文字列 | 可変 |
| 4 | Effect | エフェクト | obj.Spec.Taint.Effect | 文字列 | 可変 |
| 5 | TimeAdded | 追加時刻 | obj.Spec.Taint.TimeAdded | 相対時間 | 可変 |
| 6 | Age | 経過時間 | obj.CreationTimestamp | 相対時間 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | DeviceTaintRuleはクラスタスコープのため、Namespace指定は不要 | No |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | リスト取得順（APIサーバ返却順） | - |

### 改ページ条件

ターミナル出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/devicetaintrules/ | DeviceTaintRuleリソースの格納先 | リソース名で直接アクセス |

### テーブル別参照項目詳細

#### DeviceTaintRule

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| spec.taint.key | Key | - | string()でキャスト |
| spec.taint.value | Value | - | - |
| spec.taint.effect | Effect | - | string()でキャスト |
| spec.taint.timeAdded | TimeAdded | - | ポインタ型。nilの場合は空文字列。非nilの場合はtranslateTimestampSinceで相対時間化 |
| metadata.creationTimestamp | Age | - | translateTimestampSinceで相対時間化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | 現在時刻 - CreationTimestamp | - | duration.HumanDurationで人間可読形式に変換 |
| TimeAdded | 現在時刻 - Spec.Taint.TimeAdded | - | TimeAddedがnilでない場合のみ算出。nilの場合は空文字列 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get devicetaintrules] --> B[APIサーバからDeviceTaintRuleList取得]
    B --> C[各DeviceTaintRuleに対してprintDeviceTaint呼び出し]
    C --> D{Spec.Taint.TimeAdded != nil?}
    D -->|Yes| E[translateTimestampSinceで相対時間取得]
    D -->|No| F[空文字列を使用]
    E --> G[TableRow生成]
    F --> G
    G --> H[HumanReadablePrinter.PrintObjでテーブル出力]
    H --> I[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | DeviceTaintRuleが存在しない | `No resources found` | - |
| API接続エラー | APIサーバへの接続失敗 | 接続エラーメッセージ | kubeconfigの確認 |
| 権限エラー | DeviceTaintRuleのlist権限がない | `Forbidden` | RBACの設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数件〜数十件 |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

DeviceTaintRuleはクラスタスコープのリソースであり、参照にはcluster-admin相当の権限が推奨される。出力内容にはTaintのKey/Value/Effect情報が含まれるが、直接的な機密情報は含まれない。

## 備考

- フィルタ条件（DeviceSelector）はテーブル出力に含まれない。コメント（printers.go 701-703行目）によると、フィルタ条件はCEL式を含む可能性があり長くなるため、管理者が説明的な名前を使うことを想定している
- TimeAddedとAgeは通常同じ値になるが、必ずしも同一ではない
- printDeviceTaint関数は個別のDeviceTaintRule出力を担い、printDeviceTaintRuleList関数がリスト出力を担う

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/resource/types.go` | DeviceTaintRule, DeviceTaintRuleSpec, DeviceTaintの構造体定義 |
| 1-2 | printers.go | `pkg/printers/internalversion/printers.go` | 699-713行目: deviceTaintColumnDefinitionsの定義。6カラム（Name, Key, Value, Effect, TimeAdded, Age）の定義と、フィルタ条件を含めない設計意図のコメントを確認 |

**読解のコツ**: DeviceTaintのKeyとEffectはカスタム型であり、string()でキャストして出力される。TimeAddedはポインタ型（*metav1.Time）でありnil判定が必要。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 712-713行目: printDeviceTaint/printDeviceTaintRuleListの登録 |

**主要処理フロー**:
1. **712行目**: deviceTaintColumnDefinitionsとprintDeviceTaint関数がTableHandlerとして登録
2. **713行目**: deviceTaintColumnDefinitionsとprintDeviceTaintRuleList関数がTableHandlerとして登録

#### Step 3: 印刷処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3263-3275行目: printDeviceTaint関数。TimeAddedのnil判定とTaint情報の取得 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | 3277-3287行目: printDeviceTaintRuleList関数 |

**主要処理フロー**:
- **3268-3271行目**: TimeAddedがnilでなければtranslateTimestampSinceで相対時間取得、nilなら空文字列
- **3272行目**: Name, Key(string), Value, Effect(string), timeAdded, AgeをTableRowに追加

### プログラム呼び出し階層図

```
AddHandlers (printers.go:93)
    |
    +-- h.TableHandler(deviceTaintColumnDefinitions, printDeviceTaint) (printers.go:712)
    +-- h.TableHandler(deviceTaintColumnDefinitions, printDeviceTaintRuleList) (printers.go:713)
            |
            +-- printDeviceTaint (printers.go:3263)
                    |
                    +-- translateTimestampSince (printers.go内共通関数) x2
```

### データフロー図

```
[入力]                          [処理]                              [出力]

DeviceTaintRule            printDeviceTaint()                  TableRow
(etcd経由API取得)  --->   Name取得                          --> (HumanReadablePrinter
                           Taint.Key/Value/Effect取得             によりテーブル形式で
                           TimeAdded nil判定                      stdoutへ出力)
                           Age算出
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | DeviceTaintRuleのテーブル出力ロジック本体（699-713, 3263-3287行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | TableHandler登録・TableRow生成の共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル整形出力 |
| types.go | `pkg/apis/resource/types.go` | ソース | DeviceTaintRule内部API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | DeviceTaintRuleテーブル出力のテストケース |
