# 帳票設計書 6-DaemonSet一覧

## 概要

本ドキュメントは、Kubernetes の DaemonSet リソース一覧をテーブル形式で標準出力に出力する帳票の設計を定義する。`kubectl get ds` コマンド実行時に使用される。

### 本帳票の処理概要

本帳票は、Kubernetes クラスタ上の DaemonSet リソースの一覧情報を、テーブル形式で標準出力に表示する処理を行う。

**業務上の目的・背景**：DaemonSet はクラスタの全ノード（または指定ノード）に 1 つずつ Pod を配置するリソースである。ログ収集、モニタリングエージェント、ネットワークプラグインなどのインフラストラクチャコンポーネントのデプロイに広く使用される。運用者が全ノードへの Pod 配置状況（Desired / Current / Ready / Up-to-date / Available）を一覧で確認し、ノード追加・削除時やローリングアップデート時の展開状態を監視するために不可欠な帳票である。

**帳票の利用シーン**：DaemonSet の展開状況確認、ローリングアップデートの進行監視、ノード追加後の DaemonSet Pod 配置確認、Node Selector による配置対象ノードの確認。

**主要な出力内容**：
1. DaemonSet 名（Name）
2. 希望スケジュール数（Desired）
3. 現在スケジュール数（Current）
4. Ready 数（Ready）
5. 最新バージョン数（Up-to-date）
6. 利用可能数（Available）
7. ノードセレクタ（Node Selector）
8. 作成からの経過時間（Age）
9. Wide 出力時: コンテナ名、イメージ名、セレクタ

**帳票の出力タイミング**：ユーザが `kubectl get ds` または `kubectl get daemonsets` コマンドを実行した際に出力される。

**帳票の利用者**：Kubernetes クラスタ管理者、インフラエンジニア、SRE。

## 帳票種別

一覧表（リソース一覧出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| N/A | ターミナル（CLI） | N/A | `kubectl get ds [flags]` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | 標準出力（テキスト / テーブル形式） |
| 用紙サイズ | N/A |
| 向き | N/A |
| ファイル名 | N/A |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

### テーブル出力固有設定

| 項目 | 内容 |
|-----|------|
| カラム区切り | タブ文字（tabwriter） |
| ヘッダー表示 | デフォルト有効 |
| Wide 出力 | Containers, Images, Selector が追加（Priority=1） |

## 帳票レイアウト

### レイアウト概要

```
┌────────────────────────────────────────────────────────────────────────────────────────┐
│  NAME      DESIRED   CURRENT   READY   UP-TO-DATE   AVAILABLE   NODE SELECTOR   AGE   │
├────────────────────────────────────────────────────────────────────────────────────────┤
│  fluentd   3         3         3       3            3           <none>          5d     │
│  calico    5         5         5       5            5           kubernetes.io/os=linux  2d │
└────────────────────────────────────────────────────────────────────────────────────────┘
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | DS の名前 | `obj.ObjectMeta.Name` | 文字列（name フォーマット） |
| 2 | Desired | 希望スケジュール数 | `obj.Status.DesiredNumberScheduled` | 整数（int64） |
| 3 | Current | 現在スケジュール数 | `obj.Status.CurrentNumberScheduled` | 整数（int64） |
| 4 | Ready | Ready Pod 数 | `obj.Status.NumberReady` | 整数（int64） |
| 5 | Up-to-date | 最新テンプレートの Pod 数 | `obj.Status.UpdatedNumberScheduled` | 整数（int64） |
| 6 | Available | 利用可能 Pod 数 | `obj.Status.NumberAvailable` | 整数（int64） |
| 7 | Node Selector | ノードセレクタ | `obj.Spec.Template.Spec.NodeSelector` | `labels.FormatLabels` で整形 |
| 8 | Age | 経過時間 | `obj.ObjectMeta.CreationTimestamp` | `translateTimestampSince` |

### 明細部（Wide 出力時の追加カラム）

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 9 | Containers | コンテナ名一覧 | `obj.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 10 | Images | イメージ名一覧 | `obj.Spec.Template.Spec.Containers` | カンマ区切り | 可変 |
| 11 | Selector | Pod セレクタ | `obj.Spec.Selector` | LabelSelector 文字列 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | 対象 Namespace | No |
| All Namespaces | 全 Namespace | No |
| Label Selector | ラベルフィルタ | No |
| Field Selector | フィールドフィルタ | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | DS 名（デフォルト） | 昇順 |

### 改ページ条件

改ページは発生しない。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: `/registry/daemonsets/{namespace}/{name}` | DS オブジェクトの永続化ストア | N/A |

### テーブル別参照項目詳細

#### DaemonSet リソース（API: `apps/v1/daemonsets`）

| 参照項目（フィールド） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| `metadata.name` | Name | N/A | DS の名前 |
| `metadata.creationTimestamp` | Age | N/A | 経過時間に変換 |
| `status.desiredNumberScheduled` | Desired | N/A | int32 を int64 にキャスト |
| `status.currentNumberScheduled` | Current | N/A | int32 を int64 にキャスト |
| `status.numberReady` | Ready | N/A | int32 を int64 にキャスト |
| `status.updatedNumberScheduled` | Up-to-date | N/A | int32 を int64 にキャスト |
| `status.numberAvailable` | Available | N/A | int32 を int64 にキャスト |
| `spec.template.spec.nodeSelector` | Node Selector | N/A | labels.FormatLabels で変換 |
| `spec.template.spec.containers` | Containers, Images (wide) | N/A | layoutContainerCells |
| `spec.selector` | Selector (wide) | N/A | metav1.FormatLabelSelector |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Desired | `int64(obj.Status.DesiredNumberScheduled)` | N/A | Status から取得（Spec ではない） |
| Current | `int64(obj.Status.CurrentNumberScheduled)` | N/A | |
| Ready | `int64(obj.Status.NumberReady)` | N/A | |
| Up-to-date | `int64(obj.Status.UpdatedNumberScheduled)` | N/A | |
| Available | `int64(obj.Status.NumberAvailable)` | N/A | |
| Node Selector | `labels.FormatLabels(obj.Spec.Template.Spec.NodeSelector)` | N/A | map[string]string 形式 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get ds 実行] --> B[API サーバへリクエスト]
    B --> C[DS リスト取得]
    C --> D[printDaemonSetList]
    D --> E[printDaemonSet で各行生成]
    E --> F[HumanReadablePrinter でテーブル出力]
    F --> G[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | DS が存在しない | `No resources found in {namespace} namespace.` | 条件見直し |
| API エラー | 接続失敗 | API エラーメッセージ | kubeconfig 確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 通常は少数〜数十件 |
| 目標出力時間 | 即時 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

- DS 一覧取得には `daemonsets` リソース（apps グループ）の `list` / `get` 権限が必要

## 備考

- DaemonSet は RS / Deployment と異なり、全ステータスカラム（Desired〜Available）が Status フィールドから取得される
- Node Selector は通常表示カラム（Priority=0）に含まれる
- Node Selector が未設定の場合、全ノードに配置される（labels.FormatLabels の出力は空文字列）

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printers.go | `pkg/printers/internalversion/printers.go` | daemonSetColumnDefinitions（行 155-167）: 8 通常カラム + 3 wide カラム。他のリソースより通常カラムが多い点に注意 |

**読解のコツ**: DaemonSet は Status から取得するカラムが 5 つ（Desired, Current, Ready, Up-to-date, Available）あり、RS/RC の 3 つより多い。

#### Step 2: print 関数を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | `printDaemonSet`（行 1561-1578）: Status の 5 フィールドを int64 にキャスト、NodeSelector を labels.FormatLabels で整形 |
| 2-2 | printers.go | `pkg/printers/internalversion/printers.go` | `printDaemonSetList`（行 1580-1590）: Items を順に委譲 |

**主要処理フロー**:
- **行 1566-1570**: Status から 5 つのスケジュール関連フィールドを取得
- **行 1572**: Name, Desired(int64), Current(int64), Ready(int64), Updated(int64), Available(int64), NodeSelector, Age をセルに追加
- **行 1573-1576**: Wide 時にコンテナ情報と FormatLabelSelector でセレクタを追加

### プログラム呼び出し階層図

```
kubectl get ds
    |
    +-- GetOptions.Run() [get.go]
           |
           +-- API Server Request
           |       |
           |       +-- printDaemonSetList() [printers.go 行1580]
           |               |
           |               +-- printDaemonSet() [printers.go 行1561]
           |                       |
           |                       +-- labels.FormatLabels() [NodeSelector]
           |                       +-- layoutContainerCells() [printers.go 行2767] (wide)
           |                       +-- metav1.FormatLabelSelector() (wide)
           |
           +-- HumanReadablePrinter.PrintObj()
```

### データフロー図

```
[入力]                          [処理]                              [出力]

API Server (etcd)          printDaemonSet()                   標準出力 (stdout)
  DS Object            --> - Status 5 フィールド取得        --> テーブル形式テキスト
  (apps.DaemonSet)         - NodeSelector 整形                  NAME DESIRED CURRENT ...
                           - layoutContainerCells (wide)        ds1  3       3       3  ...
                           - FormatLabelSelector (wide)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | DS 用カラム定義と print 関数（行 155-169, 1561-1590） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | テーブル生成基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | テーブルレンダリング |
| get.go | `staging/src/k8s.io/kubectl/pkg/cmd/get/get.go` | ソース | kubectl get コマンドエントリーポイント |
