# 帳票設計書 60-ServiceCIDR一覧

## 概要

本ドキュメントは、KubernetesのServiceCIDRリソースをテーブル形式で一覧出力する帳票の設計書である。ServiceCIDRはKubernetesクラスタ内のServiceに割り当てるIPアドレス範囲（CIDR）を定義するリソースであり、本帳票はその一覧表示を担う。

### 本帳票の処理概要

**業務上の目的・背景**：Kubernetesクラスタでは、Serviceリソースに対してClusterIPが自動的に割り当てられる。ServiceCIDRリソースは、このClusterIP割り当てに使用するIPアドレス範囲を定義する。クラスタ管理者がサービスネットワークの設定を確認し、IPアドレス範囲の管理を行うために本帳票が必要となる。複数のServiceCIDRを定義することで、IPアドレス空間の拡張が可能となる。

**帳票の利用シーン**：クラスタ管理者がServiceに割り当て可能なIPアドレス範囲を確認する際に`kubectl get servicecidrs`コマンドを実行して利用する。特に、IPアドレス枯渇の調査やネットワーク設計の確認場面で利用される。

**主要な出力内容**：
1. ServiceCIDR名
2. CIDRs（IPアドレス範囲のリスト）
3. リソースの経過時間（Age）

**帳票の出力タイミング**：ユーザが`kubectl get servicecidrs`コマンドを実行した際にリアルタイムで出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、ネットワークエンジニア。

## 帳票種別

一覧表

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（kubectl） | - | `kubectl get servicecidrs` |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | 横 |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

テーブル形式で各ServiceCIDRリソースを1行ずつ出力する。カラムは固定3列で構成される。

```
NAME               CIDRS                           AGE
kubernetes         10.96.0.0/12,fd00::/108         10d
additional-cidr    192.168.0.0/16                  5d
```

### ヘッダー部

| No | 項目名 | 説明 | データ取得元 | 表示形式 |
|----|-------|------|-------------|---------|
| 1 | Name | ServiceCIDRのリソース名 | obj.Name | 文字列 |
| 2 | CIDRs | IPアドレス範囲のリスト | obj.Spec.CIDRs | カンマ区切り文字列 |
| 3 | Age | 作成からの経過時間 | obj.CreationTimestamp | 相対時間 |

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | Name | 各ServiceCIDRの名前 | obj.Name | 文字列 | 可変 |
| 2 | CIDRs | CIDR一覧 | obj.Spec.CIDRs | カンマ区切り文字列 | 可変 |
| 3 | Age | 経過時間 | obj.CreationTimestamp | 相対時間 | 可変 |

### フッター部

フッター部は存在しない。

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | ServiceCIDRはクラスタスコープのため、Namespace指定は不要 | No |
| LabelSelector | ラベルによるフィルタリング | No |
| FieldSelector | フィールドによるフィルタリング | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | リスト取得順（APIサーバ返却順） | - |

### 改ページ条件

ターミナル出力のため改ページなし。

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/servicecidrs/ | ServiceCIDRリソースの格納先 | リソース名で直接アクセス |

### テーブル別参照項目詳細

#### ServiceCIDR

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | Name | - | - |
| spec.cidrs | CIDRs | - | strings.Joinでカンマ区切りに結合 |
| metadata.creationTimestamp | Age | - | translateTimestampSinceで相対時間化 |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| Age | 現在時刻 - CreationTimestamp | - | duration.HumanDurationで人間可読形式に変換 |
| CIDRs | strings.Join(obj.Spec.CIDRs, ",") | - | 配列をカンマ区切り文字列に変換 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get servicecidrs] --> B[APIサーバからServiceCIDRList取得]
    B --> C[各ServiceCIDRに対してprintServiceCIDR呼び出し]
    C --> D[Spec.CIDRsをカンマ区切りで結合]
    D --> E[TableRow生成]
    E --> F[HumanReadablePrinter.PrintObjでテーブル出力]
    F --> G[標準出力]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| データなし | ServiceCIDRが存在しない | `No resources found` | - |
| API接続エラー | APIサーバへの接続失敗 | 接続エラーメッセージ | kubeconfigの確認 |
| 権限エラー | ServiceCIDRのlist権限がない | `Forbidden` | RBACの設定確認 |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 1件〜数件（通常はデフォルトの1件） |
| 目標出力時間 | 1秒以内 |
| 同時出力数上限 | N/A |

## セキュリティ考慮事項

ServiceCIDRはクラスタ全体のサービスネットワーク設定を含むため、参照にはcluster-admin相当の権限が推奨される。出力内容にはクラスタのIPアドレス範囲情報が含まれるため、ネットワーク構成が露出する可能性がある。

## 備考

- CIDRsカラムはSpec.CIDRs配列をstrings.Joinでカンマ区切りに結合して表示する（printers.go 3097行目）
- 通常、IPv4とIPv6の両方のCIDRが設定される（デュアルスタック環境の場合）
- ServiceCIDRはクラスタ初期化時にデフォルトで1つ作成される

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | types.go | `pkg/apis/networking/types.go` | ServiceCIDR, ServiceCIDRSpec, ServiceCIDRListの構造体定義 |
| 1-2 | printers.go | `pkg/printers/internalversion/printers.go` | 715-722行目: serviceCIDRColumnDefinitionsの定義。3カラム（Name, CIDRs, Age）の定義を確認 |

**読解のコツ**: ServiceCIDRはnetworkingパッケージに定義されている。Spec.CIDRsは文字列配列（[]string）であり、IPv4/IPv6の両方のCIDRを含むことがある。

#### Step 2: エントリーポイントを理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 721-722行目: printServiceCIDR/printServiceCIDRListの登録 |

**主要処理フロー**:
1. **721行目**: serviceCIDRColumnDefinitionsとprintServiceCIDR関数がTableHandlerとして登録
2. **722行目**: serviceCIDRColumnDefinitionsとprintServiceCIDRList関数がTableHandlerとして登録

#### Step 3: 印刷処理を理解する

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3092-3100行目: printServiceCIDR関数。strings.Joinによるカンマ区切り結合 |
| 3-2 | printers.go | `pkg/printers/internalversion/printers.go` | 3102-3112行目: printServiceCIDRList関数 |

**主要処理フロー**:
- **3097行目**: strings.Join(obj.Spec.CIDRs, ",")でCIDR配列をカンマ区切り文字列に変換
- **3098行目**: obj.Name, cidrs, AgeをTableRowに追加

### プログラム呼び出し階層図

```
AddHandlers (printers.go:93)
    |
    +-- h.TableHandler(serviceCIDRColumnDefinitions, printServiceCIDR) (printers.go:721)
    +-- h.TableHandler(serviceCIDRColumnDefinitions, printServiceCIDRList) (printers.go:722)
            |
            +-- printServiceCIDR (printers.go:3092)
                    |
                    +-- strings.Join (標準ライブラリ)
                    +-- translateTimestampSince (printers.go内共通関数)
```

### データフロー図

```
[入力]                        [処理]                             [出力]

ServiceCIDR              printServiceCIDR()               TableRow
(etcd経由API取得)  --->  Name取得                       --> (HumanReadablePrinter
                          Spec.CIDRsをカンマ区切り結合       によりテーブル形式で
                          Age算出                           stdoutへ出力)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | ServiceCIDRのテーブル出力ロジック本体（715-722, 3092-3112行目） |
| tablegenerator.go | `pkg/printers/tablegenerator.go` | ソース | TableHandler登録・TableRow生成の共通基盤 |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル整形出力 |
| types.go | `pkg/apis/networking/types.go` | ソース | ServiceCIDR内部API型定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | ServiceCIDRテーブル出力のテストケース |
