# 帳票設計書 61-IPAddress一覧

## 概要

本ドキュメントは、KubernetesのIPAddressリソースをテーブル形式で一覧出力する帳票の設計書である。`kubectl get ipaddresses` コマンド実行時に、クラスタに登録されているIPAddressリソースの情報を人間が読みやすいテーブル形式で標準出力に出力する。

### 本帳票の処理概要

**業務上の目的・背景**：Kubernetesクラスタにおいて、Service CIDRから払い出されたIPアドレスの管理・追跡が必要である。IPAddressリソースはServiceやその他のリソースに割り当てられたIPアドレスを追跡するためのオブジェクトであり、ネットワーク管理者やクラスタ管理者がIPアドレスの使用状況を把握するために本帳票が必要である。

**帳票の利用シーン**：クラスタ管理者がIPアドレスの割り当て状況を確認する場合、特定のIPアドレスがどのリソース（Service等）に紐づいているかを調査する場合、IPアドレスの枯渇状況を確認する場合に利用される。

**主要な出力内容**：
1. Name - IPアドレスのリソース名（実際のIPアドレス文字列）
2. ParentRef - このIPアドレスを参照している親リソース（Group/Resource/Namespace/Name形式）

**帳票の出力タイミング**：`kubectl get ipaddresses` コマンドの実行時にAPIサーバからリソース情報を取得し、即座にテーブル形式で標準出力に出力される。

**帳票の利用者**：Kubernetesクラスタ管理者、ネットワーク管理者、SRE（サイト信頼性エンジニア）。

## 帳票種別

一覧表（リソーステーブル出力）

## 利用画面

| 画面No | 画面名 | URL/ルーティング | 出力操作 |
|--------|--------|-----------------|---------|
| - | CLI（ターミナル） | - | `kubectl get ipaddresses` コマンド実行 |

## 出力形式

### 基本仕様

| 項目 | 内容 |
|-----|------|
| ファイル形式 | テキスト（標準出力） |
| 用紙サイズ | N/A（ターミナル出力） |
| 向き | N/A |
| ファイル名 | N/A（標準出力） |
| 出力方法 | 標準出力（stdout） |
| 文字コード | UTF-8 |

## 帳票レイアウト

### レイアウト概要

タブ区切りのテーブル形式で出力される。1行目がヘッダー行、2行目以降がデータ行となる。`tabwriter` パッケージにより列幅が自動調整される。

```
┌──────────────────────────────────────────────┐
│  NAME          PARENTREF                      │
├──────────────────────────────────────────────┤
│  10.96.0.1     services/default/kubernetes     │
│  10.96.0.10    services/kube-system/kube-dns   │
└──────────────────────────────────────────────┘
```

### ヘッダー部

該当なし（テーブルヘッダー行として出力）

### 明細部

| No | 項目名 | 説明 | データ取得元 | 表示形式 | 列幅 |
|----|-------|------|-------------|---------|-----|
| 1 | NAME | IPアドレスリソース名 | obj.Name | 文字列 | 自動調整 |
| 2 | PARENTREF | 親リソース参照 | obj.Spec.ParentRef（Group/Resource/Namespace/Name形式） | 文字列（`<none>`の場合あり） | 自動調整 |

### フッター部

該当なし

## 出力条件

### 抽出条件

| 条件名 | 説明 | 必須 |
|-------|------|-----|
| Namespace | IPAddressはクラスタスコープリソースのためNamespace指定不要 | No |
| LabelSelector | ラベルによるフィルタリング（`-l`オプション） | No |
| FieldSelector | フィールドによるフィルタリング（`--field-selector`オプション） | No |

### ソート順

| 優先度 | 項目 | 昇順/降順 |
|-------|------|---------|
| 1 | Name | 昇順（APIサーバのデフォルト） |

### 改ページ条件

改ページなし（全件を連続出力）

## データベース参照仕様

### 参照テーブル一覧

| テーブル名 | 用途 | 結合条件 |
|-----------|------|---------|
| etcd: /registry/ipaddresses/ | IPAddressリソースの永続化ストア | APIサーバ経由でRESTアクセス |

### テーブル別参照項目詳細

#### IPAddress (networking.k8s.io/v1)

| 参照項目（フィールド名） | 帳票項目との対応 | 取得条件 | 備考 |
|-------------------|----------------|---------|------|
| metadata.name | NAME | LIST APIで一括取得 | IPアドレス文字列がそのまま名前 |
| spec.parentRef.group | PARENTREF（一部） | 同上 | GroupResource文字列構築に使用 |
| spec.parentRef.resource | PARENTREF（一部） | 同上 | 同上 |
| spec.parentRef.namespace | PARENTREF（一部） | 同上 | 空の場合は省略 |
| spec.parentRef.name | PARENTREF（一部） | 同上 | 最終セグメント |

## 計算仕様

### 計算項目一覧

| 項目名 | 計算式 | 端数処理 | 備考 |
|-------|-------|---------|------|
| ParentRef表示文字列 | `lowercase(group/resource) + "/" + namespace + "/" + name` | N/A | parentRefがnilの場合は`<none>`を表示。namespaceが空の場合はnamespaceセグメントを省略 |

## 処理フロー

### 出力フロー

```mermaid
flowchart TD
    A[kubectl get ipaddresses 実行] --> B[コマンド引数・フラグ解析]
    B --> C[APIサーバへIPAddress LIST リクエスト]
    C --> D[サーバサイドでテーブル変換]
    D --> E[metav1.Table形式でレスポンス]
    E --> F[HumanReadablePrinter.PrintObj]
    F --> G[テーブルヘッダー出力]
    G --> H[各行のセル値を出力]
    H --> I[tabwriterでフラッシュ]
    I --> J[標準出力に表示]
```

## エラー処理

### エラーケース一覧

| エラー種別 | 発生条件 | 表示メッセージ | 対処方法 |
|----------|---------|--------------|---------|
| APIサーバ接続エラー | クラスタに接続できない場合 | `The connection to the server ... was refused` | kubeconfig設定確認 |
| 権限エラー | IPAddressリソースのlist権限がない場合 | `Error from server (Forbidden): ...` | RBAC設定確認 |
| リソースなし | IPAddressリソースが存在しない場合 | `No resources found` | 正常動作（データなし） |

## パフォーマンス要件

| 項目 | 内容 |
|-----|------|
| 想定データ件数 | 数百〜数千件（ServiceやEndpoint数に依存） |
| 目標出力時間 | APIサーバレスポンスに依存（通常1秒以内） |
| 同時出力数上限 | N/A（CLI単発実行） |

## セキュリティ考慮事項

IPAddressリソースの閲覧にはRBACによるlist/get権限が必要である。IPアドレス情報自体はネットワーク構成情報であり、クラスタ外部への漏洩に注意が必要。

## 備考

- IPAddressリソースはKubernetes v1.27以降でAlpha、v1.31以降でBetaとして利用可能
- `-o wide` オプションでは追加カラムは定義されていない（Priorityが0のカラムのみ）
- `-o json`, `-o yaml` 等の出力フォーマット切り替えにも対応

---

## コードリーディングガイド

本帳票を理解するために参照すべきファイルと、推奨する読み解き順序を以下に示す。

### 推奨読解順序

#### Step 1: データ構造を理解する

IPAddressリソースの内部表現と、テーブル出力時のカラム定義を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 1-1 | printers.go | `pkg/printers/internalversion/printers.go` | 724-730行目: ipAddressColumnDefinitionsでName, ParentRefの2カラムが定義されている |

**読解のコツ**: `TableColumnDefinition`の`Format: "name"`はkubectlが`--sort-by`やリソース種別プレフィックス付与に利用する特殊フォーマット指定である。

#### Step 2: エントリーポイントを理解する

テーブル出力のエントリーポイントであるprintIPAddress関数を理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 2-1 | printers.go | `pkg/printers/internalversion/printers.go` | 3114-3147行目: printIPAddress関数とprintIPAddressList関数 |

**主要処理フロー**:
1. **3114行目**: `printIPAddress`関数の定義。`networking.IPAddress`オブジェクトと`GenerateOptions`を受け取る
2. **3119-3130行目**: ParentRefの表示文字列構築。nilの場合は`<none>`、存在する場合はGroup/Resource/Namespace/Name形式
3. **3131行目**: `translateTimestampSince`でAge（不使用だがカラム定義にはない）
4. **3132行目**: Name, ParentRef, Ageをセルに追加（但しカラム定義はName, ParentRefの2つのみのため、表示はこの2カラム）

#### Step 3: テーブル出力エンジンを理解する

HumanReadablePrinterがmetav1.Tableをどのように標準出力に書き出すかを理解する。

| 順序 | ファイル | パス | 読解ポイント |
|-----|---------|------|-------------|
| 3-1 | tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | 95-167行目: PrintObj関数でmetav1.Tableを受け取り、printTable関数でテーブルを出力 |

**主要処理フロー**:
- **97行目**: tabwriter.Writerでない場合はラップする
- **111行目**: `*metav1.Table`型の場合のテーブル出力分岐
- **172-234行目**: `printTable`関数で実際のヘッダーとデータ行を出力

### プログラム呼び出し階層図

```
kubectl get ipaddresses
    |
    +-- APIサーバ (LIST /apis/networking.k8s.io/v1/ipaddresses)
    |       |
    |       +-- TableConvertor (サーバサイドテーブル変換)
    |               |
    |               +-- printIPAddress() [pkg/printers/internalversion/printers.go:3114]
    |                       |
    |                       +-- translateTimestampSince() [tableprinter.go:583]
    |
    +-- HumanReadablePrinter.PrintObj() [tableprinter.go:95]
            |
            +-- decorateTable() [tableprinter.go:309]
            |
            +-- printTable() [tableprinter.go:172]
```

### データフロー図

```
[入力]                    [処理]                              [出力]

etcd IPAddress     -->  APIサーバ LIST                  -->  metav1.Table
リソース一覧              (サーバサイドテーブル変換)

metav1.Table       -->  HumanReadablePrinter.PrintObj  -->  標準出力
                        (tabwriter整形)                     (テーブル形式テキスト)
```

### 関連ファイル一覧

| ファイル | パス | 種別 | 役割 |
|---------|------|------|------|
| printers.go | `pkg/printers/internalversion/printers.go` | ソース | IPAddressのカラム定義とテーブル行生成ロジック |
| tableprinter.go | `staging/src/k8s.io/cli-runtime/pkg/printers/tableprinter.go` | ソース | HumanReadablePrinterによるテーブル出力エンジン |
| interface.go | `staging/src/k8s.io/cli-runtime/pkg/printers/interface.go` | ソース | ResourcePrinterインターフェース定義 |
| printers_test.go | `pkg/printers/internalversion/printers_test.go` | テスト | printIPAddress関数のテストケース |
